/*
 * Decompiled with CFR 0.152.
 */
package io.suger.api;

import com.google.gson.reflect.TypeToken;
import io.suger.ApiCallback;
import io.suger.ApiClient;
import io.suger.ApiException;
import io.suger.ApiResponse;
import io.suger.Configuration;
import io.suger.Pair;
import io.suger.client.BillingWallet;
import io.suger.client.CreateBuyerParams;
import io.suger.client.IdentityBuyer;
import io.suger.client.UpdateBuyerParams;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class BuyerApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BuyerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BuyerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call closeCreditWalletCall(String orgId, String buyerId, String walletId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}/wallet/{walletId}/close".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString())).replace("{walletId}", this.localVarApiClient.escapeString(walletId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call closeCreditWalletValidateBeforeCall(String orgId, String buyerId, String walletId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling closeCreditWallet(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling closeCreditWallet(Async)");
        }
        if (walletId == null) {
            throw new ApiException("Missing the required parameter 'walletId' when calling closeCreditWallet(Async)");
        }
        return this.closeCreditWalletCall(orgId, buyerId, walletId, _callback);
    }

    public BillingWallet closeCreditWallet(String orgId, String buyerId, String walletId) throws ApiException {
        ApiResponse<BillingWallet> localVarResp = this.closeCreditWalletWithHttpInfo(orgId, buyerId, walletId);
        return localVarResp.getData();
    }

    public ApiResponse<BillingWallet> closeCreditWalletWithHttpInfo(String orgId, String buyerId, String walletId) throws ApiException {
        Call localVarCall = this.closeCreditWalletValidateBeforeCall(orgId, buyerId, walletId, null);
        Type localVarReturnType = new TypeToken<BillingWallet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call closeCreditWalletAsync(String orgId, String buyerId, String walletId, ApiCallback<BillingWallet> _callback) throws ApiException {
        Call localVarCall = this.closeCreditWalletValidateBeforeCall(orgId, buyerId, walletId, _callback);
        Type localVarReturnType = new TypeToken<BillingWallet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createBuyerCall(String orgId, CreateBuyerParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateBuyerParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/buyer".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBuyerValidateBeforeCall(String orgId, CreateBuyerParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createBuyer(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling createBuyer(Async)");
        }
        return this.createBuyerCall(orgId, data, _callback);
    }

    public IdentityBuyer createBuyer(String orgId, CreateBuyerParams data) throws ApiException {
        ApiResponse<IdentityBuyer> localVarResp = this.createBuyerWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<IdentityBuyer> createBuyerWithHttpInfo(String orgId, CreateBuyerParams data) throws ApiException {
        Call localVarCall = this.createBuyerValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createBuyerAsync(String orgId, CreateBuyerParams data, ApiCallback<IdentityBuyer> _callback) throws ApiException {
        Call localVarCall = this.createBuyerValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createCreditWalletCall(String orgId, String buyerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}/wallet".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCreditWalletValidateBeforeCall(String orgId, String buyerId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createCreditWallet(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling createCreditWallet(Async)");
        }
        return this.createCreditWalletCall(orgId, buyerId, _callback);
    }

    public BillingWallet createCreditWallet(String orgId, String buyerId) throws ApiException {
        ApiResponse<BillingWallet> localVarResp = this.createCreditWalletWithHttpInfo(orgId, buyerId);
        return localVarResp.getData();
    }

    public ApiResponse<BillingWallet> createCreditWalletWithHttpInfo(String orgId, String buyerId) throws ApiException {
        Call localVarCall = this.createCreditWalletValidateBeforeCall(orgId, buyerId, null);
        Type localVarReturnType = new TypeToken<BillingWallet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCreditWalletAsync(String orgId, String buyerId, ApiCallback<BillingWallet> _callback) throws ApiException {
        Call localVarCall = this.createCreditWalletValidateBeforeCall(orgId, buyerId, _callback);
        Type localVarReturnType = new TypeToken<BillingWallet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteBuyerWalletCall(String orgId, String buyerId, String walletId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}/wallet/{walletId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString())).replace("{walletId}", this.localVarApiClient.escapeString(walletId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBuyerWalletValidateBeforeCall(String orgId, String buyerId, String walletId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling deleteBuyerWallet(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling deleteBuyerWallet(Async)");
        }
        if (walletId == null) {
            throw new ApiException("Missing the required parameter 'walletId' when calling deleteBuyerWallet(Async)");
        }
        return this.deleteBuyerWalletCall(orgId, buyerId, walletId, _callback);
    }

    public String deleteBuyerWallet(String orgId, String buyerId, String walletId) throws ApiException {
        ApiResponse<String> localVarResp = this.deleteBuyerWalletWithHttpInfo(orgId, buyerId, walletId);
        return localVarResp.getData();
    }

    public ApiResponse<String> deleteBuyerWalletWithHttpInfo(String orgId, String buyerId, String walletId) throws ApiException {
        Call localVarCall = this.deleteBuyerWalletValidateBeforeCall(orgId, buyerId, walletId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteBuyerWalletAsync(String orgId, String buyerId, String walletId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.deleteBuyerWalletValidateBeforeCall(orgId, buyerId, walletId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBuyerCall(String orgId, String buyerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBuyerValidateBeforeCall(String orgId, String buyerId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getBuyer(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling getBuyer(Async)");
        }
        return this.getBuyerCall(orgId, buyerId, _callback);
    }

    public IdentityBuyer getBuyer(String orgId, String buyerId) throws ApiException {
        ApiResponse<IdentityBuyer> localVarResp = this.getBuyerWithHttpInfo(orgId, buyerId);
        return localVarResp.getData();
    }

    public ApiResponse<IdentityBuyer> getBuyerWithHttpInfo(String orgId, String buyerId) throws ApiException {
        Call localVarCall = this.getBuyerValidateBeforeCall(orgId, buyerId, null);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBuyerAsync(String orgId, String buyerId, ApiCallback<IdentityBuyer> _callback) throws ApiException {
        Call localVarCall = this.getBuyerValidateBeforeCall(orgId, buyerId, _callback);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listBuyerWalletsCall(String orgId, String buyerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}/wallet".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listBuyerWalletsValidateBeforeCall(String orgId, String buyerId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listBuyerWallets(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling listBuyerWallets(Async)");
        }
        return this.listBuyerWalletsCall(orgId, buyerId, _callback);
    }

    public List<BillingWallet> listBuyerWallets(String orgId, String buyerId) throws ApiException {
        ApiResponse<List<BillingWallet>> localVarResp = this.listBuyerWalletsWithHttpInfo(orgId, buyerId);
        return localVarResp.getData();
    }

    public ApiResponse<List<BillingWallet>> listBuyerWalletsWithHttpInfo(String orgId, String buyerId) throws ApiException {
        Call localVarCall = this.listBuyerWalletsValidateBeforeCall(orgId, buyerId, null);
        Type localVarReturnType = new TypeToken<List<BillingWallet>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listBuyerWalletsAsync(String orgId, String buyerId, ApiCallback<List<BillingWallet>> _callback) throws ApiException {
        Call localVarCall = this.listBuyerWalletsValidateBeforeCall(orgId, buyerId, _callback);
        Type localVarReturnType = new TypeToken<List<BillingWallet>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listBuyersCall(String orgId, String partner, String contactId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (partner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("partner", partner));
        }
        if (contactId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contactId", contactId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listBuyersValidateBeforeCall(String orgId, String partner, String contactId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listBuyers(Async)");
        }
        return this.listBuyersCall(orgId, partner, contactId, limit, offset, _callback);
    }

    public List<IdentityBuyer> listBuyers(String orgId, String partner, String contactId, Integer limit, Integer offset) throws ApiException {
        ApiResponse<List<IdentityBuyer>> localVarResp = this.listBuyersWithHttpInfo(orgId, partner, contactId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<List<IdentityBuyer>> listBuyersWithHttpInfo(String orgId, String partner, String contactId, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listBuyersValidateBeforeCall(orgId, partner, contactId, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<IdentityBuyer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listBuyersAsync(String orgId, String partner, String contactId, Integer limit, Integer offset, ApiCallback<List<IdentityBuyer>> _callback) throws ApiException {
        Call localVarCall = this.listBuyersValidateBeforeCall(orgId, partner, contactId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<IdentityBuyer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setBuyerDefaultWalletCall(String orgId, String buyerId, String walletId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}/wallet/{walletId}/default".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString())).replace("{walletId}", this.localVarApiClient.escapeString(walletId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setBuyerDefaultWalletValidateBeforeCall(String orgId, String buyerId, String walletId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling setBuyerDefaultWallet(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling setBuyerDefaultWallet(Async)");
        }
        if (walletId == null) {
            throw new ApiException("Missing the required parameter 'walletId' when calling setBuyerDefaultWallet(Async)");
        }
        return this.setBuyerDefaultWalletCall(orgId, buyerId, walletId, _callback);
    }

    public IdentityBuyer setBuyerDefaultWallet(String orgId, String buyerId, String walletId) throws ApiException {
        ApiResponse<IdentityBuyer> localVarResp = this.setBuyerDefaultWalletWithHttpInfo(orgId, buyerId, walletId);
        return localVarResp.getData();
    }

    public ApiResponse<IdentityBuyer> setBuyerDefaultWalletWithHttpInfo(String orgId, String buyerId, String walletId) throws ApiException {
        Call localVarCall = this.setBuyerDefaultWalletValidateBeforeCall(orgId, buyerId, walletId, null);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setBuyerDefaultWalletAsync(String orgId, String buyerId, String walletId, ApiCallback<IdentityBuyer> _callback) throws ApiException {
        Call localVarCall = this.setBuyerDefaultWalletValidateBeforeCall(orgId, buyerId, walletId, _callback);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateBuyerCall(String orgId, String buyerId, UpdateBuyerParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateBuyerParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateBuyerValidateBeforeCall(String orgId, String buyerId, UpdateBuyerParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateBuyer(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling updateBuyer(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateBuyer(Async)");
        }
        return this.updateBuyerCall(orgId, buyerId, data, _callback);
    }

    public IdentityBuyer updateBuyer(String orgId, String buyerId, UpdateBuyerParams data) throws ApiException {
        ApiResponse<IdentityBuyer> localVarResp = this.updateBuyerWithHttpInfo(orgId, buyerId, data);
        return localVarResp.getData();
    }

    public ApiResponse<IdentityBuyer> updateBuyerWithHttpInfo(String orgId, String buyerId, UpdateBuyerParams data) throws ApiException {
        Call localVarCall = this.updateBuyerValidateBeforeCall(orgId, buyerId, data, null);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateBuyerAsync(String orgId, String buyerId, UpdateBuyerParams data, ApiCallback<IdentityBuyer> _callback) throws ApiException {
        Call localVarCall = this.updateBuyerValidateBeforeCall(orgId, buyerId, data, _callback);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCreditWalletCall(String orgId, String buyerId, String walletId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}/wallet/{walletId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString())).replace("{walletId}", this.localVarApiClient.escapeString(walletId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCreditWalletValidateBeforeCall(String orgId, String buyerId, String walletId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateCreditWallet(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling updateCreditWallet(Async)");
        }
        if (walletId == null) {
            throw new ApiException("Missing the required parameter 'walletId' when calling updateCreditWallet(Async)");
        }
        return this.updateCreditWalletCall(orgId, buyerId, walletId, _callback);
    }

    public BillingWallet updateCreditWallet(String orgId, String buyerId, String walletId) throws ApiException {
        ApiResponse<BillingWallet> localVarResp = this.updateCreditWalletWithHttpInfo(orgId, buyerId, walletId);
        return localVarResp.getData();
    }

    public ApiResponse<BillingWallet> updateCreditWalletWithHttpInfo(String orgId, String buyerId, String walletId) throws ApiException {
        Call localVarCall = this.updateCreditWalletValidateBeforeCall(orgId, buyerId, walletId, null);
        Type localVarReturnType = new TypeToken<BillingWallet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCreditWalletAsync(String orgId, String buyerId, String walletId, ApiCallback<BillingWallet> _callback) throws ApiException {
        Call localVarCall = this.updateCreditWalletValidateBeforeCall(orgId, buyerId, walletId, _callback);
        Type localVarReturnType = new TypeToken<BillingWallet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

