/*
 * Decompiled with CFR 0.152.
 */
package io.suger.api;

import com.google.gson.reflect.TypeToken;
import io.suger.ApiCallback;
import io.suger.ApiClient;
import io.suger.ApiException;
import io.suger.ApiResponse;
import io.suger.Configuration;
import io.suger.Pair;
import io.suger.client.IdentityBuyer;
import io.suger.client.IdentityContact;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ContactApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ContactApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContactApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addContactToBuyerCall(String orgId, String buyerId, String contactId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/contact/{contactId}/buyer/{buyerId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString())).replace("{contactId}", this.localVarApiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addContactToBuyerValidateBeforeCall(String orgId, String buyerId, String contactId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling addContactToBuyer(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling addContactToBuyer(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling addContactToBuyer(Async)");
        }
        return this.addContactToBuyerCall(orgId, buyerId, contactId, _callback);
    }

    public IdentityBuyer addContactToBuyer(String orgId, String buyerId, String contactId) throws ApiException {
        ApiResponse<IdentityBuyer> localVarResp = this.addContactToBuyerWithHttpInfo(orgId, buyerId, contactId);
        return localVarResp.getData();
    }

    public ApiResponse<IdentityBuyer> addContactToBuyerWithHttpInfo(String orgId, String buyerId, String contactId) throws ApiException {
        Call localVarCall = this.addContactToBuyerValidateBeforeCall(orgId, buyerId, contactId, null);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addContactToBuyerAsync(String orgId, String buyerId, String contactId, ApiCallback<IdentityBuyer> _callback) throws ApiException {
        Call localVarCall = this.addContactToBuyerValidateBeforeCall(orgId, buyerId, contactId, _callback);
        Type localVarReturnType = new TypeToken<IdentityBuyer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call addContactToOfferCall(String orgId, String contactId, String offerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/contact/{contactId}/offer/{offerId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{contactId}", this.localVarApiClient.escapeString(contactId.toString())).replace("{offerId}", this.localVarApiClient.escapeString(offerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addContactToOfferValidateBeforeCall(String orgId, String contactId, String offerId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling addContactToOffer(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling addContactToOffer(Async)");
        }
        if (offerId == null) {
            throw new ApiException("Missing the required parameter 'offerId' when calling addContactToOffer(Async)");
        }
        return this.addContactToOfferCall(orgId, contactId, offerId, _callback);
    }

    public String addContactToOffer(String orgId, String contactId, String offerId) throws ApiException {
        ApiResponse<String> localVarResp = this.addContactToOfferWithHttpInfo(orgId, contactId, offerId);
        return localVarResp.getData();
    }

    public ApiResponse<String> addContactToOfferWithHttpInfo(String orgId, String contactId, String offerId) throws ApiException {
        Call localVarCall = this.addContactToOfferValidateBeforeCall(orgId, contactId, offerId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addContactToOfferAsync(String orgId, String contactId, String offerId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.addContactToOfferValidateBeforeCall(orgId, contactId, offerId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call batchCreateContactsCall(String orgId, List<IdentityContact> data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<IdentityContact> localVarPostBody = data;
        String localVarPath = "/org/{orgId}/contact/batch".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call batchCreateContactsValidateBeforeCall(String orgId, List<IdentityContact> data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling batchCreateContacts(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling batchCreateContacts(Async)");
        }
        return this.batchCreateContactsCall(orgId, data, _callback);
    }

    public List<List<IdentityContact>> batchCreateContacts(String orgId, List<IdentityContact> data) throws ApiException {
        ApiResponse<List<List<IdentityContact>>> localVarResp = this.batchCreateContactsWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<List<List<IdentityContact>>> batchCreateContactsWithHttpInfo(String orgId, List<IdentityContact> data) throws ApiException {
        Call localVarCall = this.batchCreateContactsValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<List<List<IdentityContact>>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call batchCreateContactsAsync(String orgId, List<IdentityContact> data, ApiCallback<List<List<IdentityContact>>> _callback) throws ApiException {
        Call localVarCall = this.batchCreateContactsValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<List<List<IdentityContact>>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createContactCall(String orgId, IdentityContact data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IdentityContact localVarPostBody = data;
        String localVarPath = "/org/{orgId}/contact".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createContactValidateBeforeCall(String orgId, IdentityContact data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createContact(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling createContact(Async)");
        }
        return this.createContactCall(orgId, data, _callback);
    }

    public IdentityContact createContact(String orgId, IdentityContact data) throws ApiException {
        ApiResponse<IdentityContact> localVarResp = this.createContactWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<IdentityContact> createContactWithHttpInfo(String orgId, IdentityContact data) throws ApiException {
        Call localVarCall = this.createContactValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<IdentityContact>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createContactAsync(String orgId, IdentityContact data, ApiCallback<IdentityContact> _callback) throws ApiException {
        Call localVarCall = this.createContactValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<IdentityContact>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContactCall(String orgId, String contactId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/contact/{contactId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{contactId}", this.localVarApiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContactValidateBeforeCall(String orgId, String contactId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getContact(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling getContact(Async)");
        }
        return this.getContactCall(orgId, contactId, _callback);
    }

    public IdentityContact getContact(String orgId, String contactId) throws ApiException {
        ApiResponse<IdentityContact> localVarResp = this.getContactWithHttpInfo(orgId, contactId);
        return localVarResp.getData();
    }

    public ApiResponse<IdentityContact> getContactWithHttpInfo(String orgId, String contactId) throws ApiException {
        Call localVarCall = this.getContactValidateBeforeCall(orgId, contactId, null);
        Type localVarReturnType = new TypeToken<IdentityContact>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContactAsync(String orgId, String contactId, ApiCallback<IdentityContact> _callback) throws ApiException {
        Call localVarCall = this.getContactValidateBeforeCall(orgId, contactId, _callback);
        Type localVarReturnType = new TypeToken<IdentityContact>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listContactsByOrganizationCall(String orgId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/contact".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listContactsByOrganizationValidateBeforeCall(String orgId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listContactsByOrganization(Async)");
        }
        return this.listContactsByOrganizationCall(orgId, limit, offset, _callback);
    }

    public List<IdentityContact> listContactsByOrganization(String orgId, Integer limit, Integer offset) throws ApiException {
        ApiResponse<List<IdentityContact>> localVarResp = this.listContactsByOrganizationWithHttpInfo(orgId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<List<IdentityContact>> listContactsByOrganizationWithHttpInfo(String orgId, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listContactsByOrganizationValidateBeforeCall(orgId, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<IdentityContact>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listContactsByOrganizationAsync(String orgId, Integer limit, Integer offset, ApiCallback<List<IdentityContact>> _callback) throws ApiException {
        Call localVarCall = this.listContactsByOrganizationValidateBeforeCall(orgId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<IdentityContact>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call removeContactFromBuyerCall(String orgId, String buyerId, String contactId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/contact/{contactId}/buyer/{buyerId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString())).replace("{contactId}", this.localVarApiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call removeContactFromBuyerValidateBeforeCall(String orgId, String buyerId, String contactId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling removeContactFromBuyer(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling removeContactFromBuyer(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling removeContactFromBuyer(Async)");
        }
        return this.removeContactFromBuyerCall(orgId, buyerId, contactId, _callback);
    }

    public String removeContactFromBuyer(String orgId, String buyerId, String contactId) throws ApiException {
        ApiResponse<String> localVarResp = this.removeContactFromBuyerWithHttpInfo(orgId, buyerId, contactId);
        return localVarResp.getData();
    }

    public ApiResponse<String> removeContactFromBuyerWithHttpInfo(String orgId, String buyerId, String contactId) throws ApiException {
        Call localVarCall = this.removeContactFromBuyerValidateBeforeCall(orgId, buyerId, contactId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call removeContactFromBuyerAsync(String orgId, String buyerId, String contactId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.removeContactFromBuyerValidateBeforeCall(orgId, buyerId, contactId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call removeContactFromOfferCall(String orgId, String contactId, String offerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/contact/{contactId}/offer/{offerId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{contactId}", this.localVarApiClient.escapeString(contactId.toString())).replace("{offerId}", this.localVarApiClient.escapeString(offerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call removeContactFromOfferValidateBeforeCall(String orgId, String contactId, String offerId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling removeContactFromOffer(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling removeContactFromOffer(Async)");
        }
        if (offerId == null) {
            throw new ApiException("Missing the required parameter 'offerId' when calling removeContactFromOffer(Async)");
        }
        return this.removeContactFromOfferCall(orgId, contactId, offerId, _callback);
    }

    public String removeContactFromOffer(String orgId, String contactId, String offerId) throws ApiException {
        ApiResponse<String> localVarResp = this.removeContactFromOfferWithHttpInfo(orgId, contactId, offerId);
        return localVarResp.getData();
    }

    public ApiResponse<String> removeContactFromOfferWithHttpInfo(String orgId, String contactId, String offerId) throws ApiException {
        Call localVarCall = this.removeContactFromOfferValidateBeforeCall(orgId, contactId, offerId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call removeContactFromOfferAsync(String orgId, String contactId, String offerId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.removeContactFromOfferValidateBeforeCall(orgId, contactId, offerId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateContactCall(String orgId, String contactId, IdentityContact data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IdentityContact localVarPostBody = data;
        String localVarPath = "/org/{orgId}/contact/{contactId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{contactId}", this.localVarApiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateContactValidateBeforeCall(String orgId, String contactId, IdentityContact data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateContact(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling updateContact(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateContact(Async)");
        }
        return this.updateContactCall(orgId, contactId, data, _callback);
    }

    public IdentityContact updateContact(String orgId, String contactId, IdentityContact data) throws ApiException {
        ApiResponse<IdentityContact> localVarResp = this.updateContactWithHttpInfo(orgId, contactId, data);
        return localVarResp.getData();
    }

    public ApiResponse<IdentityContact> updateContactWithHttpInfo(String orgId, String contactId, IdentityContact data) throws ApiException {
        Call localVarCall = this.updateContactValidateBeforeCall(orgId, contactId, data, null);
        Type localVarReturnType = new TypeToken<IdentityContact>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateContactAsync(String orgId, String contactId, IdentityContact data, ApiCallback<IdentityContact> _callback) throws ApiException {
        Call localVarCall = this.updateContactValidateBeforeCall(orgId, contactId, data, _callback);
        Type localVarReturnType = new TypeToken<IdentityContact>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

