/*
 * Decompiled with CFR 0.152.
 */
package io.suger.api;

import com.google.gson.reflect.TypeToken;
import io.suger.ApiCallback;
import io.suger.ApiClient;
import io.suger.ApiException;
import io.suger.ApiResponse;
import io.suger.Configuration;
import io.suger.Pair;
import io.suger.client.AddEntitlementCreditParams;
import io.suger.client.AddEntitlementCreditResponse;
import io.suger.client.BillingAddonRecord;
import io.suger.client.CancellationSchedule;
import io.suger.client.CreateEntitlementParams;
import io.suger.client.DivideEntitlementCommitParams;
import io.suger.client.GithubComSugerioMarketplaceServiceRdsDbLibUpdateEntitlementNameParams;
import io.suger.client.WorkloadEntitlement;
import io.suger.client.WorkloadEntitlementTerm;
import io.suger.client.WorkloadMetaInfo;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class EntitlementApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public EntitlementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EntitlementApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addEntitlementCreditCall(String orgId, String entitlementId, AddEntitlementCreditParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddEntitlementCreditParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/addCredit".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addEntitlementCreditValidateBeforeCall(String orgId, String entitlementId, AddEntitlementCreditParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling addEntitlementCredit(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling addEntitlementCredit(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling addEntitlementCredit(Async)");
        }
        return this.addEntitlementCreditCall(orgId, entitlementId, data, _callback);
    }

    public AddEntitlementCreditResponse addEntitlementCredit(String orgId, String entitlementId, AddEntitlementCreditParams data) throws ApiException {
        ApiResponse<AddEntitlementCreditResponse> localVarResp = this.addEntitlementCreditWithHttpInfo(orgId, entitlementId, data);
        return localVarResp.getData();
    }

    public ApiResponse<AddEntitlementCreditResponse> addEntitlementCreditWithHttpInfo(String orgId, String entitlementId, AddEntitlementCreditParams data) throws ApiException {
        Call localVarCall = this.addEntitlementCreditValidateBeforeCall(orgId, entitlementId, data, null);
        Type localVarReturnType = new TypeToken<AddEntitlementCreditResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addEntitlementCreditAsync(String orgId, String entitlementId, AddEntitlementCreditParams data, ApiCallback<AddEntitlementCreditResponse> _callback) throws ApiException {
        Call localVarCall = this.addEntitlementCreditValidateBeforeCall(orgId, entitlementId, data, _callback);
        Type localVarReturnType = new TypeToken<AddEntitlementCreditResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call applyAddonToEntitlementCall(String orgId, String entitlementId, BillingAddonRecord data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BillingAddonRecord localVarPostBody = data;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/addon".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyAddonToEntitlementValidateBeforeCall(String orgId, String entitlementId, BillingAddonRecord data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling applyAddonToEntitlement(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling applyAddonToEntitlement(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling applyAddonToEntitlement(Async)");
        }
        return this.applyAddonToEntitlementCall(orgId, entitlementId, data, _callback);
    }

    public WorkloadEntitlement applyAddonToEntitlement(String orgId, String entitlementId, BillingAddonRecord data) throws ApiException {
        ApiResponse<WorkloadEntitlement> localVarResp = this.applyAddonToEntitlementWithHttpInfo(orgId, entitlementId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlement> applyAddonToEntitlementWithHttpInfo(String orgId, String entitlementId, BillingAddonRecord data) throws ApiException {
        Call localVarCall = this.applyAddonToEntitlementValidateBeforeCall(orgId, entitlementId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call applyAddonToEntitlementAsync(String orgId, String entitlementId, BillingAddonRecord data, ApiCallback<WorkloadEntitlement> _callback) throws ApiException {
        Call localVarCall = this.applyAddonToEntitlementValidateBeforeCall(orgId, entitlementId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call approveEntitlementCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/approve".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call approveEntitlementValidateBeforeCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling approveEntitlement(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling approveEntitlement(Async)");
        }
        return this.approveEntitlementCall(orgId, entitlementId, _callback);
    }

    public WorkloadEntitlement approveEntitlement(String orgId, String entitlementId) throws ApiException {
        ApiResponse<WorkloadEntitlement> localVarResp = this.approveEntitlementWithHttpInfo(orgId, entitlementId);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlement> approveEntitlementWithHttpInfo(String orgId, String entitlementId) throws ApiException {
        Call localVarCall = this.approveEntitlementValidateBeforeCall(orgId, entitlementId, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call approveEntitlementAsync(String orgId, String entitlementId, ApiCallback<WorkloadEntitlement> _callback) throws ApiException {
        Call localVarCall = this.approveEntitlementValidateBeforeCall(orgId, entitlementId, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelEntitlementCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/cancel".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelEntitlementValidateBeforeCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling cancelEntitlement(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling cancelEntitlement(Async)");
        }
        return this.cancelEntitlementCall(orgId, entitlementId, _callback);
    }

    public WorkloadEntitlement cancelEntitlement(String orgId, String entitlementId) throws ApiException {
        ApiResponse<WorkloadEntitlement> localVarResp = this.cancelEntitlementWithHttpInfo(orgId, entitlementId);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlement> cancelEntitlementWithHttpInfo(String orgId, String entitlementId) throws ApiException {
        Call localVarCall = this.cancelEntitlementValidateBeforeCall(orgId, entitlementId, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelEntitlementAsync(String orgId, String entitlementId, ApiCallback<WorkloadEntitlement> _callback) throws ApiException {
        Call localVarCall = this.cancelEntitlementValidateBeforeCall(orgId, entitlementId, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createEntitlementCall(String orgId, CreateEntitlementParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateEntitlementParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/entitlement".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createEntitlementValidateBeforeCall(String orgId, CreateEntitlementParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createEntitlement(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling createEntitlement(Async)");
        }
        return this.createEntitlementCall(orgId, data, _callback);
    }

    public WorkloadEntitlement createEntitlement(String orgId, CreateEntitlementParams data) throws ApiException {
        ApiResponse<WorkloadEntitlement> localVarResp = this.createEntitlementWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlement> createEntitlementWithHttpInfo(String orgId, CreateEntitlementParams data) throws ApiException {
        Call localVarCall = this.createEntitlementValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createEntitlementAsync(String orgId, CreateEntitlementParams data, ApiCallback<WorkloadEntitlement> _callback) throws ApiException {
        Call localVarCall = this.createEntitlementValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteEntitlementTermCall(String orgId, String entitlementId, String entitlementTermId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/entitlementTerm/{entitlementTermId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString())).replace("{entitlementTermId}", this.localVarApiClient.escapeString(entitlementTermId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteEntitlementTermValidateBeforeCall(String orgId, String entitlementId, String entitlementTermId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling deleteEntitlementTerm(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling deleteEntitlementTerm(Async)");
        }
        if (entitlementTermId == null) {
            throw new ApiException("Missing the required parameter 'entitlementTermId' when calling deleteEntitlementTerm(Async)");
        }
        return this.deleteEntitlementTermCall(orgId, entitlementId, entitlementTermId, _callback);
    }

    public String deleteEntitlementTerm(String orgId, String entitlementId, String entitlementTermId) throws ApiException {
        ApiResponse<String> localVarResp = this.deleteEntitlementTermWithHttpInfo(orgId, entitlementId, entitlementTermId);
        return localVarResp.getData();
    }

    public ApiResponse<String> deleteEntitlementTermWithHttpInfo(String orgId, String entitlementId, String entitlementTermId) throws ApiException {
        Call localVarCall = this.deleteEntitlementTermValidateBeforeCall(orgId, entitlementId, entitlementTermId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteEntitlementTermAsync(String orgId, String entitlementId, String entitlementTermId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.deleteEntitlementTermValidateBeforeCall(orgId, entitlementId, entitlementTermId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call divideEntitlementCommitCall(String orgId, String entitlementId, DivideEntitlementCommitParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DivideEntitlementCommitParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/divideCommit".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call divideEntitlementCommitValidateBeforeCall(String orgId, String entitlementId, DivideEntitlementCommitParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling divideEntitlementCommit(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling divideEntitlementCommit(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling divideEntitlementCommit(Async)");
        }
        return this.divideEntitlementCommitCall(orgId, entitlementId, data, _callback);
    }

    public String divideEntitlementCommit(String orgId, String entitlementId, DivideEntitlementCommitParams data) throws ApiException {
        ApiResponse<String> localVarResp = this.divideEntitlementCommitWithHttpInfo(orgId, entitlementId, data);
        return localVarResp.getData();
    }

    public ApiResponse<String> divideEntitlementCommitWithHttpInfo(String orgId, String entitlementId, DivideEntitlementCommitParams data) throws ApiException {
        Call localVarCall = this.divideEntitlementCommitValidateBeforeCall(orgId, entitlementId, data, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call divideEntitlementCommitAsync(String orgId, String entitlementId, DivideEntitlementCommitParams data, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.divideEntitlementCommitValidateBeforeCall(orgId, entitlementId, data, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEntitlementCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEntitlementValidateBeforeCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getEntitlement(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling getEntitlement(Async)");
        }
        return this.getEntitlementCall(orgId, entitlementId, _callback);
    }

    public WorkloadEntitlement getEntitlement(String orgId, String entitlementId) throws ApiException {
        ApiResponse<WorkloadEntitlement> localVarResp = this.getEntitlementWithHttpInfo(orgId, entitlementId);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlement> getEntitlementWithHttpInfo(String orgId, String entitlementId) throws ApiException {
        Call localVarCall = this.getEntitlementValidateBeforeCall(orgId, entitlementId, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEntitlementAsync(String orgId, String entitlementId, ApiCallback<WorkloadEntitlement> _callback) throws ApiException {
        Call localVarCall = this.getEntitlementValidateBeforeCall(orgId, entitlementId, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEntitlementTermCall(String orgId, String entitlementId, String entitlementTermId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/entitlementTerm/{entitlementTermId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString())).replace("{entitlementTermId}", this.localVarApiClient.escapeString(entitlementTermId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEntitlementTermValidateBeforeCall(String orgId, String entitlementId, String entitlementTermId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getEntitlementTerm(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling getEntitlementTerm(Async)");
        }
        if (entitlementTermId == null) {
            throw new ApiException("Missing the required parameter 'entitlementTermId' when calling getEntitlementTerm(Async)");
        }
        return this.getEntitlementTermCall(orgId, entitlementId, entitlementTermId, _callback);
    }

    public WorkloadEntitlementTerm getEntitlementTerm(String orgId, String entitlementId, String entitlementTermId) throws ApiException {
        ApiResponse<WorkloadEntitlementTerm> localVarResp = this.getEntitlementTermWithHttpInfo(orgId, entitlementId, entitlementTermId);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlementTerm> getEntitlementTermWithHttpInfo(String orgId, String entitlementId, String entitlementTermId) throws ApiException {
        Call localVarCall = this.getEntitlementTermValidateBeforeCall(orgId, entitlementId, entitlementTermId, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlementTerm>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEntitlementTermAsync(String orgId, String entitlementId, String entitlementTermId, ApiCallback<WorkloadEntitlementTerm> _callback) throws ApiException {
        Call localVarCall = this.getEntitlementTermValidateBeforeCall(orgId, entitlementId, entitlementTermId, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlementTerm>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listEntitlementTermsCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/entitlementTerm".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listEntitlementTermsValidateBeforeCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listEntitlementTerms(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling listEntitlementTerms(Async)");
        }
        return this.listEntitlementTermsCall(orgId, entitlementId, _callback);
    }

    public List<WorkloadEntitlementTerm> listEntitlementTerms(String orgId, String entitlementId) throws ApiException {
        ApiResponse<List<WorkloadEntitlementTerm>> localVarResp = this.listEntitlementTermsWithHttpInfo(orgId, entitlementId);
        return localVarResp.getData();
    }

    public ApiResponse<List<WorkloadEntitlementTerm>> listEntitlementTermsWithHttpInfo(String orgId, String entitlementId) throws ApiException {
        Call localVarCall = this.listEntitlementTermsValidateBeforeCall(orgId, entitlementId, null);
        Type localVarReturnType = new TypeToken<List<WorkloadEntitlementTerm>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listEntitlementTermsAsync(String orgId, String entitlementId, ApiCallback<List<WorkloadEntitlementTerm>> _callback) throws ApiException {
        Call localVarCall = this.listEntitlementTermsValidateBeforeCall(orgId, entitlementId, _callback);
        Type localVarReturnType = new TypeToken<List<WorkloadEntitlementTerm>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listEntitlementsCall(String orgId, String partner, String productId, String offerId, String buyerId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (partner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("partner", partner));
        }
        if (productId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("productId", productId));
        }
        if (offerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offerId", offerId));
        }
        if (buyerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buyerId", buyerId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listEntitlementsValidateBeforeCall(String orgId, String partner, String productId, String offerId, String buyerId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listEntitlements(Async)");
        }
        return this.listEntitlementsCall(orgId, partner, productId, offerId, buyerId, limit, offset, _callback);
    }

    public List<WorkloadEntitlement> listEntitlements(String orgId, String partner, String productId, String offerId, String buyerId, Integer limit, Integer offset) throws ApiException {
        ApiResponse<List<WorkloadEntitlement>> localVarResp = this.listEntitlementsWithHttpInfo(orgId, partner, productId, offerId, buyerId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<List<WorkloadEntitlement>> listEntitlementsWithHttpInfo(String orgId, String partner, String productId, String offerId, String buyerId, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listEntitlementsValidateBeforeCall(orgId, partner, productId, offerId, buyerId, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<WorkloadEntitlement>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listEntitlementsAsync(String orgId, String partner, String productId, String offerId, String buyerId, Integer limit, Integer offset, ApiCallback<List<WorkloadEntitlement>> _callback) throws ApiException {
        Call localVarCall = this.listEntitlementsValidateBeforeCall(orgId, partner, productId, offerId, buyerId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<WorkloadEntitlement>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call scheduleEntitlementCancellationCall(String orgId, String entitlementId, CancellationSchedule data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CancellationSchedule localVarPostBody = data;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/scheduleCancellation".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call scheduleEntitlementCancellationValidateBeforeCall(String orgId, String entitlementId, CancellationSchedule data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling scheduleEntitlementCancellation(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling scheduleEntitlementCancellation(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling scheduleEntitlementCancellation(Async)");
        }
        return this.scheduleEntitlementCancellationCall(orgId, entitlementId, data, _callback);
    }

    public WorkloadEntitlement scheduleEntitlementCancellation(String orgId, String entitlementId, CancellationSchedule data) throws ApiException {
        ApiResponse<WorkloadEntitlement> localVarResp = this.scheduleEntitlementCancellationWithHttpInfo(orgId, entitlementId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlement> scheduleEntitlementCancellationWithHttpInfo(String orgId, String entitlementId, CancellationSchedule data) throws ApiException {
        Call localVarCall = this.scheduleEntitlementCancellationValidateBeforeCall(orgId, entitlementId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call scheduleEntitlementCancellationAsync(String orgId, String entitlementId, CancellationSchedule data, ApiCallback<WorkloadEntitlement> _callback) throws ApiException {
        Call localVarCall = this.scheduleEntitlementCancellationValidateBeforeCall(orgId, entitlementId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unscheduleEntitlementCancellationCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/unscheduleCancellation".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unscheduleEntitlementCancellationValidateBeforeCall(String orgId, String entitlementId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling unscheduleEntitlementCancellation(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling unscheduleEntitlementCancellation(Async)");
        }
        return this.unscheduleEntitlementCancellationCall(orgId, entitlementId, _callback);
    }

    public WorkloadEntitlement unscheduleEntitlementCancellation(String orgId, String entitlementId) throws ApiException {
        ApiResponse<WorkloadEntitlement> localVarResp = this.unscheduleEntitlementCancellationWithHttpInfo(orgId, entitlementId);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlement> unscheduleEntitlementCancellationWithHttpInfo(String orgId, String entitlementId) throws ApiException {
        Call localVarCall = this.unscheduleEntitlementCancellationValidateBeforeCall(orgId, entitlementId, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call unscheduleEntitlementCancellationAsync(String orgId, String entitlementId, ApiCallback<WorkloadEntitlement> _callback) throws ApiException {
        Call localVarCall = this.unscheduleEntitlementCancellationValidateBeforeCall(orgId, entitlementId, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateEntitlementMetaInfoCall(String orgId, String entitlementId, WorkloadMetaInfo data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WorkloadMetaInfo localVarPostBody = data;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/metaInfo".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateEntitlementMetaInfoValidateBeforeCall(String orgId, String entitlementId, WorkloadMetaInfo data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateEntitlementMetaInfo(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling updateEntitlementMetaInfo(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateEntitlementMetaInfo(Async)");
        }
        return this.updateEntitlementMetaInfoCall(orgId, entitlementId, data, _callback);
    }

    public WorkloadMetaInfo updateEntitlementMetaInfo(String orgId, String entitlementId, WorkloadMetaInfo data) throws ApiException {
        ApiResponse<WorkloadMetaInfo> localVarResp = this.updateEntitlementMetaInfoWithHttpInfo(orgId, entitlementId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadMetaInfo> updateEntitlementMetaInfoWithHttpInfo(String orgId, String entitlementId, WorkloadMetaInfo data) throws ApiException {
        Call localVarCall = this.updateEntitlementMetaInfoValidateBeforeCall(orgId, entitlementId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadMetaInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateEntitlementMetaInfoAsync(String orgId, String entitlementId, WorkloadMetaInfo data, ApiCallback<WorkloadMetaInfo> _callback) throws ApiException {
        Call localVarCall = this.updateEntitlementMetaInfoValidateBeforeCall(orgId, entitlementId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadMetaInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateEntitlementNameCall(String orgId, String entitlementId, GithubComSugerioMarketplaceServiceRdsDbLibUpdateEntitlementNameParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GithubComSugerioMarketplaceServiceRdsDbLibUpdateEntitlementNameParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/entitlementName".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateEntitlementNameValidateBeforeCall(String orgId, String entitlementId, GithubComSugerioMarketplaceServiceRdsDbLibUpdateEntitlementNameParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateEntitlementName(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling updateEntitlementName(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateEntitlementName(Async)");
        }
        return this.updateEntitlementNameCall(orgId, entitlementId, data, _callback);
    }

    public WorkloadEntitlement updateEntitlementName(String orgId, String entitlementId, GithubComSugerioMarketplaceServiceRdsDbLibUpdateEntitlementNameParams data) throws ApiException {
        ApiResponse<WorkloadEntitlement> localVarResp = this.updateEntitlementNameWithHttpInfo(orgId, entitlementId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlement> updateEntitlementNameWithHttpInfo(String orgId, String entitlementId, GithubComSugerioMarketplaceServiceRdsDbLibUpdateEntitlementNameParams data) throws ApiException {
        Call localVarCall = this.updateEntitlementNameValidateBeforeCall(orgId, entitlementId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateEntitlementNameAsync(String orgId, String entitlementId, GithubComSugerioMarketplaceServiceRdsDbLibUpdateEntitlementNameParams data, ApiCallback<WorkloadEntitlement> _callback) throws ApiException {
        Call localVarCall = this.updateEntitlementNameValidateBeforeCall(orgId, entitlementId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateEntitlementSeatCall(String orgId, String entitlementId, Integer newSeat, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/seat".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (newSeat != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("newSeat", newSeat));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateEntitlementSeatValidateBeforeCall(String orgId, String entitlementId, Integer newSeat, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateEntitlementSeat(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling updateEntitlementSeat(Async)");
        }
        if (newSeat == null) {
            throw new ApiException("Missing the required parameter 'newSeat' when calling updateEntitlementSeat(Async)");
        }
        return this.updateEntitlementSeatCall(orgId, entitlementId, newSeat, _callback);
    }

    public WorkloadEntitlement updateEntitlementSeat(String orgId, String entitlementId, Integer newSeat) throws ApiException {
        ApiResponse<WorkloadEntitlement> localVarResp = this.updateEntitlementSeatWithHttpInfo(orgId, entitlementId, newSeat);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadEntitlement> updateEntitlementSeatWithHttpInfo(String orgId, String entitlementId, Integer newSeat) throws ApiException {
        Call localVarCall = this.updateEntitlementSeatValidateBeforeCall(orgId, entitlementId, newSeat, null);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateEntitlementSeatAsync(String orgId, String entitlementId, Integer newSeat, ApiCallback<WorkloadEntitlement> _callback) throws ApiException {
        Call localVarCall = this.updateEntitlementSeatValidateBeforeCall(orgId, entitlementId, newSeat, _callback);
        Type localVarReturnType = new TypeToken<WorkloadEntitlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

