/*
 * Decompiled with CFR 0.152.
 */
package io.suger.api;

import com.google.gson.reflect.TypeToken;
import io.suger.ApiCallback;
import io.suger.ApiClient;
import io.suger.ApiException;
import io.suger.ApiResponse;
import io.suger.Configuration;
import io.suger.Pair;
import io.suger.client.BillableMetric;
import io.suger.client.CreateUsageRecordGroupParams;
import io.suger.client.ListUsageRecordGroupsResponse;
import io.suger.client.ListUsageRecordReportsResponse;
import io.suger.client.MeteringUsageRecordGroup;
import io.suger.client.NewUsageRecordGroup;
import io.suger.client.UpdateBillableMetricParams;
import io.suger.client.UsageMeteringConfigInfo;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class MeteringApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MeteringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MeteringApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call batchReportUsageRecordGroupsCall(String orgId, List<NewUsageRecordGroup> usageRecordGroups, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<NewUsageRecordGroup> localVarPostBody = usageRecordGroups;
        String localVarPath = "/org/{orgId}/batchCreateUsageRecordGroups".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call batchReportUsageRecordGroupsValidateBeforeCall(String orgId, List<NewUsageRecordGroup> usageRecordGroups, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling batchReportUsageRecordGroups(Async)");
        }
        if (usageRecordGroups == null) {
            throw new ApiException("Missing the required parameter 'usageRecordGroups' when calling batchReportUsageRecordGroups(Async)");
        }
        return this.batchReportUsageRecordGroupsCall(orgId, usageRecordGroups, _callback);
    }

    public List<MeteringUsageRecordGroup> batchReportUsageRecordGroups(String orgId, List<NewUsageRecordGroup> usageRecordGroups) throws ApiException {
        ApiResponse<List<MeteringUsageRecordGroup>> localVarResp = this.batchReportUsageRecordGroupsWithHttpInfo(orgId, usageRecordGroups);
        return localVarResp.getData();
    }

    public ApiResponse<List<MeteringUsageRecordGroup>> batchReportUsageRecordGroupsWithHttpInfo(String orgId, List<NewUsageRecordGroup> usageRecordGroups) throws ApiException {
        Call localVarCall = this.batchReportUsageRecordGroupsValidateBeforeCall(orgId, usageRecordGroups, null);
        Type localVarReturnType = new TypeToken<List<MeteringUsageRecordGroup>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call batchReportUsageRecordGroupsAsync(String orgId, List<NewUsageRecordGroup> usageRecordGroups, ApiCallback<List<MeteringUsageRecordGroup>> _callback) throws ApiException {
        Call localVarCall = this.batchReportUsageRecordGroupsValidateBeforeCall(orgId, usageRecordGroups, _callback);
        Type localVarReturnType = new TypeToken<List<MeteringUsageRecordGroup>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call batchValidateUsageRecordGroupsCall(String orgId, List<NewUsageRecordGroup> data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<NewUsageRecordGroup> localVarPostBody = data;
        String localVarPath = "/org/{orgId}/batchValidateUsageRecordGroups".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call batchValidateUsageRecordGroupsValidateBeforeCall(String orgId, List<NewUsageRecordGroup> data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling batchValidateUsageRecordGroups(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling batchValidateUsageRecordGroups(Async)");
        }
        return this.batchValidateUsageRecordGroupsCall(orgId, data, _callback);
    }

    public String batchValidateUsageRecordGroups(String orgId, List<NewUsageRecordGroup> data) throws ApiException {
        ApiResponse<String> localVarResp = this.batchValidateUsageRecordGroupsWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<String> batchValidateUsageRecordGroupsWithHttpInfo(String orgId, List<NewUsageRecordGroup> data) throws ApiException {
        Call localVarCall = this.batchValidateUsageRecordGroupsValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call batchValidateUsageRecordGroupsAsync(String orgId, List<NewUsageRecordGroup> data, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.batchValidateUsageRecordGroupsValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createBillableMetricCall(String orgId, BillableMetric data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BillableMetric localVarPostBody = data;
        String localVarPath = "/org/{orgId}/billableMetric".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBillableMetricValidateBeforeCall(String orgId, BillableMetric data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createBillableMetric(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling createBillableMetric(Async)");
        }
        return this.createBillableMetricCall(orgId, data, _callback);
    }

    public BillableMetric createBillableMetric(String orgId, BillableMetric data) throws ApiException {
        ApiResponse<BillableMetric> localVarResp = this.createBillableMetricWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<BillableMetric> createBillableMetricWithHttpInfo(String orgId, BillableMetric data) throws ApiException {
        Call localVarCall = this.createBillableMetricValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<BillableMetric>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createBillableMetricAsync(String orgId, BillableMetric data, ApiCallback<BillableMetric> _callback) throws ApiException {
        Call localVarCall = this.createBillableMetricValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<BillableMetric>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteUsageRecordGroupCall(String orgId, String usageRecordGroupId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/usageRecordGroup/{usageRecordGroupId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{usageRecordGroupId}", this.localVarApiClient.escapeString(usageRecordGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUsageRecordGroupValidateBeforeCall(String orgId, String usageRecordGroupId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling deleteUsageRecordGroup(Async)");
        }
        if (usageRecordGroupId == null) {
            throw new ApiException("Missing the required parameter 'usageRecordGroupId' when calling deleteUsageRecordGroup(Async)");
        }
        return this.deleteUsageRecordGroupCall(orgId, usageRecordGroupId, _callback);
    }

    public MeteringUsageRecordGroup deleteUsageRecordGroup(String orgId, String usageRecordGroupId) throws ApiException {
        ApiResponse<MeteringUsageRecordGroup> localVarResp = this.deleteUsageRecordGroupWithHttpInfo(orgId, usageRecordGroupId);
        return localVarResp.getData();
    }

    public ApiResponse<MeteringUsageRecordGroup> deleteUsageRecordGroupWithHttpInfo(String orgId, String usageRecordGroupId) throws ApiException {
        Call localVarCall = this.deleteUsageRecordGroupValidateBeforeCall(orgId, usageRecordGroupId, null);
        Type localVarReturnType = new TypeToken<MeteringUsageRecordGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteUsageRecordGroupAsync(String orgId, String usageRecordGroupId, ApiCallback<MeteringUsageRecordGroup> _callback) throws ApiException {
        Call localVarCall = this.deleteUsageRecordGroupValidateBeforeCall(orgId, usageRecordGroupId, _callback);
        Type localVarReturnType = new TypeToken<MeteringUsageRecordGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBillableMetricCall(String orgId, String billableMetricId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/billableMetric/{billableMetricId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{billableMetricId}", this.localVarApiClient.escapeString(billableMetricId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBillableMetricValidateBeforeCall(String orgId, String billableMetricId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getBillableMetric(Async)");
        }
        if (billableMetricId == null) {
            throw new ApiException("Missing the required parameter 'billableMetricId' when calling getBillableMetric(Async)");
        }
        return this.getBillableMetricCall(orgId, billableMetricId, _callback);
    }

    public BillableMetric getBillableMetric(String orgId, String billableMetricId) throws ApiException {
        ApiResponse<BillableMetric> localVarResp = this.getBillableMetricWithHttpInfo(orgId, billableMetricId);
        return localVarResp.getData();
    }

    public ApiResponse<BillableMetric> getBillableMetricWithHttpInfo(String orgId, String billableMetricId) throws ApiException {
        Call localVarCall = this.getBillableMetricValidateBeforeCall(orgId, billableMetricId, null);
        Type localVarReturnType = new TypeToken<BillableMetric>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBillableMetricAsync(String orgId, String billableMetricId, ApiCallback<BillableMetric> _callback) throws ApiException {
        Call localVarCall = this.getBillableMetricValidateBeforeCall(orgId, billableMetricId, _callback);
        Type localVarReturnType = new TypeToken<BillableMetric>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUsageMeteringConfigInfoCall(String orgId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/usageMeteringConfigInfo".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUsageMeteringConfigInfoValidateBeforeCall(String orgId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getUsageMeteringConfigInfo(Async)");
        }
        return this.getUsageMeteringConfigInfoCall(orgId, _callback);
    }

    public UsageMeteringConfigInfo getUsageMeteringConfigInfo(String orgId) throws ApiException {
        ApiResponse<UsageMeteringConfigInfo> localVarResp = this.getUsageMeteringConfigInfoWithHttpInfo(orgId);
        return localVarResp.getData();
    }

    public ApiResponse<UsageMeteringConfigInfo> getUsageMeteringConfigInfoWithHttpInfo(String orgId) throws ApiException {
        Call localVarCall = this.getUsageMeteringConfigInfoValidateBeforeCall(orgId, null);
        Type localVarReturnType = new TypeToken<UsageMeteringConfigInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUsageMeteringConfigInfoAsync(String orgId, ApiCallback<UsageMeteringConfigInfo> _callback) throws ApiException {
        Call localVarCall = this.getUsageMeteringConfigInfoValidateBeforeCall(orgId, _callback);
        Type localVarReturnType = new TypeToken<UsageMeteringConfigInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listBillableMetricsCall(String orgId, String status, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/billableMetric".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listBillableMetricsValidateBeforeCall(String orgId, String status, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listBillableMetrics(Async)");
        }
        return this.listBillableMetricsCall(orgId, status, _callback);
    }

    public List<BillableMetric> listBillableMetrics(String orgId, String status) throws ApiException {
        ApiResponse<List<BillableMetric>> localVarResp = this.listBillableMetricsWithHttpInfo(orgId, status);
        return localVarResp.getData();
    }

    public ApiResponse<List<BillableMetric>> listBillableMetricsWithHttpInfo(String orgId, String status) throws ApiException {
        Call localVarCall = this.listBillableMetricsValidateBeforeCall(orgId, status, null);
        Type localVarReturnType = new TypeToken<List<BillableMetric>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listBillableMetricsAsync(String orgId, String status, ApiCallback<List<BillableMetric>> _callback) throws ApiException {
        Call localVarCall = this.listBillableMetricsValidateBeforeCall(orgId, status, _callback);
        Type localVarReturnType = new TypeToken<List<BillableMetric>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUsageRecordGroupsCall(String orgId, String partner, String buyerId, String entitlementId, String status, String source, String metaInfo, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/usageRecordGroup".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (partner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("partner", partner));
        }
        if (buyerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buyerId", buyerId));
        }
        if (entitlementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entitlementId", entitlementId));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (source != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("source", source));
        }
        if (metaInfo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("metaInfo", metaInfo));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUsageRecordGroupsValidateBeforeCall(String orgId, String partner, String buyerId, String entitlementId, String status, String source, String metaInfo, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listUsageRecordGroups(Async)");
        }
        return this.listUsageRecordGroupsCall(orgId, partner, buyerId, entitlementId, status, source, metaInfo, startDate, endDate, limit, offset, _callback);
    }

    public ListUsageRecordGroupsResponse listUsageRecordGroups(String orgId, String partner, String buyerId, String entitlementId, String status, String source, String metaInfo, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListUsageRecordGroupsResponse> localVarResp = this.listUsageRecordGroupsWithHttpInfo(orgId, partner, buyerId, entitlementId, status, source, metaInfo, startDate, endDate, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListUsageRecordGroupsResponse> listUsageRecordGroupsWithHttpInfo(String orgId, String partner, String buyerId, String entitlementId, String status, String source, String metaInfo, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listUsageRecordGroupsValidateBeforeCall(orgId, partner, buyerId, entitlementId, status, source, metaInfo, startDate, endDate, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListUsageRecordGroupsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUsageRecordGroupsAsync(String orgId, String partner, String buyerId, String entitlementId, String status, String source, String metaInfo, String startDate, String endDate, Integer limit, Integer offset, ApiCallback<ListUsageRecordGroupsResponse> _callback) throws ApiException {
        Call localVarCall = this.listUsageRecordGroupsValidateBeforeCall(orgId, partner, buyerId, entitlementId, status, source, metaInfo, startDate, endDate, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListUsageRecordGroupsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUsageRecordReportsCall(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/usageRecordReport".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (partner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("partner", partner));
        }
        if (buyerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buyerId", buyerId));
        }
        if (entitlementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entitlementId", entitlementId));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUsageRecordReportsValidateBeforeCall(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listUsageRecordReports(Async)");
        }
        return this.listUsageRecordReportsCall(orgId, partner, buyerId, entitlementId, startDate, endDate, limit, offset, _callback);
    }

    public ListUsageRecordReportsResponse listUsageRecordReports(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListUsageRecordReportsResponse> localVarResp = this.listUsageRecordReportsWithHttpInfo(orgId, partner, buyerId, entitlementId, startDate, endDate, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListUsageRecordReportsResponse> listUsageRecordReportsWithHttpInfo(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listUsageRecordReportsValidateBeforeCall(orgId, partner, buyerId, entitlementId, startDate, endDate, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListUsageRecordReportsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUsageRecordReportsAsync(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback<ListUsageRecordReportsResponse> _callback) throws ApiException {
        Call localVarCall = this.listUsageRecordReportsValidateBeforeCall(orgId, partner, buyerId, entitlementId, startDate, endDate, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListUsageRecordReportsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call reportUsageRecordGroupCall(String orgId, String entitlementId, CreateUsageRecordGroupParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateUsageRecordGroupParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/usageRecordGroup".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call reportUsageRecordGroupValidateBeforeCall(String orgId, String entitlementId, CreateUsageRecordGroupParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling reportUsageRecordGroup(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling reportUsageRecordGroup(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling reportUsageRecordGroup(Async)");
        }
        return this.reportUsageRecordGroupCall(orgId, entitlementId, data, _callback);
    }

    public MeteringUsageRecordGroup reportUsageRecordGroup(String orgId, String entitlementId, CreateUsageRecordGroupParams data) throws ApiException {
        ApiResponse<MeteringUsageRecordGroup> localVarResp = this.reportUsageRecordGroupWithHttpInfo(orgId, entitlementId, data);
        return localVarResp.getData();
    }

    public ApiResponse<MeteringUsageRecordGroup> reportUsageRecordGroupWithHttpInfo(String orgId, String entitlementId, CreateUsageRecordGroupParams data) throws ApiException {
        Call localVarCall = this.reportUsageRecordGroupValidateBeforeCall(orgId, entitlementId, data, null);
        Type localVarReturnType = new TypeToken<MeteringUsageRecordGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call reportUsageRecordGroupAsync(String orgId, String entitlementId, CreateUsageRecordGroupParams data, ApiCallback<MeteringUsageRecordGroup> _callback) throws ApiException {
        Call localVarCall = this.reportUsageRecordGroupValidateBeforeCall(orgId, entitlementId, data, _callback);
        Type localVarReturnType = new TypeToken<MeteringUsageRecordGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call retryUsageRecordGroupCall(String orgId, String usageRecordGroupId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/usageRecordGroup/{usageRecordGroupId}/retry".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{usageRecordGroupId}", this.localVarApiClient.escapeString(usageRecordGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retryUsageRecordGroupValidateBeforeCall(String orgId, String usageRecordGroupId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling retryUsageRecordGroup(Async)");
        }
        if (usageRecordGroupId == null) {
            throw new ApiException("Missing the required parameter 'usageRecordGroupId' when calling retryUsageRecordGroup(Async)");
        }
        return this.retryUsageRecordGroupCall(orgId, usageRecordGroupId, _callback);
    }

    public MeteringUsageRecordGroup retryUsageRecordGroup(String orgId, String usageRecordGroupId) throws ApiException {
        ApiResponse<MeteringUsageRecordGroup> localVarResp = this.retryUsageRecordGroupWithHttpInfo(orgId, usageRecordGroupId);
        return localVarResp.getData();
    }

    public ApiResponse<MeteringUsageRecordGroup> retryUsageRecordGroupWithHttpInfo(String orgId, String usageRecordGroupId) throws ApiException {
        Call localVarCall = this.retryUsageRecordGroupValidateBeforeCall(orgId, usageRecordGroupId, null);
        Type localVarReturnType = new TypeToken<MeteringUsageRecordGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call retryUsageRecordGroupAsync(String orgId, String usageRecordGroupId, ApiCallback<MeteringUsageRecordGroup> _callback) throws ApiException {
        Call localVarCall = this.retryUsageRecordGroupValidateBeforeCall(orgId, usageRecordGroupId, _callback);
        Type localVarReturnType = new TypeToken<MeteringUsageRecordGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateBillableMetricCall(String orgId, String billableMetricId, UpdateBillableMetricParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateBillableMetricParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/billableMetric/{billableMetricId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{billableMetricId}", this.localVarApiClient.escapeString(billableMetricId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateBillableMetricValidateBeforeCall(String orgId, String billableMetricId, UpdateBillableMetricParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateBillableMetric(Async)");
        }
        if (billableMetricId == null) {
            throw new ApiException("Missing the required parameter 'billableMetricId' when calling updateBillableMetric(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateBillableMetric(Async)");
        }
        return this.updateBillableMetricCall(orgId, billableMetricId, data, _callback);
    }

    public BillableMetric updateBillableMetric(String orgId, String billableMetricId, UpdateBillableMetricParams data) throws ApiException {
        ApiResponse<BillableMetric> localVarResp = this.updateBillableMetricWithHttpInfo(orgId, billableMetricId, data);
        return localVarResp.getData();
    }

    public ApiResponse<BillableMetric> updateBillableMetricWithHttpInfo(String orgId, String billableMetricId, UpdateBillableMetricParams data) throws ApiException {
        Call localVarCall = this.updateBillableMetricValidateBeforeCall(orgId, billableMetricId, data, null);
        Type localVarReturnType = new TypeToken<BillableMetric>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateBillableMetricAsync(String orgId, String billableMetricId, UpdateBillableMetricParams data, ApiCallback<BillableMetric> _callback) throws ApiException {
        Call localVarCall = this.updateBillableMetricValidateBeforeCall(orgId, billableMetricId, data, _callback);
        Type localVarReturnType = new TypeToken<BillableMetric>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateUsageMeteringConfigInfoCall(String orgId, UsageMeteringConfigInfo data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UsageMeteringConfigInfo localVarPostBody = data;
        String localVarPath = "/org/{orgId}/usageMeteringConfigInfo".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateUsageMeteringConfigInfoValidateBeforeCall(String orgId, UsageMeteringConfigInfo data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateUsageMeteringConfigInfo(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateUsageMeteringConfigInfo(Async)");
        }
        return this.updateUsageMeteringConfigInfoCall(orgId, data, _callback);
    }

    public UsageMeteringConfigInfo updateUsageMeteringConfigInfo(String orgId, UsageMeteringConfigInfo data) throws ApiException {
        ApiResponse<UsageMeteringConfigInfo> localVarResp = this.updateUsageMeteringConfigInfoWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<UsageMeteringConfigInfo> updateUsageMeteringConfigInfoWithHttpInfo(String orgId, UsageMeteringConfigInfo data) throws ApiException {
        Call localVarCall = this.updateUsageMeteringConfigInfoValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<UsageMeteringConfigInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateUsageMeteringConfigInfoAsync(String orgId, UsageMeteringConfigInfo data, ApiCallback<UsageMeteringConfigInfo> _callback) throws ApiException {
        Call localVarCall = this.updateUsageMeteringConfigInfoValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<UsageMeteringConfigInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

