/*
 * Decompiled with CFR 0.152.
 */
package io.suger.api;

import com.google.gson.reflect.TypeToken;
import io.suger.ApiCallback;
import io.suger.ApiClient;
import io.suger.ApiException;
import io.suger.ApiResponse;
import io.suger.Configuration;
import io.suger.Pair;
import io.suger.client.ListNotificationEventsResponse;
import io.suger.client.ListNotificationMessagesResponse;
import io.suger.client.NotificationMessage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class NotificationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NotificationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotificationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getNotificationMessageCall(String orgId, String notificationMessageId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/notificationMessage/{notificationMessageId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{notificationMessageId}", this.localVarApiClient.escapeString(notificationMessageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNotificationMessageValidateBeforeCall(String orgId, String notificationMessageId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getNotificationMessage(Async)");
        }
        if (notificationMessageId == null) {
            throw new ApiException("Missing the required parameter 'notificationMessageId' when calling getNotificationMessage(Async)");
        }
        return this.getNotificationMessageCall(orgId, notificationMessageId, _callback);
    }

    public NotificationMessage getNotificationMessage(String orgId, String notificationMessageId) throws ApiException {
        ApiResponse<NotificationMessage> localVarResp = this.getNotificationMessageWithHttpInfo(orgId, notificationMessageId);
        return localVarResp.getData();
    }

    public ApiResponse<NotificationMessage> getNotificationMessageWithHttpInfo(String orgId, String notificationMessageId) throws ApiException {
        Call localVarCall = this.getNotificationMessageValidateBeforeCall(orgId, notificationMessageId, null);
        Type localVarReturnType = new TypeToken<NotificationMessage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNotificationMessageAsync(String orgId, String notificationMessageId, ApiCallback<NotificationMessage> _callback) throws ApiException {
        Call localVarCall = this.getNotificationMessageValidateBeforeCall(orgId, notificationMessageId, _callback);
        Type localVarReturnType = new TypeToken<NotificationMessage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNotificationEventsCall(String orgId, String startDate, String endDate, Integer limit, Integer offset, String priorities, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/notificationEvent".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (priorities != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priorities", priorities));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNotificationEventsValidateBeforeCall(String orgId, String startDate, String endDate, Integer limit, Integer offset, String priorities, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listNotificationEvents(Async)");
        }
        return this.listNotificationEventsCall(orgId, startDate, endDate, limit, offset, priorities, _callback);
    }

    public ListNotificationEventsResponse listNotificationEvents(String orgId, String startDate, String endDate, Integer limit, Integer offset, String priorities) throws ApiException {
        ApiResponse<ListNotificationEventsResponse> localVarResp = this.listNotificationEventsWithHttpInfo(orgId, startDate, endDate, limit, offset, priorities);
        return localVarResp.getData();
    }

    public ApiResponse<ListNotificationEventsResponse> listNotificationEventsWithHttpInfo(String orgId, String startDate, String endDate, Integer limit, Integer offset, String priorities) throws ApiException {
        Call localVarCall = this.listNotificationEventsValidateBeforeCall(orgId, startDate, endDate, limit, offset, priorities, null);
        Type localVarReturnType = new TypeToken<ListNotificationEventsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNotificationEventsAsync(String orgId, String startDate, String endDate, Integer limit, Integer offset, String priorities, ApiCallback<ListNotificationEventsResponse> _callback) throws ApiException {
        Call localVarCall = this.listNotificationEventsValidateBeforeCall(orgId, startDate, endDate, limit, offset, priorities, _callback);
        Type localVarReturnType = new TypeToken<ListNotificationEventsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNotificationEventsByEntityCall(String orgId, String entityType, String entityId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/notificationEvent/{entityType}/{entityId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entityType}", this.localVarApiClient.escapeString(entityType.toString())).replace("{entityId}", this.localVarApiClient.escapeString(entityId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNotificationEventsByEntityValidateBeforeCall(String orgId, String entityType, String entityId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listNotificationEventsByEntity(Async)");
        }
        if (entityType == null) {
            throw new ApiException("Missing the required parameter 'entityType' when calling listNotificationEventsByEntity(Async)");
        }
        if (entityId == null) {
            throw new ApiException("Missing the required parameter 'entityId' when calling listNotificationEventsByEntity(Async)");
        }
        return this.listNotificationEventsByEntityCall(orgId, entityType, entityId, limit, offset, _callback);
    }

    public ListNotificationEventsResponse listNotificationEventsByEntity(String orgId, String entityType, String entityId, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListNotificationEventsResponse> localVarResp = this.listNotificationEventsByEntityWithHttpInfo(orgId, entityType, entityId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListNotificationEventsResponse> listNotificationEventsByEntityWithHttpInfo(String orgId, String entityType, String entityId, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listNotificationEventsByEntityValidateBeforeCall(orgId, entityType, entityId, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListNotificationEventsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNotificationEventsByEntityAsync(String orgId, String entityType, String entityId, Integer limit, Integer offset, ApiCallback<ListNotificationEventsResponse> _callback) throws ApiException {
        Call localVarCall = this.listNotificationEventsByEntityValidateBeforeCall(orgId, entityType, entityId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListNotificationEventsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNotificationMessagesCall(String orgId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/notificationMessage".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNotificationMessagesValidateBeforeCall(String orgId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listNotificationMessages(Async)");
        }
        return this.listNotificationMessagesCall(orgId, limit, offset, _callback);
    }

    public ListNotificationMessagesResponse listNotificationMessages(String orgId, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListNotificationMessagesResponse> localVarResp = this.listNotificationMessagesWithHttpInfo(orgId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListNotificationMessagesResponse> listNotificationMessagesWithHttpInfo(String orgId, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listNotificationMessagesValidateBeforeCall(orgId, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListNotificationMessagesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNotificationMessagesAsync(String orgId, Integer limit, Integer offset, ApiCallback<ListNotificationMessagesResponse> _callback) throws ApiException {
        Call localVarCall = this.listNotificationMessagesValidateBeforeCall(orgId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListNotificationMessagesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

