/*
 * Decompiled with CFR 0.152.
 */
package io.suger.api;

import com.google.gson.reflect.TypeToken;
import io.suger.ApiCallback;
import io.suger.ApiClient;
import io.suger.ApiException;
import io.suger.ApiResponse;
import io.suger.Configuration;
import io.suger.Pair;
import io.suger.client.MeteringDimension;
import io.suger.client.UpdateProductParams;
import io.suger.client.WorkloadMetaInfo;
import io.suger.client.WorkloadProduct;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ProductApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProductApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createOrUpdateDraftProductCall(String orgId, WorkloadProduct data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WorkloadProduct localVarPostBody = data;
        String localVarPath = "/org/{orgId}/draftProduct".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrUpdateDraftProductValidateBeforeCall(String orgId, WorkloadProduct data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createOrUpdateDraftProduct(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling createOrUpdateDraftProduct(Async)");
        }
        return this.createOrUpdateDraftProductCall(orgId, data, _callback);
    }

    public WorkloadProduct createOrUpdateDraftProduct(String orgId, WorkloadProduct data) throws ApiException {
        ApiResponse<WorkloadProduct> localVarResp = this.createOrUpdateDraftProductWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadProduct> createOrUpdateDraftProductWithHttpInfo(String orgId, WorkloadProduct data) throws ApiException {
        Call localVarCall = this.createOrUpdateDraftProductValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createOrUpdateDraftProductAsync(String orgId, WorkloadProduct data, ApiCallback<WorkloadProduct> _callback) throws ApiException {
        Call localVarCall = this.createOrUpdateDraftProductValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createProductCall(String orgId, WorkloadProduct data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WorkloadProduct localVarPostBody = data;
        String localVarPath = "/org/{orgId}/product".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProductValidateBeforeCall(String orgId, WorkloadProduct data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createProduct(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling createProduct(Async)");
        }
        return this.createProductCall(orgId, data, _callback);
    }

    public WorkloadProduct createProduct(String orgId, WorkloadProduct data) throws ApiException {
        ApiResponse<WorkloadProduct> localVarResp = this.createProductWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadProduct> createProductWithHttpInfo(String orgId, WorkloadProduct data) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProductAsync(String orgId, WorkloadProduct data, ApiCallback<WorkloadProduct> _callback) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProductCall(String orgId, String productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/product/{productId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProductValidateBeforeCall(String orgId, String productId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling deleteProduct(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling deleteProduct(Async)");
        }
        return this.deleteProductCall(orgId, productId, _callback);
    }

    public String deleteProduct(String orgId, String productId) throws ApiException {
        ApiResponse<String> localVarResp = this.deleteProductWithHttpInfo(orgId, productId);
        return localVarResp.getData();
    }

    public ApiResponse<String> deleteProductWithHttpInfo(String orgId, String productId) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(orgId, productId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteProductAsync(String orgId, String productId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(orgId, productId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProductCall(String orgId, String productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/product/{productId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductValidateBeforeCall(String orgId, String productId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getProduct(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getProduct(Async)");
        }
        return this.getProductCall(orgId, productId, _callback);
    }

    public WorkloadProduct getProduct(String orgId, String productId) throws ApiException {
        ApiResponse<WorkloadProduct> localVarResp = this.getProductWithHttpInfo(orgId, productId);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadProduct> getProductWithHttpInfo(String orgId, String productId) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(orgId, productId, null);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProductAsync(String orgId, String productId, ApiCallback<WorkloadProduct> _callback) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(orgId, productId, _callback);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProductMeteringDimensionsCall(String orgId, String productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/product/{productId}/dimension".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProductMeteringDimensionsValidateBeforeCall(String orgId, String productId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listProductMeteringDimensions(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling listProductMeteringDimensions(Async)");
        }
        return this.listProductMeteringDimensionsCall(orgId, productId, _callback);
    }

    public List<MeteringDimension> listProductMeteringDimensions(String orgId, String productId) throws ApiException {
        ApiResponse<List<MeteringDimension>> localVarResp = this.listProductMeteringDimensionsWithHttpInfo(orgId, productId);
        return localVarResp.getData();
    }

    public ApiResponse<List<MeteringDimension>> listProductMeteringDimensionsWithHttpInfo(String orgId, String productId) throws ApiException {
        Call localVarCall = this.listProductMeteringDimensionsValidateBeforeCall(orgId, productId, null);
        Type localVarReturnType = new TypeToken<List<MeteringDimension>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProductMeteringDimensionsAsync(String orgId, String productId, ApiCallback<List<MeteringDimension>> _callback) throws ApiException {
        Call localVarCall = this.listProductMeteringDimensionsValidateBeforeCall(orgId, productId, _callback);
        Type localVarReturnType = new TypeToken<List<MeteringDimension>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProductsCall(String orgId, String partner, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/product".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (partner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("partner", partner));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProductsValidateBeforeCall(String orgId, String partner, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listProducts(Async)");
        }
        return this.listProductsCall(orgId, partner, limit, offset, _callback);
    }

    public List<WorkloadProduct> listProducts(String orgId, String partner, Integer limit, Integer offset) throws ApiException {
        ApiResponse<List<WorkloadProduct>> localVarResp = this.listProductsWithHttpInfo(orgId, partner, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<List<WorkloadProduct>> listProductsWithHttpInfo(String orgId, String partner, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listProductsValidateBeforeCall(orgId, partner, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<WorkloadProduct>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProductsAsync(String orgId, String partner, Integer limit, Integer offset, ApiCallback<List<WorkloadProduct>> _callback) throws ApiException {
        Call localVarCall = this.listProductsValidateBeforeCall(orgId, partner, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<WorkloadProduct>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProductsByPartnerCall(String orgId, String partner, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/partner/{partner}/product".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{partner}", this.localVarApiClient.escapeString(partner.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProductsByPartnerValidateBeforeCall(String orgId, String partner, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listProductsByPartner(Async)");
        }
        if (partner == null) {
            throw new ApiException("Missing the required parameter 'partner' when calling listProductsByPartner(Async)");
        }
        return this.listProductsByPartnerCall(orgId, partner, _callback);
    }

    public List<WorkloadProduct> listProductsByPartner(String orgId, String partner) throws ApiException {
        ApiResponse<List<WorkloadProduct>> localVarResp = this.listProductsByPartnerWithHttpInfo(orgId, partner);
        return localVarResp.getData();
    }

    public ApiResponse<List<WorkloadProduct>> listProductsByPartnerWithHttpInfo(String orgId, String partner) throws ApiException {
        Call localVarCall = this.listProductsByPartnerValidateBeforeCall(orgId, partner, null);
        Type localVarReturnType = new TypeToken<List<WorkloadProduct>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProductsByPartnerAsync(String orgId, String partner, ApiCallback<List<WorkloadProduct>> _callback) throws ApiException {
        Call localVarCall = this.listProductsByPartnerValidateBeforeCall(orgId, partner, _callback);
        Type localVarReturnType = new TypeToken<List<WorkloadProduct>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call publishProductCall(String orgId, String productId, WorkloadProduct data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WorkloadProduct localVarPostBody = data;
        String localVarPath = "/org/{orgId}/product/{productId}/publish".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call publishProductValidateBeforeCall(String orgId, String productId, WorkloadProduct data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling publishProduct(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling publishProduct(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling publishProduct(Async)");
        }
        return this.publishProductCall(orgId, productId, data, _callback);
    }

    public WorkloadProduct publishProduct(String orgId, String productId, WorkloadProduct data) throws ApiException {
        ApiResponse<WorkloadProduct> localVarResp = this.publishProductWithHttpInfo(orgId, productId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadProduct> publishProductWithHttpInfo(String orgId, String productId, WorkloadProduct data) throws ApiException {
        Call localVarCall = this.publishProductValidateBeforeCall(orgId, productId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call publishProductAsync(String orgId, String productId, WorkloadProduct data, ApiCallback<WorkloadProduct> _callback) throws ApiException {
        Call localVarCall = this.publishProductValidateBeforeCall(orgId, productId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProductCall(String orgId, String productId, WorkloadProduct data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WorkloadProduct localVarPostBody = data;
        String localVarPath = "/org/{orgId}/product/{productId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductValidateBeforeCall(String orgId, String productId, WorkloadProduct data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateProduct(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling updateProduct(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateProduct(Async)");
        }
        return this.updateProductCall(orgId, productId, data, _callback);
    }

    public WorkloadProduct updateProduct(String orgId, String productId, WorkloadProduct data) throws ApiException {
        ApiResponse<WorkloadProduct> localVarResp = this.updateProductWithHttpInfo(orgId, productId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadProduct> updateProductWithHttpInfo(String orgId, String productId, WorkloadProduct data) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(orgId, productId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProductAsync(String orgId, String productId, WorkloadProduct data, ApiCallback<WorkloadProduct> _callback) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(orgId, productId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProductFulfillmentUrlCall(String orgId, String productId, UpdateProductParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateProductParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/product/{productId}/fulfillmentUrl".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductFulfillmentUrlValidateBeforeCall(String orgId, String productId, UpdateProductParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateProductFulfillmentUrl(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling updateProductFulfillmentUrl(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateProductFulfillmentUrl(Async)");
        }
        return this.updateProductFulfillmentUrlCall(orgId, productId, data, _callback);
    }

    public WorkloadProduct updateProductFulfillmentUrl(String orgId, String productId, UpdateProductParams data) throws ApiException {
        ApiResponse<WorkloadProduct> localVarResp = this.updateProductFulfillmentUrlWithHttpInfo(orgId, productId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadProduct> updateProductFulfillmentUrlWithHttpInfo(String orgId, String productId, UpdateProductParams data) throws ApiException {
        Call localVarCall = this.updateProductFulfillmentUrlValidateBeforeCall(orgId, productId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProductFulfillmentUrlAsync(String orgId, String productId, UpdateProductParams data, ApiCallback<WorkloadProduct> _callback) throws ApiException {
        Call localVarCall = this.updateProductFulfillmentUrlValidateBeforeCall(orgId, productId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadProduct>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProductMetaInfoCall(String orgId, String productId, WorkloadMetaInfo data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WorkloadMetaInfo localVarPostBody = data;
        String localVarPath = "/org/{orgId}/product/{productId}/metaInfo".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductMetaInfoValidateBeforeCall(String orgId, String productId, WorkloadMetaInfo data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateProductMetaInfo(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling updateProductMetaInfo(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateProductMetaInfo(Async)");
        }
        return this.updateProductMetaInfoCall(orgId, productId, data, _callback);
    }

    public WorkloadMetaInfo updateProductMetaInfo(String orgId, String productId, WorkloadMetaInfo data) throws ApiException {
        ApiResponse<WorkloadMetaInfo> localVarResp = this.updateProductMetaInfoWithHttpInfo(orgId, productId, data);
        return localVarResp.getData();
    }

    public ApiResponse<WorkloadMetaInfo> updateProductMetaInfoWithHttpInfo(String orgId, String productId, WorkloadMetaInfo data) throws ApiException {
        Call localVarCall = this.updateProductMetaInfoValidateBeforeCall(orgId, productId, data, null);
        Type localVarReturnType = new TypeToken<WorkloadMetaInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProductMetaInfoAsync(String orgId, String productId, WorkloadMetaInfo data, ApiCallback<WorkloadMetaInfo> _callback) throws ApiException {
        Call localVarCall = this.updateProductMetaInfoValidateBeforeCall(orgId, productId, data, _callback);
        Type localVarReturnType = new TypeToken<WorkloadMetaInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

