/*
 * Decompiled with CFR 0.152.
 */
package io.suger.api;

import com.google.gson.reflect.TypeToken;
import io.suger.ApiCallback;
import io.suger.ApiClient;
import io.suger.ApiException;
import io.suger.ApiResponse;
import io.suger.Configuration;
import io.suger.Pair;
import io.suger.client.GetRevenueReportParams;
import io.suger.client.ListRevenueRecordDetailsResponse;
import io.suger.client.ListRevenueRecordsResponse;
import io.suger.client.ListUsageMeteringDailyRecordsResponse;
import io.suger.client.RevenueRecord;
import io.suger.client.RevenueReport;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ReportApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ReportApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReportApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getRevenueReportCall(String orgId, GetRevenueReportParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GetRevenueReportParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/revenueReport".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRevenueReportValidateBeforeCall(String orgId, GetRevenueReportParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getRevenueReport(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling getRevenueReport(Async)");
        }
        return this.getRevenueReportCall(orgId, data, _callback);
    }

    public RevenueReport getRevenueReport(String orgId, GetRevenueReportParams data) throws ApiException {
        ApiResponse<RevenueReport> localVarResp = this.getRevenueReportWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<RevenueReport> getRevenueReportWithHttpInfo(String orgId, GetRevenueReportParams data) throws ApiException {
        Call localVarCall = this.getRevenueReportValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<RevenueReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRevenueReportAsync(String orgId, GetRevenueReportParams data, ApiCallback<RevenueReport> _callback) throws ApiException {
        Call localVarCall = this.getRevenueReportValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<RevenueReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listDailyRevenueRecordsCall(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/dailyRevenueRecord".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (partner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("partner", partner));
        }
        if (productId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("productId", productId));
        }
        if (buyerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buyerId", buyerId));
        }
        if (entitlementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entitlementId", entitlementId));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDailyRevenueRecordsValidateBeforeCall(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listDailyRevenueRecords(Async)");
        }
        return this.listDailyRevenueRecordsCall(orgId, partner, productId, buyerId, entitlementId, startDate, endDate, _callback);
    }

    public List<RevenueRecord> listDailyRevenueRecords(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate) throws ApiException {
        ApiResponse<List<RevenueRecord>> localVarResp = this.listDailyRevenueRecordsWithHttpInfo(orgId, partner, productId, buyerId, entitlementId, startDate, endDate);
        return localVarResp.getData();
    }

    public ApiResponse<List<RevenueRecord>> listDailyRevenueRecordsWithHttpInfo(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate) throws ApiException {
        Call localVarCall = this.listDailyRevenueRecordsValidateBeforeCall(orgId, partner, productId, buyerId, entitlementId, startDate, endDate, null);
        Type localVarReturnType = new TypeToken<List<RevenueRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listDailyRevenueRecordsAsync(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate, ApiCallback<List<RevenueRecord>> _callback) throws ApiException {
        Call localVarCall = this.listDailyRevenueRecordsValidateBeforeCall(orgId, partner, productId, buyerId, entitlementId, startDate, endDate, _callback);
        Type localVarReturnType = new TypeToken<List<RevenueRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRevenueRecordDetailsCall(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/partner/{partner}/revenueRecordDetail".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{partner}", this.localVarApiClient.escapeString(partner.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (productId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("productId", productId));
        }
        if (buyerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buyerId", buyerId));
        }
        if (entitlementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entitlementId", entitlementId));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRevenueRecordDetailsValidateBeforeCall(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listRevenueRecordDetails(Async)");
        }
        if (partner == null) {
            throw new ApiException("Missing the required parameter 'partner' when calling listRevenueRecordDetails(Async)");
        }
        return this.listRevenueRecordDetailsCall(orgId, partner, productId, buyerId, entitlementId, startDate, endDate, limit, offset, _callback);
    }

    public ListRevenueRecordDetailsResponse listRevenueRecordDetails(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListRevenueRecordDetailsResponse> localVarResp = this.listRevenueRecordDetailsWithHttpInfo(orgId, partner, productId, buyerId, entitlementId, startDate, endDate, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListRevenueRecordDetailsResponse> listRevenueRecordDetailsWithHttpInfo(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listRevenueRecordDetailsValidateBeforeCall(orgId, partner, productId, buyerId, entitlementId, startDate, endDate, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListRevenueRecordDetailsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRevenueRecordDetailsAsync(String orgId, String partner, String productId, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback<ListRevenueRecordDetailsResponse> _callback) throws ApiException {
        Call localVarCall = this.listRevenueRecordDetailsValidateBeforeCall(orgId, partner, productId, buyerId, entitlementId, startDate, endDate, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListRevenueRecordDetailsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRevenueRecordsCall(String orgId, String partner, String productId, String entitlementId, String buyerId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/partner/{partner}/revenueRecord".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{partner}", this.localVarApiClient.escapeString(partner.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (productId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("productId", productId));
        }
        if (entitlementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entitlementId", entitlementId));
        }
        if (buyerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buyerId", buyerId));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRevenueRecordsValidateBeforeCall(String orgId, String partner, String productId, String entitlementId, String buyerId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listRevenueRecords(Async)");
        }
        if (partner == null) {
            throw new ApiException("Missing the required parameter 'partner' when calling listRevenueRecords(Async)");
        }
        return this.listRevenueRecordsCall(orgId, partner, productId, entitlementId, buyerId, startDate, endDate, limit, offset, _callback);
    }

    public ListRevenueRecordsResponse listRevenueRecords(String orgId, String partner, String productId, String entitlementId, String buyerId, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListRevenueRecordsResponse> localVarResp = this.listRevenueRecordsWithHttpInfo(orgId, partner, productId, entitlementId, buyerId, startDate, endDate, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListRevenueRecordsResponse> listRevenueRecordsWithHttpInfo(String orgId, String partner, String productId, String entitlementId, String buyerId, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listRevenueRecordsValidateBeforeCall(orgId, partner, productId, entitlementId, buyerId, startDate, endDate, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListRevenueRecordsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRevenueRecordsAsync(String orgId, String partner, String productId, String entitlementId, String buyerId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback<ListRevenueRecordsResponse> _callback) throws ApiException {
        Call localVarCall = this.listRevenueRecordsValidateBeforeCall(orgId, partner, productId, entitlementId, buyerId, startDate, endDate, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListRevenueRecordsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUsageMeteringDailyRecordsCall(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/partner/{partner}/usageMeteringDailyRecord".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{partner}", this.localVarApiClient.escapeString(partner.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (buyerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buyerId", buyerId));
        }
        if (entitlementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entitlementId", entitlementId));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUsageMeteringDailyRecordsValidateBeforeCall(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listUsageMeteringDailyRecords(Async)");
        }
        if (partner == null) {
            throw new ApiException("Missing the required parameter 'partner' when calling listUsageMeteringDailyRecords(Async)");
        }
        return this.listUsageMeteringDailyRecordsCall(orgId, partner, buyerId, entitlementId, startDate, endDate, limit, offset, _callback);
    }

    public ListUsageMeteringDailyRecordsResponse listUsageMeteringDailyRecords(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListUsageMeteringDailyRecordsResponse> localVarResp = this.listUsageMeteringDailyRecordsWithHttpInfo(orgId, partner, buyerId, entitlementId, startDate, endDate, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListUsageMeteringDailyRecordsResponse> listUsageMeteringDailyRecordsWithHttpInfo(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listUsageMeteringDailyRecordsValidateBeforeCall(orgId, partner, buyerId, entitlementId, startDate, endDate, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListUsageMeteringDailyRecordsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUsageMeteringDailyRecordsAsync(String orgId, String partner, String buyerId, String entitlementId, String startDate, String endDate, Integer limit, Integer offset, ApiCallback<ListUsageMeteringDailyRecordsResponse> _callback) throws ApiException {
        Call localVarCall = this.listUsageMeteringDailyRecordsValidateBeforeCall(orgId, partner, buyerId, entitlementId, startDate, endDate, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListUsageMeteringDailyRecordsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

