/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class ApiClientAccessToken {
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    @Nullable
    private String accessToken;
    public static final String SERIALIZED_NAME_EXPIRES_IN = "expires_in";
    @SerializedName(value="expires_in")
    @Nullable
    private Integer expiresIn;
    public static final String SERIALIZED_NAME_EXPIRES_ON = "expires_on";
    @SerializedName(value="expires_on")
    @Nullable
    private OffsetDateTime expiresOn;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "token_type";
    @SerializedName(value="token_type")
    @Nullable
    private String tokenType = "Bearer";
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ApiClientAccessToken accessToken(@Nullable String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(@Nullable String accessToken) {
        this.accessToken = accessToken;
    }

    public ApiClientAccessToken expiresIn(@Nullable Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(@Nullable Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public ApiClientAccessToken expiresOn(@Nullable OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    @Nullable
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public void setExpiresOn(@Nullable OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
    }

    public ApiClientAccessToken tokenType(@Nullable String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(@Nullable String tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClientAccessToken apiClientAccessToken = (ApiClientAccessToken)o;
        return Objects.equals(this.accessToken, apiClientAccessToken.accessToken) && Objects.equals(this.expiresIn, apiClientAccessToken.expiresIn) && Objects.equals(this.expiresOn, apiClientAccessToken.expiresOn) && Objects.equals(this.tokenType, apiClientAccessToken.tokenType);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.expiresIn, this.expiresOn, this.tokenType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClientAccessToken {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    expiresOn: ").append(this.toIndentedString(this.expiresOn)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ApiClientAccessToken is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ApiClientAccessToken` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `token_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).toString()));
        }
    }

    public static ApiClientAccessToken fromJson(String jsonString) throws IOException {
        return (ApiClientAccessToken)JSON.getGson().fromJson(jsonString, ApiClientAccessToken.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESS_TOKEN);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_IN);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_ON);
        openapiFields.add(SERIALIZED_NAME_TOKEN_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ApiClientAccessToken.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ApiClientAccessToken.class));
            return new TypeAdapter<ApiClientAccessToken>(){

                public void write(JsonWriter out, ApiClientAccessToken value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ApiClientAccessToken read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ApiClientAccessToken.validateJsonElement(jsonElement);
                    return (ApiClientAccessToken)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

