/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import io.suger.client.AzureValidationResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AzureGovernmentCertification {
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    @Nullable
    private String title;
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    @Nullable
    private String uri;
    public static final String SERIALIZED_NAME_VALIDATION_RESULTS = "validationResults";
    @SerializedName(value="validationResults")
    @Nullable
    private List<AzureValidationResult> validationResults = new ArrayList<AzureValidationResult>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AzureGovernmentCertification title(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public AzureGovernmentCertification uri(@Nullable String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    public String getUri() {
        return this.uri;
    }

    public void setUri(@Nullable String uri) {
        this.uri = uri;
    }

    public AzureGovernmentCertification validationResults(@Nullable List<AzureValidationResult> validationResults) {
        this.validationResults = validationResults;
        return this;
    }

    public AzureGovernmentCertification addValidationResultsItem(AzureValidationResult validationResultsItem) {
        if (this.validationResults == null) {
            this.validationResults = new ArrayList<AzureValidationResult>();
        }
        this.validationResults.add(validationResultsItem);
        return this;
    }

    @Nullable
    public List<AzureValidationResult> getValidationResults() {
        return this.validationResults;
    }

    public void setValidationResults(@Nullable List<AzureValidationResult> validationResults) {
        this.validationResults = validationResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureGovernmentCertification azureGovernmentCertification = (AzureGovernmentCertification)o;
        return Objects.equals(this.title, azureGovernmentCertification.title) && Objects.equals(this.uri, azureGovernmentCertification.uri) && Objects.equals(this.validationResults, azureGovernmentCertification.validationResults);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.uri, this.validationResults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureGovernmentCertification {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    validationResults: ").append(this.toIndentedString(this.validationResults)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvalidationResults;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AzureGovernmentCertification is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AzureGovernmentCertification` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URI) != null && !jsonObj.get(SERIALIZED_NAME_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALIDATION_RESULTS) != null && !jsonObj.get(SERIALIZED_NAME_VALIDATION_RESULTS).isJsonNull() && (jsonArrayvalidationResults = jsonObj.getAsJsonArray(SERIALIZED_NAME_VALIDATION_RESULTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VALIDATION_RESULTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `validationResults` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALIDATION_RESULTS).toString()));
            }
            for (int i = 0; i < jsonArrayvalidationResults.size(); ++i) {
                AzureValidationResult.validateJsonElement(jsonArrayvalidationResults.get(i));
            }
        }
    }

    public static AzureGovernmentCertification fromJson(String jsonString) throws IOException {
        return (AzureGovernmentCertification)JSON.getGson().fromJson(jsonString, AzureGovernmentCertification.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_URI);
        openapiFields.add(SERIALIZED_NAME_VALIDATION_RESULTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AzureGovernmentCertification.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AzureGovernmentCertification.class));
            return new TypeAdapter<AzureGovernmentCertification>(){

                public void write(JsonWriter out, AzureGovernmentCertification value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AzureGovernmentCertification read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AzureGovernmentCertification.validateJsonElement(jsonElement);
                    return (AzureGovernmentCertification)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

