/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AzureMarketState {
    public static final String SERIALIZED_NAME_MARKET_CODE = "marketCode";
    @SerializedName(value="marketCode")
    @Nullable
    private String marketCode;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    @Nullable
    private StateEnum state;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AzureMarketState marketCode(@Nullable String marketCode) {
        this.marketCode = marketCode;
        return this;
    }

    @Nullable
    public String getMarketCode() {
        return this.marketCode;
    }

    public void setMarketCode(@Nullable String marketCode) {
        this.marketCode = marketCode;
    }

    public AzureMarketState state(@Nullable StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    public StateEnum getState() {
        return this.state;
    }

    public void setState(@Nullable StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureMarketState azureMarketState = (AzureMarketState)o;
        return Objects.equals(this.marketCode, azureMarketState.marketCode) && Objects.equals((Object)this.state, (Object)azureMarketState.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketCode, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureMarketState {\n");
        sb.append("    marketCode: ").append(this.toIndentedString(this.marketCode)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AzureMarketState is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AzureMarketState` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_MARKET_CODE) != null && !jsonObj.get(SERIALIZED_NAME_MARKET_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MARKET_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `marketCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MARKET_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `state` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull()) {
            StateEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATE));
        }
    }

    public static AzureMarketState fromJson(String jsonString) throws IOException {
        return (AzureMarketState)JSON.getGson().fromJson(jsonString, AzureMarketState.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MARKET_CODE);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiRequiredFields = new HashSet();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        DISABLED("Disabled"),
        ENABLED("Enabled"),
        STOP_SELLING("StopSelling"),
        TERMINATED("Terminated");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            StateEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AzureMarketState.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AzureMarketState.class));
            return new TypeAdapter<AzureMarketState>(){

                public void write(JsonWriter out, AzureMarketState value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AzureMarketState read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AzureMarketState.validateJsonElement(jsonElement);
                    return (AzureMarketState)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

