/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AzureMarketplacePrice {
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    @Nullable
    private String currency;
    public static final String SERIALIZED_NAME_MARKETS = "markets";
    @SerializedName(value="markets")
    @Nullable
    private List<String> markets = new ArrayList<String>();
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    @Nullable
    private BigDecimal price;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AzureMarketplacePrice currency(@Nullable String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(@Nullable String currency) {
        this.currency = currency;
    }

    public AzureMarketplacePrice markets(@Nullable List<String> markets) {
        this.markets = markets;
        return this;
    }

    public AzureMarketplacePrice addMarketsItem(String marketsItem) {
        if (this.markets == null) {
            this.markets = new ArrayList<String>();
        }
        this.markets.add(marketsItem);
        return this;
    }

    @Nullable
    public List<String> getMarkets() {
        return this.markets;
    }

    public void setMarkets(@Nullable List<String> markets) {
        this.markets = markets;
    }

    public AzureMarketplacePrice price(@Nullable BigDecimal price) {
        this.price = price;
        return this;
    }

    @Nullable
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(@Nullable BigDecimal price) {
        this.price = price;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureMarketplacePrice azureMarketplacePrice = (AzureMarketplacePrice)o;
        return Objects.equals(this.currency, azureMarketplacePrice.currency) && Objects.equals(this.markets, azureMarketplacePrice.markets) && Objects.equals(this.price, azureMarketplacePrice.price);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.markets, this.price);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureMarketplacePrice {\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    markets: ").append(this.toIndentedString(this.markets)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AzureMarketplacePrice is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AzureMarketplacePrice` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MARKETS) != null && !jsonObj.get(SERIALIZED_NAME_MARKETS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MARKETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `markets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MARKETS).toString()));
        }
    }

    public static AzureMarketplacePrice fromJson(String jsonString) throws IOException {
        return (AzureMarketplacePrice)JSON.getGson().fromJson(jsonString, AzureMarketplacePrice.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_MARKETS);
        openapiFields.add(SERIALIZED_NAME_PRICE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AzureMarketplacePrice.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AzureMarketplacePrice.class));
            return new TypeAdapter<AzureMarketplacePrice>(){

                public void write(JsonWriter out, AzureMarketplacePrice value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AzureMarketplacePrice read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AzureMarketplacePrice.validateJsonElement(jsonElement);
                    return (AzureMarketplacePrice)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

