/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import io.suger.client.AzurePrice;
import io.suger.client.AzurePriceCadence;
import io.suger.client.AzurePricingUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AzurePriceSchedule {
    public static final String SERIALIZED_NAME_PRICE_CADENCE = "priceCadence";
    @SerializedName(value="priceCadence")
    @Nullable
    private AzurePriceCadence priceCadence;
    public static final String SERIALIZED_NAME_PRICING_MODEL = "pricingModel";
    @SerializedName(value="pricingModel")
    @Nullable
    private PricingModelEnum pricingModel;
    public static final String SERIALIZED_NAME_PRICING_UNITS = "pricingUnits";
    @SerializedName(value="pricingUnits")
    @Nullable
    private List<AzurePricingUnit> pricingUnits = new ArrayList<AzurePricingUnit>();
    public static final String SERIALIZED_NAME_RETAIL_PRICE = "retailPrice";
    @SerializedName(value="retailPrice")
    @Nullable
    private AzurePrice retailPrice;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AzurePriceSchedule priceCadence(@Nullable AzurePriceCadence priceCadence) {
        this.priceCadence = priceCadence;
        return this;
    }

    @Nullable
    public AzurePriceCadence getPriceCadence() {
        return this.priceCadence;
    }

    public void setPriceCadence(@Nullable AzurePriceCadence priceCadence) {
        this.priceCadence = priceCadence;
    }

    public AzurePriceSchedule pricingModel(@Nullable PricingModelEnum pricingModel) {
        this.pricingModel = pricingModel;
        return this;
    }

    @Nullable
    public PricingModelEnum getPricingModel() {
        return this.pricingModel;
    }

    public void setPricingModel(@Nullable PricingModelEnum pricingModel) {
        this.pricingModel = pricingModel;
    }

    public AzurePriceSchedule pricingUnits(@Nullable List<AzurePricingUnit> pricingUnits) {
        this.pricingUnits = pricingUnits;
        return this;
    }

    public AzurePriceSchedule addPricingUnitsItem(AzurePricingUnit pricingUnitsItem) {
        if (this.pricingUnits == null) {
            this.pricingUnits = new ArrayList<AzurePricingUnit>();
        }
        this.pricingUnits.add(pricingUnitsItem);
        return this;
    }

    @Nullable
    public List<AzurePricingUnit> getPricingUnits() {
        return this.pricingUnits;
    }

    public void setPricingUnits(@Nullable List<AzurePricingUnit> pricingUnits) {
        this.pricingUnits = pricingUnits;
    }

    public AzurePriceSchedule retailPrice(@Nullable AzurePrice retailPrice) {
        this.retailPrice = retailPrice;
        return this;
    }

    @Nullable
    public AzurePrice getRetailPrice() {
        return this.retailPrice;
    }

    public void setRetailPrice(@Nullable AzurePrice retailPrice) {
        this.retailPrice = retailPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzurePriceSchedule azurePriceSchedule = (AzurePriceSchedule)o;
        return Objects.equals(this.priceCadence, azurePriceSchedule.priceCadence) && Objects.equals((Object)this.pricingModel, (Object)azurePriceSchedule.pricingModel) && Objects.equals(this.pricingUnits, azurePriceSchedule.pricingUnits) && Objects.equals(this.retailPrice, azurePriceSchedule.retailPrice);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.priceCadence, this.pricingModel, this.pricingUnits, this.retailPrice});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzurePriceSchedule {\n");
        sb.append("    priceCadence: ").append(this.toIndentedString(this.priceCadence)).append("\n");
        sb.append("    pricingModel: ").append(this.toIndentedString((Object)this.pricingModel)).append("\n");
        sb.append("    pricingUnits: ").append(this.toIndentedString(this.pricingUnits)).append("\n");
        sb.append("    retailPrice: ").append(this.toIndentedString(this.retailPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraypricingUnits;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AzurePriceSchedule is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AzurePriceSchedule` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_PRICE_CADENCE) != null && !jsonObj.get(SERIALIZED_NAME_PRICE_CADENCE).isJsonNull()) {
            AzurePriceCadence.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PRICE_CADENCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRICING_MODEL) != null && !jsonObj.get(SERIALIZED_NAME_PRICING_MODEL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PRICING_MODEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pricingModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRICING_MODEL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRICING_MODEL) != null && !jsonObj.get(SERIALIZED_NAME_PRICING_MODEL).isJsonNull()) {
            PricingModelEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PRICING_MODEL));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRICING_UNITS) != null && !jsonObj.get(SERIALIZED_NAME_PRICING_UNITS).isJsonNull() && (jsonArraypricingUnits = jsonObj.getAsJsonArray(SERIALIZED_NAME_PRICING_UNITS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRICING_UNITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `pricingUnits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRICING_UNITS).toString()));
            }
            for (int i = 0; i < jsonArraypricingUnits.size(); ++i) {
                AzurePricingUnit.validateJsonElement(jsonArraypricingUnits.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RETAIL_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_RETAIL_PRICE).isJsonNull()) {
            AzurePrice.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RETAIL_PRICE));
        }
    }

    public static AzurePriceSchedule fromJson(String jsonString) throws IOException {
        return (AzurePriceSchedule)JSON.getGson().fromJson(jsonString, AzurePriceSchedule.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PRICE_CADENCE);
        openapiFields.add(SERIALIZED_NAME_PRICING_MODEL);
        openapiFields.add(SERIALIZED_NAME_PRICING_UNITS);
        openapiFields.add(SERIALIZED_NAME_RETAIL_PRICE);
        openapiRequiredFields = new HashSet();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PricingModelEnum {
        FLAT("Flat"),
        RECURRING("Recurring"),
        USAGE("Usage");

        private String value;

        private PricingModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PricingModelEnum fromValue(String value) {
            for (PricingModelEnum b : PricingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            PricingModelEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<PricingModelEnum> {
            public void write(JsonWriter jsonWriter, PricingModelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PricingModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PricingModelEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AzurePriceSchedule.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AzurePriceSchedule.class));
            return new TypeAdapter<AzurePriceSchedule>(){

                public void write(JsonWriter out, AzurePriceSchedule value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AzurePriceSchedule read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AzurePriceSchedule.validateJsonElement(jsonElement);
                    return (AzurePriceSchedule)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

