/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AzureProductPackageConfiguration {
    public static final String SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_APPLICATION_I_D = "azureActiveDirectoryApplicationID";
    @SerializedName(value="azureActiveDirectoryApplicationID")
    @Nullable
    private String azureActiveDirectoryApplicationID;
    public static final String SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_TENANT_I_D = "azureActiveDirectoryTenantID";
    @SerializedName(value="azureActiveDirectoryTenantID")
    @Nullable
    private String azureActiveDirectoryTenantID;
    public static final String SERIALIZED_NAME_CONNECTION_WEBHOOK = "connectionWebhook";
    @SerializedName(value="connectionWebhook")
    @Nullable
    private String connectionWebhook;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nullable
    private String id;
    public static final String SERIALIZED_NAME_LANDING_PAGE_URI = "landingPageUri";
    @SerializedName(value="landingPageUri")
    @Nullable
    private String landingPageUri;
    public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resourceType";
    @SerializedName(value="resourceType")
    @Nullable
    private ResourceTypeEnum resourceType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AzureProductPackageConfiguration azureActiveDirectoryApplicationID(@Nullable String azureActiveDirectoryApplicationID) {
        this.azureActiveDirectoryApplicationID = azureActiveDirectoryApplicationID;
        return this;
    }

    @Nullable
    public String getAzureActiveDirectoryApplicationID() {
        return this.azureActiveDirectoryApplicationID;
    }

    public void setAzureActiveDirectoryApplicationID(@Nullable String azureActiveDirectoryApplicationID) {
        this.azureActiveDirectoryApplicationID = azureActiveDirectoryApplicationID;
    }

    public AzureProductPackageConfiguration azureActiveDirectoryTenantID(@Nullable String azureActiveDirectoryTenantID) {
        this.azureActiveDirectoryTenantID = azureActiveDirectoryTenantID;
        return this;
    }

    @Nullable
    public String getAzureActiveDirectoryTenantID() {
        return this.azureActiveDirectoryTenantID;
    }

    public void setAzureActiveDirectoryTenantID(@Nullable String azureActiveDirectoryTenantID) {
        this.azureActiveDirectoryTenantID = azureActiveDirectoryTenantID;
    }

    public AzureProductPackageConfiguration connectionWebhook(@Nullable String connectionWebhook) {
        this.connectionWebhook = connectionWebhook;
        return this;
    }

    @Nullable
    public String getConnectionWebhook() {
        return this.connectionWebhook;
    }

    public void setConnectionWebhook(@Nullable String connectionWebhook) {
        this.connectionWebhook = connectionWebhook;
    }

    public AzureProductPackageConfiguration id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public AzureProductPackageConfiguration landingPageUri(@Nullable String landingPageUri) {
        this.landingPageUri = landingPageUri;
        return this;
    }

    @Nullable
    public String getLandingPageUri() {
        return this.landingPageUri;
    }

    public void setLandingPageUri(@Nullable String landingPageUri) {
        this.landingPageUri = landingPageUri;
    }

    public AzureProductPackageConfiguration resourceType(@Nullable ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(@Nullable ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureProductPackageConfiguration azureProductPackageConfiguration = (AzureProductPackageConfiguration)o;
        return Objects.equals(this.azureActiveDirectoryApplicationID, azureProductPackageConfiguration.azureActiveDirectoryApplicationID) && Objects.equals(this.azureActiveDirectoryTenantID, azureProductPackageConfiguration.azureActiveDirectoryTenantID) && Objects.equals(this.connectionWebhook, azureProductPackageConfiguration.connectionWebhook) && Objects.equals(this.id, azureProductPackageConfiguration.id) && Objects.equals(this.landingPageUri, azureProductPackageConfiguration.landingPageUri) && Objects.equals((Object)this.resourceType, (Object)azureProductPackageConfiguration.resourceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.azureActiveDirectoryApplicationID, this.azureActiveDirectoryTenantID, this.connectionWebhook, this.id, this.landingPageUri, this.resourceType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureProductPackageConfiguration {\n");
        sb.append("    azureActiveDirectoryApplicationID: ").append(this.toIndentedString(this.azureActiveDirectoryApplicationID)).append("\n");
        sb.append("    azureActiveDirectoryTenantID: ").append(this.toIndentedString(this.azureActiveDirectoryTenantID)).append("\n");
        sb.append("    connectionWebhook: ").append(this.toIndentedString(this.connectionWebhook)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    landingPageUri: ").append(this.toIndentedString(this.landingPageUri)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AzureProductPackageConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AzureProductPackageConfiguration` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_APPLICATION_I_D) != null && !jsonObj.get(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_APPLICATION_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_APPLICATION_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `azureActiveDirectoryApplicationID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_APPLICATION_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_TENANT_I_D) != null && !jsonObj.get(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_TENANT_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_TENANT_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `azureActiveDirectoryTenantID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_TENANT_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONNECTION_WEBHOOK) != null && !jsonObj.get(SERIALIZED_NAME_CONNECTION_WEBHOOK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONNECTION_WEBHOOK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `connectionWebhook` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONNECTION_WEBHOOK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LANDING_PAGE_URI) != null && !jsonObj.get(SERIALIZED_NAME_LANDING_PAGE_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LANDING_PAGE_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `landingPageUri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANDING_PAGE_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).isJsonNull()) {
            ResourceTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE));
        }
    }

    public static AzureProductPackageConfiguration fromJson(String jsonString) throws IOException {
        return (AzureProductPackageConfiguration)JSON.getGson().fromJson(jsonString, AzureProductPackageConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_APPLICATION_I_D);
        openapiFields.add(SERIALIZED_NAME_AZURE_ACTIVE_DIRECTORY_TENANT_I_D);
        openapiFields.add(SERIALIZED_NAME_CONNECTION_WEBHOOK);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LANDING_PAGE_URI);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_TYPE);
        openapiRequiredFields = new HashSet();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResourceTypeEnum {
        AZURE_SOFTWARE_AS_A_SERVICE_PACKAGE_CONFIGURATION("AzureSoftwareAsAServicePackageConfiguration");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ResourceTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ResourceTypeEnum> {
            public void write(JsonWriter jsonWriter, ResourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResourceTypeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AzureProductPackageConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AzureProductPackageConfiguration.class));
            return new TypeAdapter<AzureProductPackageConfiguration>(){

                public void write(JsonWriter out, AzureProductPackageConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AzureProductPackageConfiguration read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AzureProductPackageConfiguration.validateJsonElement(jsonElement);
                    return (AzureProductPackageConfiguration)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

