/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import io.suger.client.AzurePendingUpdateInfo;
import io.suger.client.AzureTypeValue;
import io.suger.client.AzureVariantResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AzureProductSubmission {
    public static final String SERIALIZED_NAME_ARE_RESOURCES_READY = "areResourcesReady";
    @SerializedName(value="areResourcesReady")
    @Nullable
    private Boolean areResourcesReady;
    public static final String SERIALIZED_NAME_FRIENDLY_NAME = "friendlyName";
    @SerializedName(value="friendlyName")
    @Nullable
    private String friendlyName;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nullable
    private String id;
    public static final String SERIALIZED_NAME_PENDING_UPDATE_INFO = "pendingUpdateInfo";
    @SerializedName(value="pendingUpdateInfo")
    @Nullable
    private AzurePendingUpdateInfo pendingUpdateInfo;
    public static final String SERIALIZED_NAME_PUBLISHED_TIME_IN_UTC = "publishedTimeInUtc";
    @SerializedName(value="publishedTimeInUtc")
    @Nullable
    private OffsetDateTime publishedTimeInUtc;
    public static final String SERIALIZED_NAME_RELEASE_NUMBER = "releaseNumber";
    @SerializedName(value="releaseNumber")
    @Nullable
    private Integer releaseNumber;
    public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resourceType";
    @SerializedName(value="resourceType")
    @Nullable
    private ResourceTypeEnum resourceType;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    @Nullable
    private List<AzureTypeValue> resources = new ArrayList<AzureTypeValue>();
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    @Nullable
    private StateEnum state;
    public static final String SERIALIZED_NAME_SUB_STATE = "subState";
    @SerializedName(value="subState")
    @Nullable
    private SubStateEnum subState;
    public static final String SERIALIZED_NAME_TARGETS = "targets";
    @SerializedName(value="targets")
    @Nullable
    private List<AzureTypeValue> targets = new ArrayList<AzureTypeValue>();
    public static final String SERIALIZED_NAME_VARIANT_RESOURCES = "variantResources";
    @SerializedName(value="variantResources")
    @Nullable
    private List<AzureVariantResource> variantResources = new ArrayList<AzureVariantResource>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AzureProductSubmission areResourcesReady(@Nullable Boolean areResourcesReady) {
        this.areResourcesReady = areResourcesReady;
        return this;
    }

    @Nullable
    public Boolean getAreResourcesReady() {
        return this.areResourcesReady;
    }

    public void setAreResourcesReady(@Nullable Boolean areResourcesReady) {
        this.areResourcesReady = areResourcesReady;
    }

    public AzureProductSubmission friendlyName(@Nullable String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Nullable
    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(@Nullable String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public AzureProductSubmission id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public AzureProductSubmission pendingUpdateInfo(@Nullable AzurePendingUpdateInfo pendingUpdateInfo) {
        this.pendingUpdateInfo = pendingUpdateInfo;
        return this;
    }

    @Nullable
    public AzurePendingUpdateInfo getPendingUpdateInfo() {
        return this.pendingUpdateInfo;
    }

    public void setPendingUpdateInfo(@Nullable AzurePendingUpdateInfo pendingUpdateInfo) {
        this.pendingUpdateInfo = pendingUpdateInfo;
    }

    public AzureProductSubmission publishedTimeInUtc(@Nullable OffsetDateTime publishedTimeInUtc) {
        this.publishedTimeInUtc = publishedTimeInUtc;
        return this;
    }

    @Nullable
    public OffsetDateTime getPublishedTimeInUtc() {
        return this.publishedTimeInUtc;
    }

    public void setPublishedTimeInUtc(@Nullable OffsetDateTime publishedTimeInUtc) {
        this.publishedTimeInUtc = publishedTimeInUtc;
    }

    public AzureProductSubmission releaseNumber(@Nullable Integer releaseNumber) {
        this.releaseNumber = releaseNumber;
        return this;
    }

    @Nullable
    public Integer getReleaseNumber() {
        return this.releaseNumber;
    }

    public void setReleaseNumber(@Nullable Integer releaseNumber) {
        this.releaseNumber = releaseNumber;
    }

    public AzureProductSubmission resourceType(@Nullable ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(@Nullable ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public AzureProductSubmission resources(@Nullable List<AzureTypeValue> resources) {
        this.resources = resources;
        return this;
    }

    public AzureProductSubmission addResourcesItem(AzureTypeValue resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<AzureTypeValue>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    public List<AzureTypeValue> getResources() {
        return this.resources;
    }

    public void setResources(@Nullable List<AzureTypeValue> resources) {
        this.resources = resources;
    }

    public AzureProductSubmission state(@Nullable StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    public StateEnum getState() {
        return this.state;
    }

    public void setState(@Nullable StateEnum state) {
        this.state = state;
    }

    public AzureProductSubmission subState(@Nullable SubStateEnum subState) {
        this.subState = subState;
        return this;
    }

    @Nullable
    public SubStateEnum getSubState() {
        return this.subState;
    }

    public void setSubState(@Nullable SubStateEnum subState) {
        this.subState = subState;
    }

    public AzureProductSubmission targets(@Nullable List<AzureTypeValue> targets) {
        this.targets = targets;
        return this;
    }

    public AzureProductSubmission addTargetsItem(AzureTypeValue targetsItem) {
        if (this.targets == null) {
            this.targets = new ArrayList<AzureTypeValue>();
        }
        this.targets.add(targetsItem);
        return this;
    }

    @Nullable
    public List<AzureTypeValue> getTargets() {
        return this.targets;
    }

    public void setTargets(@Nullable List<AzureTypeValue> targets) {
        this.targets = targets;
    }

    public AzureProductSubmission variantResources(@Nullable List<AzureVariantResource> variantResources) {
        this.variantResources = variantResources;
        return this;
    }

    public AzureProductSubmission addVariantResourcesItem(AzureVariantResource variantResourcesItem) {
        if (this.variantResources == null) {
            this.variantResources = new ArrayList<AzureVariantResource>();
        }
        this.variantResources.add(variantResourcesItem);
        return this;
    }

    @Nullable
    public List<AzureVariantResource> getVariantResources() {
        return this.variantResources;
    }

    public void setVariantResources(@Nullable List<AzureVariantResource> variantResources) {
        this.variantResources = variantResources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureProductSubmission azureProductSubmission = (AzureProductSubmission)o;
        return Objects.equals(this.areResourcesReady, azureProductSubmission.areResourcesReady) && Objects.equals(this.friendlyName, azureProductSubmission.friendlyName) && Objects.equals(this.id, azureProductSubmission.id) && Objects.equals(this.pendingUpdateInfo, azureProductSubmission.pendingUpdateInfo) && Objects.equals(this.publishedTimeInUtc, azureProductSubmission.publishedTimeInUtc) && Objects.equals(this.releaseNumber, azureProductSubmission.releaseNumber) && Objects.equals((Object)this.resourceType, (Object)azureProductSubmission.resourceType) && Objects.equals(this.resources, azureProductSubmission.resources) && Objects.equals((Object)this.state, (Object)azureProductSubmission.state) && Objects.equals((Object)this.subState, (Object)azureProductSubmission.subState) && Objects.equals(this.targets, azureProductSubmission.targets) && Objects.equals(this.variantResources, azureProductSubmission.variantResources);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.areResourcesReady, this.friendlyName, this.id, this.pendingUpdateInfo, this.publishedTimeInUtc, this.releaseNumber, this.resourceType, this.resources, this.state, this.subState, this.targets, this.variantResources});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureProductSubmission {\n");
        sb.append("    areResourcesReady: ").append(this.toIndentedString(this.areResourcesReady)).append("\n");
        sb.append("    friendlyName: ").append(this.toIndentedString(this.friendlyName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    pendingUpdateInfo: ").append(this.toIndentedString(this.pendingUpdateInfo)).append("\n");
        sb.append("    publishedTimeInUtc: ").append(this.toIndentedString(this.publishedTimeInUtc)).append("\n");
        sb.append("    releaseNumber: ").append(this.toIndentedString(this.releaseNumber)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    subState: ").append(this.toIndentedString((Object)this.subState)).append("\n");
        sb.append("    targets: ").append(this.toIndentedString(this.targets)).append("\n");
        sb.append("    variantResources: ").append(this.toIndentedString(this.variantResources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvariantResources;
        JsonArray jsonArraytargets;
        int i;
        JsonArray jsonArrayresources;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AzureProductSubmission is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AzureProductSubmission` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FRIENDLY_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FRIENDLY_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FRIENDLY_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `friendlyName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRIENDLY_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PENDING_UPDATE_INFO) != null && !jsonObj.get(SERIALIZED_NAME_PENDING_UPDATE_INFO).isJsonNull()) {
            AzurePendingUpdateInfo.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PENDING_UPDATE_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).isJsonNull()) {
            ResourceTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull() && (jsonArrayresources = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESOURCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `resources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCES).toString()));
            }
            for (i = 0; i < jsonArrayresources.size(); ++i) {
                AzureTypeValue.validateJsonElement(jsonArrayresources.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `state` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull()) {
            StateEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_STATE) != null && !jsonObj.get(SERIALIZED_NAME_SUB_STATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUB_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subState` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_STATE) != null && !jsonObj.get(SERIALIZED_NAME_SUB_STATE).isJsonNull()) {
            SubStateEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SUB_STATE));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGETS) != null && !jsonObj.get(SERIALIZED_NAME_TARGETS).isJsonNull() && (jsonArraytargets = jsonObj.getAsJsonArray(SERIALIZED_NAME_TARGETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TARGETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `targets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGETS).toString()));
            }
            for (i = 0; i < jsonArraytargets.size(); ++i) {
                AzureTypeValue.validateJsonElement(jsonArraytargets.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIANT_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_VARIANT_RESOURCES).isJsonNull() && (jsonArrayvariantResources = jsonObj.getAsJsonArray(SERIALIZED_NAME_VARIANT_RESOURCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VARIANT_RESOURCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `variantResources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIANT_RESOURCES).toString()));
            }
            for (i = 0; i < jsonArrayvariantResources.size(); ++i) {
                AzureVariantResource.validateJsonElement(jsonArrayvariantResources.get(i));
            }
        }
    }

    public static AzureProductSubmission fromJson(String jsonString) throws IOException {
        return (AzureProductSubmission)JSON.getGson().fromJson(jsonString, AzureProductSubmission.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARE_RESOURCES_READY);
        openapiFields.add(SERIALIZED_NAME_FRIENDLY_NAME);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PENDING_UPDATE_INFO);
        openapiFields.add(SERIALIZED_NAME_PUBLISHED_TIME_IN_UTC);
        openapiFields.add(SERIALIZED_NAME_RELEASE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_TYPE);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiFields.add(SERIALIZED_NAME_SUB_STATE);
        openapiFields.add(SERIALIZED_NAME_TARGETS);
        openapiFields.add(SERIALIZED_NAME_VARIANT_RESOURCES);
        openapiRequiredFields = new HashSet();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResourceTypeEnum {
        SUBMISSION("Submission");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ResourceTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ResourceTypeEnum> {
            public void write(JsonWriter jsonWriter, ResourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResourceTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        INPROGRESS("Inprogress"),
        PUBLISHED("Published");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            StateEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SubStateEnum {
        IN_DRAFT("InDraft"),
        SUBMITTED("Submitted"),
        FAILED("Failed"),
        FAILED_IN_CERTIFICATION("FailedInCertification"),
        READY_TO_PUBLISH("ReadyToPublish"),
        PUBLISHING("Publishing"),
        PUBLISHED("Published"),
        IN_STORE("InStore");

        private String value;

        private SubStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SubStateEnum fromValue(String value) {
            for (SubStateEnum b : SubStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            SubStateEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<SubStateEnum> {
            public void write(JsonWriter jsonWriter, SubStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SubStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SubStateEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AzureProductSubmission.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AzureProductSubmission.class));
            return new TypeAdapter<AzureProductSubmission>(){

                public void write(JsonWriter out, AzureProductSubmission value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AzureProductSubmission read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AzureProductSubmission.validateJsonElement(jsonElement);
                    return (AzureProductSubmission)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

