/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AzureValidationResult {
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    @Nullable
    private String errorMessage;
    public static final String SERIALIZED_NAME_MEMBER_NAMES = "memberNames";
    @SerializedName(value="memberNames")
    @Nullable
    private List<String> memberNames = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AzureValidationResult errorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public AzureValidationResult memberNames(@Nullable List<String> memberNames) {
        this.memberNames = memberNames;
        return this;
    }

    public AzureValidationResult addMemberNamesItem(String memberNamesItem) {
        if (this.memberNames == null) {
            this.memberNames = new ArrayList<String>();
        }
        this.memberNames.add(memberNamesItem);
        return this;
    }

    @Nullable
    public List<String> getMemberNames() {
        return this.memberNames;
    }

    public void setMemberNames(@Nullable List<String> memberNames) {
        this.memberNames = memberNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureValidationResult azureValidationResult = (AzureValidationResult)o;
        return Objects.equals(this.errorMessage, azureValidationResult.errorMessage) && Objects.equals(this.memberNames, azureValidationResult.memberNames);
    }

    public int hashCode() {
        return Objects.hash(this.errorMessage, this.memberNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureValidationResult {\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    memberNames: ").append(this.toIndentedString(this.memberNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AzureValidationResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AzureValidationResult` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `errorMessage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEMBER_NAMES) != null && !jsonObj.get(SERIALIZED_NAME_MEMBER_NAMES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MEMBER_NAMES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `memberNames` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEMBER_NAMES).toString()));
        }
    }

    public static AzureValidationResult fromJson(String jsonString) throws IOException {
        return (AzureValidationResult)JSON.getGson().fromJson(jsonString, AzureValidationResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ERROR_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_MEMBER_NAMES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AzureValidationResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AzureValidationResult.class));
            return new TypeAdapter<AzureValidationResult>(){

                public void write(JsonWriter out, AzureValidationResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AzureValidationResult read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AzureValidationResult.validateJsonElement(jsonElement);
                    return (AzureValidationResult)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

