/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import io.suger.client.AzureTypeValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AzureVariantResource {
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    @Nullable
    private List<AzureTypeValue> resources = new ArrayList<AzureTypeValue>();
    public static final String SERIALIZED_NAME_VARIANT_I_D = "variantID";
    @SerializedName(value="variantID")
    @Nullable
    private String variantID;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AzureVariantResource resources(@Nullable List<AzureTypeValue> resources) {
        this.resources = resources;
        return this;
    }

    public AzureVariantResource addResourcesItem(AzureTypeValue resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<AzureTypeValue>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    public List<AzureTypeValue> getResources() {
        return this.resources;
    }

    public void setResources(@Nullable List<AzureTypeValue> resources) {
        this.resources = resources;
    }

    public AzureVariantResource variantID(@Nullable String variantID) {
        this.variantID = variantID;
        return this;
    }

    @Nullable
    public String getVariantID() {
        return this.variantID;
    }

    public void setVariantID(@Nullable String variantID) {
        this.variantID = variantID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureVariantResource azureVariantResource = (AzureVariantResource)o;
        return Objects.equals(this.resources, azureVariantResource.resources) && Objects.equals(this.variantID, azureVariantResource.variantID);
    }

    public int hashCode() {
        return Objects.hash(this.resources, this.variantID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureVariantResource {\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    variantID: ").append(this.toIndentedString(this.variantID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayresources;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AzureVariantResource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AzureVariantResource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull() && (jsonArrayresources = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESOURCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `resources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCES).toString()));
            }
            for (int i = 0; i < jsonArrayresources.size(); ++i) {
                AzureTypeValue.validateJsonElement(jsonArrayresources.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIANT_I_D) != null && !jsonObj.get(SERIALIZED_NAME_VARIANT_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VARIANT_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `variantID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIANT_I_D).toString()));
        }
    }

    public static AzureVariantResource fromJson(String jsonString) throws IOException {
        return (AzureVariantResource)JSON.getGson().fromJson(jsonString, AzureVariantResource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_VARIANT_I_D);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AzureVariantResource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AzureVariantResource.class));
            return new TypeAdapter<AzureVariantResource>(){

                public void write(JsonWriter out, AzureVariantResource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AzureVariantResource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AzureVariantResource.validateJsonElement(jsonElement);
                    return (AzureVariantResource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

