/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import io.suger.client.StripePaymentMethod;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class BillingWalletInfo {
    public static final String SERIALIZED_NAME_CLOSE_DATE = "closeDate";
    @SerializedName(value="closeDate")
    @Nullable
    private OffsetDateTime closeDate;
    public static final String SERIALIZED_NAME_STRIPE_PAYMENT_METHOD = "stripePaymentMethod";
    @SerializedName(value="stripePaymentMethod")
    @Nullable
    private StripePaymentMethod stripePaymentMethod;
    public static final String SERIALIZED_NAME_STRIPE_SETUP_INTENT_ID = "stripeSetupIntentId";
    @SerializedName(value="stripeSetupIntentId")
    @Nullable
    private String stripeSetupIntentId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BillingWalletInfo closeDate(@Nullable OffsetDateTime closeDate) {
        this.closeDate = closeDate;
        return this;
    }

    @Nullable
    public OffsetDateTime getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(@Nullable OffsetDateTime closeDate) {
        this.closeDate = closeDate;
    }

    public BillingWalletInfo stripePaymentMethod(@Nullable StripePaymentMethod stripePaymentMethod) {
        this.stripePaymentMethod = stripePaymentMethod;
        return this;
    }

    @Nullable
    public StripePaymentMethod getStripePaymentMethod() {
        return this.stripePaymentMethod;
    }

    public void setStripePaymentMethod(@Nullable StripePaymentMethod stripePaymentMethod) {
        this.stripePaymentMethod = stripePaymentMethod;
    }

    public BillingWalletInfo stripeSetupIntentId(@Nullable String stripeSetupIntentId) {
        this.stripeSetupIntentId = stripeSetupIntentId;
        return this;
    }

    @Nullable
    public String getStripeSetupIntentId() {
        return this.stripeSetupIntentId;
    }

    public void setStripeSetupIntentId(@Nullable String stripeSetupIntentId) {
        this.stripeSetupIntentId = stripeSetupIntentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingWalletInfo billingWalletInfo = (BillingWalletInfo)o;
        return Objects.equals(this.closeDate, billingWalletInfo.closeDate) && Objects.equals(this.stripePaymentMethod, billingWalletInfo.stripePaymentMethod) && Objects.equals(this.stripeSetupIntentId, billingWalletInfo.stripeSetupIntentId);
    }

    public int hashCode() {
        return Objects.hash(this.closeDate, this.stripePaymentMethod, this.stripeSetupIntentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingWalletInfo {\n");
        sb.append("    closeDate: ").append(this.toIndentedString(this.closeDate)).append("\n");
        sb.append("    stripePaymentMethod: ").append(this.toIndentedString(this.stripePaymentMethod)).append("\n");
        sb.append("    stripeSetupIntentId: ").append(this.toIndentedString(this.stripeSetupIntentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in BillingWalletInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BillingWalletInfo` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_STRIPE_PAYMENT_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_STRIPE_PAYMENT_METHOD).isJsonNull()) {
            StripePaymentMethod.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STRIPE_PAYMENT_METHOD));
        }
        if (jsonObj.get(SERIALIZED_NAME_STRIPE_SETUP_INTENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_STRIPE_SETUP_INTENT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STRIPE_SETUP_INTENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `stripeSetupIntentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STRIPE_SETUP_INTENT_ID).toString()));
        }
    }

    public static BillingWalletInfo fromJson(String jsonString) throws IOException {
        return (BillingWalletInfo)JSON.getGson().fromJson(jsonString, BillingWalletInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLOSE_DATE);
        openapiFields.add(SERIALIZED_NAME_STRIPE_PAYMENT_METHOD);
        openapiFields.add(SERIALIZED_NAME_STRIPE_SETUP_INTENT_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BillingWalletInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BillingWalletInfo.class));
            return new TypeAdapter<BillingWalletInfo>(){

                public void write(JsonWriter out, BillingWalletInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BillingWalletInfo read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    BillingWalletInfo.validateJsonElement(jsonElement);
                    return (BillingWalletInfo)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

