/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import io.suger.client.BillingWalletType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class PaymentConfig {
    public static final String SERIALIZED_NAME_ALLOWED_WALLET_TYPES = "allowedWalletTypes";
    @SerializedName(value="allowedWalletTypes")
    @Nullable
    private List<BillingWalletType> allowedWalletTypes = new ArrayList<BillingWalletType>();
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    @Nullable
    private String currency;
    public static final String SERIALIZED_NAME_DEFAULT_WALLET_ID = "defaultWalletId";
    @SerializedName(value="defaultWalletId")
    @Nullable
    private String defaultWalletId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaymentConfig allowedWalletTypes(@Nullable List<BillingWalletType> allowedWalletTypes) {
        this.allowedWalletTypes = allowedWalletTypes;
        return this;
    }

    public PaymentConfig addAllowedWalletTypesItem(BillingWalletType allowedWalletTypesItem) {
        if (this.allowedWalletTypes == null) {
            this.allowedWalletTypes = new ArrayList<BillingWalletType>();
        }
        this.allowedWalletTypes.add(allowedWalletTypesItem);
        return this;
    }

    @Nullable
    public List<BillingWalletType> getAllowedWalletTypes() {
        return this.allowedWalletTypes;
    }

    public void setAllowedWalletTypes(@Nullable List<BillingWalletType> allowedWalletTypes) {
        this.allowedWalletTypes = allowedWalletTypes;
    }

    public PaymentConfig currency(@Nullable String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(@Nullable String currency) {
        this.currency = currency;
    }

    public PaymentConfig defaultWalletId(@Nullable String defaultWalletId) {
        this.defaultWalletId = defaultWalletId;
        return this;
    }

    @Nullable
    public String getDefaultWalletId() {
        return this.defaultWalletId;
    }

    public void setDefaultWalletId(@Nullable String defaultWalletId) {
        this.defaultWalletId = defaultWalletId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentConfig paymentConfig = (PaymentConfig)o;
        return Objects.equals(this.allowedWalletTypes, paymentConfig.allowedWalletTypes) && Objects.equals(this.currency, paymentConfig.currency) && Objects.equals(this.defaultWalletId, paymentConfig.defaultWalletId);
    }

    public int hashCode() {
        return Objects.hash(this.allowedWalletTypes, this.currency, this.defaultWalletId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentConfig {\n");
        sb.append("    allowedWalletTypes: ").append(this.toIndentedString(this.allowedWalletTypes)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    defaultWalletId: ").append(this.toIndentedString(this.defaultWalletId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaymentConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_WALLET_TYPES) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_WALLET_TYPES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALLOWED_WALLET_TYPES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowedWalletTypes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_WALLET_TYPES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_WALLET_ID) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_WALLET_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEFAULT_WALLET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `defaultWalletId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_WALLET_ID).toString()));
        }
    }

    public static PaymentConfig fromJson(String jsonString) throws IOException {
        return (PaymentConfig)JSON.getGson().fromJson(jsonString, PaymentConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOWED_WALLET_TYPES);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_WALLET_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentConfig.class));
            return new TypeAdapter<PaymentConfig>(){

                public void write(JsonWriter out, PaymentConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PaymentConfig.validateJsonElement(jsonElement);
                    return (PaymentConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

