/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import io.suger.client.StripeCustomerAddress;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class StripeCustomer {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    @Nullable
    private StripeCustomerAddress address;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    @Nullable
    private String email;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nullable
    private String id;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    @Nullable
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static final String SERIALIZED_NAME_PHONE = "phone";
    @SerializedName(value="phone")
    @Nullable
    private String phone;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StripeCustomer address(@Nullable StripeCustomerAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    public StripeCustomerAddress getAddress() {
        return this.address;
    }

    public void setAddress(@Nullable StripeCustomerAddress address) {
        this.address = address;
    }

    public StripeCustomer description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public StripeCustomer email(@Nullable String email) {
        this.email = email;
        return this;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    public StripeCustomer id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public StripeCustomer metadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public StripeCustomer putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public StripeCustomer name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public StripeCustomer phone(@Nullable String phone) {
        this.phone = phone;
        return this;
    }

    @Nullable
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(@Nullable String phone) {
        this.phone = phone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StripeCustomer stripeCustomer = (StripeCustomer)o;
        return Objects.equals(this.address, stripeCustomer.address) && Objects.equals(this.description, stripeCustomer.description) && Objects.equals(this.email, stripeCustomer.email) && Objects.equals(this.id, stripeCustomer.id) && Objects.equals(this.metadata, stripeCustomer.metadata) && Objects.equals(this.name, stripeCustomer.name) && Objects.equals(this.phone, stripeCustomer.phone);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.description, this.email, this.id, this.metadata, this.name, this.phone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StripeCustomer {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StripeCustomer is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StripeCustomer` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESS).isJsonNull()) {
            StripeCustomerAddress.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHONE) != null && !jsonObj.get(SERIALIZED_NAME_PHONE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PHONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHONE).toString()));
        }
    }

    public static StripeCustomer fromJson(String jsonString) throws IOException {
        return (StripeCustomer)JSON.getGson().fromJson(jsonString, StripeCustomer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PHONE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StripeCustomer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StripeCustomer.class));
            return new TypeAdapter<StripeCustomer>(){

                public void write(JsonWriter out, StripeCustomer value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StripeCustomer read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StripeCustomer.validateJsonElement(jsonElement);
                    return (StripeCustomer)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

