/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.suger.JSON;
import io.suger.client.StripeError;
import io.suger.client.StripePaymentIntentStatus;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class StripePaymentIntent {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nullable
    private String id;
    public static final String SERIALIZED_NAME_LAST_PAYMENT_ERROR = "last_payment_error";
    @SerializedName(value="last_payment_error")
    @Nullable
    private StripeError lastPaymentError;
    public static final String SERIALIZED_NAME_LIVEMODE = "livemode";
    @SerializedName(value="livemode")
    @Nullable
    private Boolean livemode;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nullable
    private StripePaymentIntentStatus status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StripePaymentIntent id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public StripePaymentIntent lastPaymentError(@Nullable StripeError lastPaymentError) {
        this.lastPaymentError = lastPaymentError;
        return this;
    }

    @Nullable
    public StripeError getLastPaymentError() {
        return this.lastPaymentError;
    }

    public void setLastPaymentError(@Nullable StripeError lastPaymentError) {
        this.lastPaymentError = lastPaymentError;
    }

    public StripePaymentIntent livemode(@Nullable Boolean livemode) {
        this.livemode = livemode;
        return this;
    }

    @Nullable
    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(@Nullable Boolean livemode) {
        this.livemode = livemode;
    }

    public StripePaymentIntent status(@Nullable StripePaymentIntentStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public StripePaymentIntentStatus getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable StripePaymentIntentStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StripePaymentIntent stripePaymentIntent = (StripePaymentIntent)o;
        return Objects.equals(this.id, stripePaymentIntent.id) && Objects.equals(this.lastPaymentError, stripePaymentIntent.lastPaymentError) && Objects.equals(this.livemode, stripePaymentIntent.livemode) && Objects.equals((Object)this.status, (Object)stripePaymentIntent.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.lastPaymentError, this.livemode, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StripePaymentIntent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastPaymentError: ").append(this.toIndentedString(this.lastPaymentError)).append("\n");
        sb.append("    livemode: ").append(this.toIndentedString(this.livemode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StripePaymentIntent is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StripePaymentIntent` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_PAYMENT_ERROR) != null && !jsonObj.get(SERIALIZED_NAME_LAST_PAYMENT_ERROR).isJsonNull()) {
            StripeError.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LAST_PAYMENT_ERROR));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            StripePaymentIntentStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
    }

    public static StripePaymentIntent fromJson(String jsonString) throws IOException {
        return (StripePaymentIntent)JSON.getGson().fromJson(jsonString, StripePaymentIntent.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LAST_PAYMENT_ERROR);
        openapiFields.add(SERIALIZED_NAME_LIVEMODE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StripePaymentIntent.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StripePaymentIntent.class));
            return new TypeAdapter<StripePaymentIntent>(){

                public void write(JsonWriter out, StripePaymentIntent value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StripePaymentIntent read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StripePaymentIntent.validateJsonElement(jsonElement);
                    return (StripePaymentIntent)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

