/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum StripeRefundStatus {
    StripeRefundStatus_Pending("pending"),
    StripeRefundStatus_RequiresAction("requires_action"),
    StripeRefundStatus_Succeeded("succeeded"),
    StripeRefundStatus_Failed("failed"),
    StripeRefundStatus_Canceled("canceled");

    private String value;

    private StripeRefundStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StripeRefundStatus fromValue(String value) {
        for (StripeRefundStatus b : StripeRefundStatus.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        StripeRefundStatus.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<StripeRefundStatus> {
        public void write(JsonWriter jsonWriter, StripeRefundStatus enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public StripeRefundStatus read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return StripeRefundStatus.fromValue(value);
        }
    }
}

