/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum TimeUnit {
    TimeUnit_DAY("DAY"),
    TimeUnit_MONTH("MONTH"),
    TimeUnit_YEAR("YEAR");

    private String value;

    private TimeUnit(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimeUnit fromValue(String value) {
        for (TimeUnit b : TimeUnit.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        TimeUnit.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<TimeUnit> {
        public void write(JsonWriter jsonWriter, TimeUnit enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public TimeUnit read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return TimeUnit.fromValue(value);
        }
    }
}

