/*
 * Decompiled with CFR 0.152.
 */
package io.suger.client;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum ValueType {
    ValueType_UNKNOWN(""),
    ValueType_UNSPECIFIED("VALUE_TYPE_UNSPECIFIED"),
    ValueType_BOOL("BOOL"),
    ValueType_INT64("INT64"),
    ValueType_DOUBLE("DOUBLE"),
    ValueType_STRING("STRING"),
    ValueType_DISTRIBUTION("DISTRIBUTION"),
    ValueType_MONEY("MONEY");

    private String value;

    private ValueType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValueType fromValue(String value) {
        for (ValueType b : ValueType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        ValueType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<ValueType> {
        public void write(JsonWriter jsonWriter, ValueType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public ValueType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return ValueType.fromValue(value);
        }
    }
}

