/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal;

import io.sundr.builder.Builder;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuilderContext;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class BuilderContextManager {
    private static BuilderContext context = null;

    private BuilderContextManager() {
    }

    public static synchronized BuilderContext create(Elements elements, Types types) {
        context = new BuilderContext(elements, types, false, false, Builder.class.getPackage().getName(), new Inline[0]);
        return context;
    }

    public static BuilderContext create(Elements elements, Types types, Boolean validationEnabled, Boolean generateBuilderPackage, String packageName, Inline ... inlineables) {
        if (context == null) {
            context = new BuilderContext(elements, types, generateBuilderPackage, validationEnabled, packageName, inlineables);
            return context;
        }
        if (!packageName.equals(context.getBuilderPackage())) {
            throw new IllegalStateException("Cannot use different builder package names in a single project. Used:" + packageName + " but package:" + context.getGenerateBuilderPackage() + " already exists.");
        }
        if (!generateBuilderPackage.equals(context.getGenerateBuilderPackage())) {
            throw new IllegalStateException("Cannot use different values for generate builder package in a single project.");
        }
        return context;
    }

    public static synchronized BuilderContext getContext() {
        if (context == null) {
            throw new IllegalStateException("Builder context not available.");
        }
        return context;
    }
}

