/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.Function;
import io.sundr.FunctionFactory;
import io.sundr.builder.Constants;
import io.sundr.builder.annotations.FilterDescendants;
import io.sundr.builder.annotations.IgnoreDescendants;
import io.sundr.builder.internal.BuildableRepository;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.codegen.functions.Collections;
import io.sundr.codegen.model.AnnotationRef;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.EditableClassRef;
import io.sundr.codegen.model.Kind;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.StringUtils;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class Descendants {
    private static final String VALUE = "value";
    public static final Function<TypeDef, Set<TypeDef>> BUILDABLE_DECENDANTS = FunctionFactory.cache((Function)new Function<TypeDef, Set<TypeDef>>(){

        public Set<TypeDef> apply(TypeDef item) {
            if (item.equals((Object)TypeDef.OBJECT)) {
                return new LinkedHashSet<TypeDef>();
            }
            LinkedHashSet<TypeDef> result = new LinkedHashSet<TypeDef>();
            BuilderContext ctx = BuilderContextManager.getContext();
            BuildableRepository repository = ctx.getBuildableRepository();
            for (TypeDef type : repository.getBuildables()) {
                if (type.getKind() != Kind.CLASS || type.isAbstract() || !Descendants.isDescendant(type, item) || type.equals((Object)item) || type.hasAttribute(Constants.GENERATED)) continue;
                result.add(type);
            }
            return result;
        }
    });
    public static Function<Property, Set<Property>> PROPERTY_BUILDABLE_DESCENDANTS = FunctionFactory.wrap((Function)new Function<Property, Set<Property>>(){

        public Set<Property> apply(Property property) {
            LinkedHashSet<Property> result;
            block5: {
                TypeDef origin;
                TypeRef baseType;
                block4: {
                    result = new LinkedHashSet<Property>();
                    if (Descendants.isNestingIgnored(property)) {
                        return result;
                    }
                    baseType = property.getTypeRef();
                    origin = (TypeDef)property.getAttribute(Constants.ORIGIN_TYPEDF);
                    if (!((Boolean)Collections.IS_COLLECTION.apply((Object)baseType)).booleanValue()) break block4;
                    TypeRef unwrapped = (TypeRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)baseType);
                    if (!(unwrapped instanceof ClassRef)) break block5;
                    ClassRef candidate = (ClassRef)unwrapped;
                    for (TypeDef descendant : (Set)BUILDABLE_DECENDANTS.apply((Object)candidate.getDefinition())) {
                        EditableClassRef descendantRef = new ClassRefBuilder(descendant.toInternalReference()).build();
                        if (Descendants.isNestingFiltered(property, (ClassRef)descendantRef) || origin.getName().equals(descendant.getName()) && !origin.getPackageName().equals(descendant.getPackageName())) continue;
                        EditableClassRef collectionType = ((ClassRefBuilder)new ClassRefBuilder((ClassRef)baseType).withArguments(new TypeRef[]{descendantRef})).build();
                        String propertyName = StringUtils.deCaptializeFirst((String)descendant.getName()) + property.getNameCapitalized();
                        result.add((Property)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder(property).withName(propertyName)).withTypeRef((TypeRef)collectionType)).addToAttributes(Constants.DESCENDANT_OF, (Object)property)).addToAttributes(Constants.BUILDABLE_ENABLED, (Object)true)).build());
                    }
                    break block5;
                }
                if (baseType instanceof ClassRef) {
                    ClassRef candidate = (ClassRef)baseType;
                    for (TypeDef descendant : (Set)BUILDABLE_DECENDANTS.apply((Object)candidate.getDefinition())) {
                        EditableClassRef descendantRef = new ClassRefBuilder(descendant.toInternalReference()).build();
                        if (Descendants.isNestingFiltered(property, (ClassRef)descendantRef) || origin.getName().equals(descendant.getName()) && !origin.getPackageName().equals(descendant.getPackageName())) continue;
                        String propertyName = StringUtils.deCaptializeFirst((String)(descendant.getName() + property.getNameCapitalized()));
                        result.add((Property)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder(property).withName(propertyName)).withTypeRef((TypeRef)descendantRef)).addToAttributes(Constants.DESCENDANT_OF, (Object)property)).addToAttributes(Constants.BUILDABLE_ENABLED, (Object)true)).build());
                    }
                }
            }
            return result;
        }
    });

    public static boolean isDescendant(TypeDef item, TypeDef candidate) {
        if (item == null || candidate == null) {
            return false;
        }
        return candidate.isAssignableFrom(item);
    }

    public static boolean isNestingIgnored(Property property) {
        for (AnnotationRef ref : property.getAnnotations()) {
            if (!ref.getClassRef().getFullyQualifiedName().equals(IgnoreDescendants.class.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNestingFiltered(Property property, ClassRef classRef) {
        for (AnnotationRef ref : property.getAnnotations()) {
            Pattern p;
            Object value;
            if (!ref.getClassRef().getFullyQualifiedName().equals(FilterDescendants.class.getName())) continue;
            Map parameters = ref.getParameters();
            Object v0 = value = parameters == null ? null : parameters.get(VALUE);
            return !(value instanceof String) || !(property.getTypeRef() instanceof ClassRef) || !(p = Pattern.compile(value)).matcher(classRef.getFullyQualifiedName()).matches();
        }
        return false;
    }
}

