/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.Function;
import io.sundr.FunctionFactory;
import io.sundr.builder.Constants;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.Descendants;
import io.sundr.builder.internal.functions.PropertyAs;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.functions.Collections;
import io.sundr.codegen.functions.Singularize;
import io.sundr.codegen.model.AnnotationRef;
import io.sundr.codegen.model.Attributeable;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.EditableMethod;
import io.sundr.codegen.model.EditableProperty;
import io.sundr.codegen.model.Method;
import io.sundr.codegen.model.MethodBuilder;
import io.sundr.codegen.model.MethodFluent;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.Statement;
import io.sundr.codegen.model.StringStatement;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.StringUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;

public class ToMethod {
    private static final String BUILDABLE_ARRAY_GETTER_TEXT = StringUtils.loadResourceQuietly((String)"snippets/buildable-array-getter.txt");
    private static final String SIMPLE_ARRAY_GETTER_TEXT = StringUtils.loadResourceQuietly((String)"snippets/simple-array-getter.txt");
    public static final Function<Property, Method> WITH = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            String methodName = "with" + property.getNameCapitalized();
            ArrayList<ClassRef> alsoImport = new ArrayList<ClassRef>();
            return ((MethodBuilder)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{property})).withVarArgPreferred(true)).withNewBlock().withStatements(this.getStatements(property, alsoImport))).endBlock()).addToAttributes(Attributeable.ALSO_IMPORT, alsoImport)).build();
        }

        private List<Statement> getStatements(Property property, List<ClassRef> alsoImport) {
            Set descendants;
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            String argumentName = property.getName();
            String fieldName = property.getName();
            TypeRef type = property.getTypeRef();
            TypeRef unwraped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
            ArrayList<Statement> statements = new ArrayList<Statement>();
            Set set = descendants = property.hasAttribute(Constants.DESCENDANTS) ? (Set)property.getAttribute(Constants.DESCENDANTS) : java.util.Collections.EMPTY_SET;
            if (property.hasAttribute(Constants.DESCENDANT_OF)) {
                Property descendantOf = (Property)property.getAttribute(Constants.DESCENDANT_OF);
                fieldName = descendantOf.getName();
            }
            if (BuilderUtils.isBuildable(unwraped)) {
                if (((Boolean)Collections.IS_COLLECTION.apply((Object)type)).booleanValue() || ((Boolean)Collections.IS_MAP.apply((Object)type)).booleanValue()) {
                    statements.add((Statement)new StringStatement("_visitables.removeAll(this." + fieldName + ");"));
                } else {
                    statements.add((Statement)new StringStatement("_visitables.remove(this." + fieldName + ");"));
                }
            }
            if (((Boolean)Collections.IS_COLLECTION.apply((Object)type)).booleanValue() || ((Boolean)Collections.IS_MAP.apply((Object)type)).booleanValue()) {
                statements.add((Statement)new StringStatement("this." + fieldName + ".clear();"));
                if (((Boolean)Collections.IS_MAP.apply((Object)type)).booleanValue()) {
                    statements.add((Statement)new StringStatement("if (" + argumentName + " != null) {this." + fieldName + ".putAll(" + argumentName + ");} return (" + returnType + ") this;"));
                } else if (((Boolean)Collections.IS_LIST.apply((Object)type)).booleanValue() || ((Boolean)Collections.IS_SET.apply((Object)type)).booleanValue()) {
                    String addToMethodName = "addTo" + property.getNameCapitalized();
                    statements.add((Statement)new StringStatement("if (" + argumentName + " != null) {for (" + unwraped.toString() + " item : " + argumentName + "){this." + addToMethodName + "(item);}} return (" + returnType + ") this;"));
                }
                return statements;
            }
            if (BuilderUtils.isBuildable(unwraped) && !TypeUtils.isAbstract((TypeRef)unwraped)) {
                TypeDef builder = (TypeDef)TypeAs.BUILDER.apply((Object)((ClassRef)unwraped).getDefinition());
                String builderClass = builder.toReference(new TypeRef[0]).getName();
                statements.add((Statement)new StringStatement("if (" + argumentName + "!=null){ this." + fieldName + "= new " + builderClass + "(" + argumentName + "); _visitables.add(this." + fieldName + ");} return (" + returnType + ") this;"));
                return statements;
            }
            if (!descendants.isEmpty()) {
                for (Property descendant : descendants) {
                    TypeRef dunwraped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)descendant.getTypeRef());
                    TypeDef builder = (TypeDef)TypeAs.BUILDER.apply((Object)((ClassRef)dunwraped).getDefinition());
                    String builderClass = builder.toReference(new TypeRef[0]).getName();
                    statements.add((Statement)new StringStatement("if (" + argumentName + " instanceof " + dunwraped + "){ this." + fieldName + "= new " + builderClass + "((" + dunwraped + ")" + argumentName + "); _visitables.add(this." + fieldName + ");}"));
                    alsoImport.add((ClassRef)dunwraped);
                    alsoImport.add(builder.toInternalReference());
                }
                statements.add((Statement)new StringStatement("return (" + returnType + ") this;"));
                return statements;
            }
            statements.add((Statement)new StringStatement("this." + fieldName + "=" + argumentName + "; return (" + returnType + ") this;"));
            return statements;
        }
    });
    public static final Function<Property, Method> WITH_ARRAY = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            String methodName = "with" + property.getNameCapitalized();
            TypeRef unwraped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
            String addToMethodName = "addTo" + property.getNameCapitalized();
            TypeRef arrayType = (TypeRef)TypeAs.ARRAY_OF.apply((Object)unwraped);
            EditableProperty arrayProperty = ((PropertyBuilder)new PropertyBuilder(property).withTypeRef(arrayType)).build();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{arrayProperty})).withVarArgPreferred(true)).withNewBlock().addNewStringStatementStatement("this." + property.getName() + ".clear(); if (" + property.getName() + " != null) {for (" + unwraped.toString() + " item :" + property.getName() + "){ this." + addToMethodName + "(item);}} return (" + returnType + ") this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> HAS = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            String prefix = "has";
            String methodName = prefix + property.getNameCapitalized();
            ArrayList<StringStatement> statements = new ArrayList<StringStatement>();
            if (TypeUtils.isPrimitive((TypeRef)property.getTypeRef())) {
                statements.add(new StringStatement("return true;"));
            } else if (TypeUtils.isList((TypeRef)property.getTypeRef()) || TypeUtils.isSet((TypeRef)property.getTypeRef())) {
                statements.add(new StringStatement("return " + property.getName() + "!= null && !" + property.getName() + ".isEmpty();"));
            } else {
                statements.add(new StringStatement("return this." + property.getName() + "!=null;"));
            }
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType(Constants.BOOLEAN_REF)).withArguments(new Property[0])).withNewBlock().withStatements(statements)).endBlock()).build();
        }
    });
    public static final Function<Property, List<Method>> GETTER = FunctionFactory.cache((Function)new Function<Property, List<Method>>(){

        public List<Method> apply(Property property) {
            ArrayList<Method> methods = new ArrayList<Method>();
            TypeRef unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
            String prefix = TypeUtils.isBoolean((TypeRef)property.getTypeRef()) ? "is" : "get";
            String getterName = prefix + property.getNameCapitalized();
            String builderName = "build" + property.getNameCapitalized();
            ArrayList<AnnotationRef> annotations = new ArrayList<AnnotationRef>();
            ArrayList<String> comments = new ArrayList<String>();
            ArrayList<StringStatement> statements = new ArrayList<StringStatement>();
            boolean isNested = false;
            boolean isList = TypeUtils.isList((TypeRef)property.getTypeRef());
            boolean isSet = TypeUtils.isSet((TypeRef)property.getTypeRef());
            TreeSet<Property> descendants = new TreeSet<Property>(new Comparator<Property>(){

                @Override
                public int compare(Property left, Property right) {
                    return left.getName().compareTo(right.getName());
                }
            });
            descendants.addAll((Collection)Descendants.PROPERTY_BUILDABLE_DESCENDANTS.apply((Object)property));
            if (TypeUtils.isMap((TypeRef)property.getTypeRef())) {
                statements.add(new StringStatement("return this." + property.getName() + ";"));
            } else if (BuilderUtils.isBuildable(unwrapped)) {
                isNested = true;
                annotations.add(Constants.DEPRECATED_ANNOTATION);
                comments.add("This method has been deprecated, please use method " + builderName + " instead.");
                if (isList || isSet) {
                    statements.add(new StringStatement("return build(" + property.getName() + ");"));
                } else {
                    statements.add(new StringStatement("return this." + property.getName() + "!=null?this." + property.getName() + ".build():null;"));
                }
            } else if (!descendants.isEmpty()) {
                isNested = true;
                annotations.add(Constants.DEPRECATED_ANNOTATION);
                comments.add("This method has been deprecated, please use method " + builderName + " instead.");
                if (isList || isSet) {
                    statements.add(new StringStatement("return build(" + property.getName() + ");"));
                } else {
                    statements.add(new StringStatement("return this." + property.getName() + "!=null?this." + property.getName() + ".build():null;"));
                }
            } else {
                statements.add(new StringStatement("return this." + property.getName() + ";"));
            }
            EditableMethod getter = ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(comments)).withAnnotations(annotations)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(getterName)).withReturnType(property.getTypeRef())).withArguments(new Property[0])).withNewBlock().withStatements(statements)).endBlock()).build();
            methods.add((Method)getter);
            if (isNested) {
                methods.add((Method)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder((Method)getter).removeFromAnnotations(new AnnotationRef[]{Constants.DEPRECATED_ANNOTATION})).withComments(new String[0])).withName("build" + property.getNameCapitalized())).build());
                if (isList) {
                    methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(new AnnotationRef[0])).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName("build" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).withReturnType(unwrapped)).addToArguments(new Property[]{Constants.INDEX})).withNewBlock().withStatements(new Statement[]{new StringStatement("return this." + property.getName() + ".get(index).build();")})).endBlock()).build());
                    methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(new AnnotationRef[0])).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName("buildFirst" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).withReturnType(unwrapped)).withNewBlock().withStatements(new Statement[]{new StringStatement("return this." + property.getName() + ".get(0).build();")})).endBlock()).build());
                    methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(new AnnotationRef[0])).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName("buildLast" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).withReturnType(unwrapped)).withNewBlock().withStatements(new Statement[]{new StringStatement("return this." + property.getName() + ".get(" + property.getName() + ".size() - 1).build();")})).endBlock()).build());
                    ClassRef builderRef = BuilderUtils.buildableRef(unwrapped);
                    methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodFluent.ArgumentsNested)((MethodFluent.ArgumentsNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(new AnnotationRef[0])).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName("buildMatching" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).addNewArgument().withName("predicate")).withTypeRef((TypeRef)Constants.PREDICATE.toReference(new TypeRef[]{builderRef}))).endArgument()).withReturnType(unwrapped)).withNewBlock().withStatements(new Statement[]{new StringStatement("for (" + builderRef + " item: " + property.getName() + ") { if(predicate.apply(item)){return item.build();} } return null;")})).endBlock()).build());
                }
            } else if (isList) {
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(annotations)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(prefix + Singularize.FUNCTION.apply(property.getNameCapitalized()))).withReturnType(unwrapped)).addToArguments(new Property[]{Constants.INDEX})).withNewBlock().withStatements(new Statement[]{new StringStatement("return this." + property.getName() + ".get(index);")})).endBlock()).build());
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(annotations)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(prefix + "First" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).withReturnType(unwrapped)).withNewBlock().withStatements(new Statement[]{new StringStatement("return this." + property.getName() + ".get(0);")})).endBlock()).build());
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(annotations)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(prefix + "Last" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).withReturnType(unwrapped)).withNewBlock().withStatements(new Statement[]{new StringStatement("return this." + property.getName() + ".get(" + property.getName() + ".size() - 1);")})).endBlock()).build());
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodFluent.ArgumentsNested)((MethodFluent.ArgumentsNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(annotations)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(prefix + "Matching" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).addNewArgument().withName("predicate")).withTypeRef((TypeRef)Constants.PREDICATE.toReference(new TypeRef[]{unwrapped}))).endArgument()).withReturnType(unwrapped)).withNewBlock().withStatements(new Statement[]{new StringStatement("for (" + unwrapped + " item: " + property.getName() + ") { if(predicate.apply(item)){return item;} } return null;")})).endBlock()).build());
            }
            return methods;
        }
    });
    public static final Function<Property, List<Method>> GETTER_ARRAY = FunctionFactory.cache((Function)new Function<Property, List<Method>>(){

        public List<Method> apply(Property property) {
            ArrayList<Method> methods = new ArrayList<Method>();
            ArrayList<AnnotationRef> annotations = new ArrayList<AnnotationRef>();
            ArrayList<String> comments = new ArrayList<String>();
            String prefix = TypeUtils.isBoolean((TypeRef)property.getTypeRef()) ? "is" : "get";
            String getterName = prefix + property.getNameCapitalized();
            String builderName = "build" + property.getNameCapitalized();
            TypeRef unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
            TypeRef type = property.getTypeRef();
            Boolean isBuildable = BuilderUtils.isBuildable(type);
            TypeRef targetType = isBuildable != false ? (TypeRef)TypeAs.VISITABLE_BUILDER.apply((Object)type) : (TypeRef)TypeAs.UNWRAP_ARRAY_OF.apply((Object)type);
            String body = String.format(isBuildable != false ? BUILDABLE_ARRAY_GETTER_TEXT : SIMPLE_ARRAY_GETTER_TEXT, type.toString(), targetType.toString(), property.getName(), targetType.toString(), property.getName());
            if (isBuildable.booleanValue()) {
                annotations.add(Constants.DEPRECATED_ANNOTATION);
                comments.add("This method has been deprecated, please use method " + builderName + " instead.");
            }
            EditableMethod getter = ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(comments)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(getterName)).withReturnType(property.getTypeRef())).withArguments(new Property[0])).withNewBlock().addNewStringStatementStatement(body)).endBlock()).build();
            methods.add((Method)getter);
            if (isBuildable.booleanValue()) {
                methods.add((Method)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder((Method)getter).removeFromAnnotations(new AnnotationRef[]{Constants.DEPRECATED_ANNOTATION})).withComments(new String[0])).withName(builderName)).build());
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(new AnnotationRef[0])).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName("build" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).withReturnType(unwrapped)).addToArguments(new Property[]{Constants.INDEX})).withNewBlock().withStatements(new Statement[]{new StringStatement("return this." + property.getName() + ".get(index).build();")})).endBlock()).build());
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(new AnnotationRef[0])).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName("buildFirst" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).withReturnType(unwrapped)).withNewBlock().withStatements(new Statement[]{new StringStatement("return this." + property.getName() + ".get(0).build();")})).endBlock()).build());
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(new AnnotationRef[0])).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName("buildLast" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).withReturnType(unwrapped)).withNewBlock().withStatements(new Statement[]{new StringStatement("return this." + property.getName() + ".get(" + property.getName() + ".size() - 1).build();")})).endBlock()).build());
                ClassRef builderRef = BuilderUtils.buildableRef(unwrapped);
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodFluent.ArgumentsNested)((MethodFluent.ArgumentsNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(new String[0])).withAnnotations(new AnnotationRef[0])).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName("buildMatching" + Singularize.FUNCTION.apply(property.getNameCapitalized()))).addNewArgument().withName("predicate")).withTypeRef((TypeRef)Constants.PREDICATE.toReference(new TypeRef[]{builderRef}))).endArgument()).withReturnType(unwrapped)).withNewBlock().withStatements(new Statement[]{new StringStatement("for (" + builderRef + " item: " + property.getName() + ") { if(predicate.apply(item)){return item.build();} } return null;")})).endBlock()).build());
            }
            return methods;
        }
    });
    public static final Function<Property, Method> SETTER = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            String methodName = "set" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)Constants.VOID)).withArguments(new Property[0])).withNewBlock().addNewStringStatementStatement("this." + property.getName() + "=" + property.getName() + ";")).endBlock()).build();
        }
    });
    public static final Function<Property, List<Method>> ADD_TO_COLLECTION = FunctionFactory.cache((Function)new Function<Property, List<Method>>(){

        public List<Method> apply(Property property) {
            ClassRef targetType;
            Property attrValue;
            ArrayList<Method> methods = new ArrayList<Method>();
            ClassRef baseType = (ClassRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)property.getTypeRef());
            TypeDef originTypeDef = (TypeDef)property.getAttribute(Constants.ORIGIN_TYPEDF);
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            TypeRef unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF).apply((Object)property.getTypeRef());
            ArrayList<ClassRef> alsoImport = new ArrayList<ClassRef>();
            EditableProperty item = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder(property).withName("items")).withTypeRef(unwrapped.withDimensions(1))).build();
            EditableProperty unwrappedProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder(property).withName("item")).withTypeRef(unwrapped)).build();
            ArrayList parameters = new ArrayList();
            String addVarargMethodName = "addTo" + property.getNameCapitalized();
            String setMethodName = "setTo" + property.getNameCapitalized();
            String addAllMethodName = "addAllTo" + BuilderUtils.fullyQualifiedNameDiff((TypeRef)baseType, originTypeDef) + property.getNameCapitalized();
            ArrayList<Object> statements = new ArrayList<Object>();
            Set descendants = (Set)Descendants.PROPERTY_BUILDABLE_DESCENDANTS.apply((Object)property);
            String propertyName = property.getName();
            if (property.hasAttribute(Constants.DESCENDANT_OF) && (attrValue = (Property)property.getAttribute(Constants.DESCENDANT_OF)) != null) {
                propertyName = attrValue.getName();
            }
            EditableMethod addSingleItemAtIndex = ((MethodBuilder)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withName(addVarargMethodName)).withReturnType((TypeRef)returnType)).addToArguments(new Property[]{Constants.INDEX})).addToArguments(new Property[]{unwrappedProperty})).withNewBlock().withStatements(new Statement[]{new StringStatement("this." + propertyName + ".add(index, item); return (" + returnType + ")this;")})).endBlock()).addToAttributes(Attributeable.ALSO_IMPORT, alsoImport)).build();
            EditableMethod setSingleItemAtIndex = ((MethodBuilder)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withName(setMethodName)).withReturnType((TypeRef)returnType)).addToArguments(new Property[]{Constants.INDEX})).addToArguments(new Property[]{unwrappedProperty})).withNewBlock().withStatements(new Statement[]{new StringStatement("this." + propertyName + ".set(index, item); return (" + returnType + ")this;")})).endBlock()).addToAttributes(Attributeable.ALSO_IMPORT, alsoImport)).build();
            if (BuilderUtils.isBuildable(unwrapped) && !TypeUtils.isAbstract((TypeRef)unwrapped)) {
                targetType = (ClassRef)unwrapped;
                String targetClass = targetType.getName();
                parameters.addAll(targetType.getDefinition().getParameters());
                String builderClass = targetClass + "Builder";
                alsoImport.add(((TypeDef)TypeAs.BUILDER.apply((Object)targetType.getDefinition())).toInternalReference());
                statements.add(new StringStatement("for (" + targetClass + " item : items) {" + builderClass + " builder = new " + builderClass + "(item);_visitables.add(builder);this." + propertyName + ".add(builder);} return (" + returnType + ")this;"));
                addSingleItemAtIndex = ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)new MethodBuilder((Method)addSingleItemAtIndex).withParameters(parameters)).editBlock().withStatements(new Statement[]{new StringStatement(builderClass + " builder = new " + builderClass + "(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this." + propertyName + ".add(index >= 0 ? index : " + propertyName + ".size(), builder); return (" + returnType + ")this;")})).endBlock()).build();
                setSingleItemAtIndex = ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)new MethodBuilder((Method)setSingleItemAtIndex).withParameters(parameters)).editBlock().withStatements(new Statement[]{new StringStatement(builderClass + " builder = new " + builderClass + "(item);"), new StringStatement("if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}"), new StringStatement("if (index < 0 || index >= " + propertyName + ".size()) { " + propertyName + ".add(builder); } else { " + propertyName + ".set(index, builder);}"), new StringStatement(" return (" + returnType + ")this;")})).endBlock()).build();
            } else if (!descendants.isEmpty()) {
                targetType = (ClassRef)unwrapped;
                parameters.addAll(targetType.getDefinition().getParameters());
                statements.add(new StringStatement("for (" + targetType.toString() + " item : items) { "));
                statements.add(this.createAddToDescendants("addTo", descendants, (TypeRef)targetType, (TypeRef)returnType, false));
                statements.add(new StringStatement("} return (" + returnType + ")this;"));
                addSingleItemAtIndex = ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)new MethodBuilder((Method)addSingleItemAtIndex).withParameters(parameters)).editBlock().withStatements(new Statement[]{this.createAddToDescendants("addTo", descendants, (TypeRef)targetType, (TypeRef)returnType, true), new StringStatement("return (" + returnType + ")this;")})).endBlock()).build();
                setSingleItemAtIndex = ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)new MethodBuilder((Method)setSingleItemAtIndex).withParameters(parameters)).editBlock().withStatements(new Statement[]{this.createAddToDescendants("setTo", descendants, (TypeRef)targetType, (TypeRef)returnType, true), new StringStatement("return (" + returnType + ")this;")})).endBlock()).build();
            } else {
                statements.add(new StringStatement("for (" + unwrapped.toString() + " item : items) {this." + property.getName() + ".add(item);} return (" + returnType + ")this;"));
            }
            EditableMethod addVaragToCollection = ((MethodBuilder)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withName(addVarargMethodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{item})).withVarArgPreferred(true)).withNewBlock().withStatements(statements)).endBlock()).addToAttributes(Attributeable.ALSO_IMPORT, alsoImport)).build();
            EditableMethod addAllToCollection = ((MethodBuilder)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withName(addAllMethodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{((PropertyBuilder)new PropertyBuilder((Property)item).withTypeRef((TypeRef)Collections.COLLECTION.toReference(new TypeRef[]{unwrapped}))).build()})).withNewBlock().withStatements(statements)).endBlock()).addToAttributes(Attributeable.ALSO_IMPORT, alsoImport)).build();
            methods.add((Method)addSingleItemAtIndex);
            methods.add((Method)setSingleItemAtIndex);
            methods.add((Method)addVaragToCollection);
            methods.add((Method)addAllToCollection);
            return methods;
        }

        private Statement createAddToDescendants(final String prefix, Set<Property> descendants, TypeRef targetType, TypeRef returnType, final boolean useIndex) {
            return new StringStatement(StringUtils.join(descendants, (Function)new Function<Property, String>(){

                public String apply(Property item) {
                    TypeRef itemRef = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.ARRAY_OF).apply((Object)item.getTypeRef());
                    String className = ((ClassRef)itemRef).getName();
                    String methodName = prefix + StringUtils.captializeFirst((String)item.getName());
                    return "if (item instanceof " + className + "){" + methodName + "(" + (useIndex ? "index, " : "") + "(" + className + ")item);}\n";
                }
            }, (String)" else "));
        }
    });
    public static final Function<Property, List<Method>> REMOVE_FROM_COLLECTION = FunctionFactory.cache((Function)new Function<Property, List<Method>>(){

        public List<Method> apply(Property property) {
            ClassRef targetType;
            ArrayList<Method> methods = new ArrayList<Method>();
            ClassRef baseType = (ClassRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)property.getTypeRef());
            TypeDef originTypeDef = (TypeDef)property.getAttribute(Constants.ORIGIN_TYPEDF);
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            TypeRef unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF).apply((Object)property.getTypeRef());
            ArrayList<ClassRef> alsoImport = new ArrayList<ClassRef>();
            EditableProperty item = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder(property).withName("items")).withTypeRef(unwrapped.withDimensions(1))).build();
            ArrayList parameters = new ArrayList();
            String removeVarargMethodName = "removeFrom" + property.getNameCapitalized();
            String removeAllMethdoName = "removeAllFrom" + BuilderUtils.fullyQualifiedNameDiff((TypeRef)baseType, originTypeDef) + property.getNameCapitalized();
            ArrayList<StringStatement> statements = new ArrayList<StringStatement>();
            Set descendants = (Set)Descendants.PROPERTY_BUILDABLE_DESCENDANTS.apply((Object)property);
            if (BuilderUtils.isBuildable(unwrapped) && !TypeUtils.isAbstract((TypeRef)unwrapped)) {
                Property attrValue;
                targetType = (ClassRef)unwrapped;
                String propertyName = property.getName();
                if (property.hasAttribute(Constants.DESCENDANT_OF) && (attrValue = (Property)property.getAttribute(Constants.DESCENDANT_OF)) != null) {
                    propertyName = attrValue.getName();
                }
                String targetClass = targetType.getName();
                parameters.addAll(targetType.getDefinition().getParameters());
                String builderClass = targetClass + "Builder";
                alsoImport.add(((TypeDef)TypeAs.BUILDER.apply((Object)targetType.getDefinition())).toInternalReference());
                statements.add(new StringStatement("for (" + targetClass + " item : items) {" + builderClass + " builder = new " + builderClass + "(item);_visitables.remove(builder);this." + propertyName + ".remove(builder);} return (" + returnType + ")this;"));
            } else if (!descendants.isEmpty()) {
                targetType = (ClassRef)unwrapped;
                parameters.addAll(targetType.getDefinition().getParameters());
                statements.add(new StringStatement("for (" + targetType.toString() + " item : items) {" + StringUtils.join((Iterable)descendants, (Function)new Function<Property, String>(){

                    public String apply(Property item) {
                        TypeRef itemRef = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.ARRAY_OF).apply((Object)item.getTypeRef());
                        String className = ((ClassRef)itemRef).getName();
                        String removeFromMethodName = "removeFrom" + StringUtils.captializeFirst((String)item.getName());
                        return "if (item instanceof " + className + "){" + removeFromMethodName + "((" + className + ")item);}\n";
                    }
                }, (String)" else ") + "} return (" + returnType + ")this;"));
            } else {
                statements.add(new StringStatement("for (" + unwrapped.toString() + " item : items) {this." + property.getName() + ".remove(item);} return (" + returnType + ")this;"));
            }
            EditableMethod removeVarargFromCollection = ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(removeVarargMethodName)).withParameters(parameters)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{item})).withVarArgPreferred(true)).withNewBlock().withStatements(statements)).endBlock()).build();
            EditableMethod removeAllFromCollection = ((MethodBuilder)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withName(removeAllMethdoName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{((PropertyBuilder)new PropertyBuilder((Property)item).withTypeRef((TypeRef)Collections.COLLECTION.toReference(new TypeRef[]{unwrapped}))).build()})).withNewBlock().withStatements(statements)).endBlock()).addToAttributes(Attributeable.ALSO_IMPORT, alsoImport)).build();
            methods.add((Method)removeVarargFromCollection);
            methods.add((Method)removeAllFromCollection);
            return methods;
        }
    });
    public static final Function<Property, Method> ADD_MAP_TO_MAP = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            ClassRef mapType = (ClassRef)property.getTypeRef();
            EditableProperty mapProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("map")).withTypeRef((TypeRef)mapType)).build();
            String methodName = "addTo" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{mapProperty})).withNewBlock().addNewStringStatementStatement("if(map != null) { this." + property.getName() + ".putAll(map);} return (" + returnType + ")this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> ADD_TO_MAP = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            ClassRef mapType = (ClassRef)property.getTypeRef();
            TypeRef keyType = (TypeRef)mapType.getArguments().get(0);
            TypeRef valueType = (TypeRef)mapType.getArguments().get(1);
            EditableProperty keyProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("key")).withTypeRef(keyType)).build();
            EditableProperty valueProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("value")).withTypeRef(valueType)).build();
            String methodName = "addTo" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{keyProperty, valueProperty})).withNewBlock().addNewStringStatementStatement("if(key != null && value != null) {this." + property.getName() + ".put(key, value);} return (" + returnType + ")this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> REMOVE_MAP_FROM_MAP = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            TypeRef mapType = property.getTypeRef();
            EditableProperty mapProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("map")).withTypeRef(mapType)).build();
            String methodName = "removeFrom" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{mapProperty})).withNewBlock().addNewStringStatementStatement("if(map != null) { for(Object key : map.keySet()) {this." + property.getName() + ".remove(key);}} return (" + returnType + ")this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> REMOVE_FROM_MAP = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            ClassRef mapType = (ClassRef)property.getTypeRef();
            TypeRef keyType = (TypeRef)mapType.getArguments().get(0);
            EditableProperty keyProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("key")).withTypeRef(keyType)).build();
            String methodName = "removeFrom" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{keyProperty})).withNewBlock().addNewStringStatementStatement("if(key != null) {this." + property.getName() + ".remove(key);} return (" + returnType + ")this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> WITH_NEW_NESTED = new Function<Property, Method>(){

        public Method apply(Property property) {
            ClassRef baseType = (ClassRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)property.getTypeRef());
            TypeDef originTypeDef = (TypeDef)property.getAttribute(Constants.ORIGIN_TYPEDF);
            TypeDef propertyTypeDef = BuilderContextManager.getContext().getDefinitionRepository().getDefinition(baseType.getDefinition().getFullyQualifiedName());
            if (propertyTypeDef != null) {
                baseType = propertyTypeDef.toInternalReference();
            }
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            TypeDef nestedType = (TypeDef)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            TypeDef nestedTypeImpl = (TypeDef)PropertyAs.NESTED_CLASS_TYPE.apply((Object)property);
            List parameters = baseType.getDefinition().getParameters();
            ArrayList<Object> typeArguments = new ArrayList<Object>();
            for (TypeRef arg : baseType.getArguments()) {
                typeArguments.add(arg);
            }
            typeArguments.add(returnType);
            ClassRef rewraped = nestedType.toReference(typeArguments);
            ClassRef rewrapedImpl = nestedTypeImpl.toReference(typeArguments);
            boolean isCollection = (Boolean)Collections.IS_COLLECTION.apply((Object)property.getTypeRef());
            String prefix = isCollection ? "addNew" : "withNew";
            prefix = prefix + BuilderUtils.fullyQualifiedNameDiff((TypeRef)baseType, originTypeDef);
            String methodName = prefix + StringUtils.captializeFirst((String)(isCollection ? Singularize.FUNCTION.apply(property.getName()) : property.getName()));
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withReturnType((TypeRef)rewraped)).withName(methodName)).withNewBlock().addNewStringStatementStatement("return new " + rewrapedImpl.getName() + "();")).endBlock()).build();
        }
    };
    public static final Function<Property, Set<Method>> WITH_NESTED_INLINE = new Function<Property, Set<Method>>(){

        public Set<Method> apply(Property property) {
            TypeDef originTypeDef = (TypeDef)property.getAttribute(Constants.ORIGIN_TYPEDF);
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            LinkedHashSet<Method> result = new LinkedHashSet<Method>();
            TypeRef unwrappedType = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
            TypeDef baseType = BuilderContextManager.getContext().getBuildableRepository().getBuildable(unwrappedType);
            for (Method constructor : BuilderUtils.getInlineableConstructors(property)) {
                boolean isCollection = (Boolean)Collections.IS_COLLECTION.apply((Object)property.getTypeRef());
                String ownPrefix = isCollection ? "addNew" : "withNew";
                ownPrefix = ownPrefix + BuilderUtils.fullyQualifiedNameDiff((TypeRef)baseType.toInternalReference(), originTypeDef);
                String ownName = ownPrefix + StringUtils.captializeFirst((String)(isCollection ? Singularize.FUNCTION.apply(property.getName()) : property.getName()));
                String delegatePrefix = (Boolean)Collections.IS_COLLECTION.apply((Object)property.getTypeRef()) != false ? "addTo" : "with";
                String delegateName = delegatePrefix + StringUtils.captializeFirst((String)property.getName());
                String args = StringUtils.join((Iterable)constructor.getArguments(), (Function)new Function<Property, String>(){

                    public String apply(Property item) {
                        return item.getName();
                    }
                }, (String)", ");
                result.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withReturnType((TypeRef)returnType)).withArguments(constructor.getArguments())).withName(ownName)).withParameters(baseType.getParameters())).withNewBlock().addNewStringStatementStatement("return (" + returnType + ")" + delegateName + "(new " + baseType.getName() + "(" + args + "));")).endBlock()).build());
            }
            return result;
        }
    };
    public static final Function<Property, Method> EDIT_OR_NEW = new Function<Property, Method>(){

        public Method apply(Property property) {
            ClassRef baseType = (ClassRef)property.getTypeRef();
            ClassRef builderType = ((TypeDef)TypeAs.SHALLOW_BUILDER.apply((Object)baseType.getDefinition())).toReference(new TypeRef[0]);
            TypeDef propertyTypeDef = BuilderContextManager.getContext().getDefinitionRepository().getDefinition(baseType.getDefinition().getFullyQualifiedName());
            if (propertyTypeDef != null) {
                baseType = propertyTypeDef.toInternalReference();
            }
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            TypeDef nestedType = (TypeDef)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            List parameters = baseType.getDefinition().getParameters();
            ArrayList<Object> typeArguments = new ArrayList<Object>();
            for (TypeRef ignore : baseType.getArguments()) {
                typeArguments.add(Constants.Q);
            }
            typeArguments.add(returnType);
            ClassRef rewraped = nestedType.toReference(typeArguments);
            String prefix = "editOrNew";
            String methodNameBase = StringUtils.captializeFirst((String)property.getName());
            String methodName = prefix + methodNameBase;
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withReturnType((TypeRef)rewraped)).withName(methodName)).withNewBlock().addNewStringStatementStatement("return withNew" + methodNameBase + "Like(get" + methodNameBase + "() != null ? get" + methodNameBase + "(): new " + builderType.getName() + "().build());")).endBlock()).build();
        }
    };
    public static final Function<Property, Method> EDIT_OR_NEW_LIKE = new Function<Property, Method>(){

        public Method apply(Property property) {
            ClassRef baseType = (ClassRef)property.getTypeRef();
            TypeDef propertyTypeDef = BuilderContextManager.getContext().getDefinitionRepository().getDefinition(baseType.getDefinition().getFullyQualifiedName());
            if (propertyTypeDef != null) {
                baseType = propertyTypeDef.toInternalReference();
            }
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            TypeDef nestedType = (TypeDef)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            List parameters = baseType.getDefinition().getParameters();
            ArrayList<Object> typeArguments = new ArrayList<Object>();
            for (TypeRef ignore : baseType.getArguments()) {
                typeArguments.add(Constants.Q);
            }
            typeArguments.add(returnType);
            ClassRef rewraped = nestedType.toReference(typeArguments);
            String prefix = "editOrNew";
            String suffix = "Like";
            String methodNameBase = StringUtils.captializeFirst((String)property.getName());
            String methodName = prefix + methodNameBase + suffix;
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodFluent.ArgumentsNested)((MethodFluent.ArgumentsNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withReturnType((TypeRef)rewraped)).withName(methodName)).addNewArgument().withName("item")).withTypeRef((TypeRef)baseType)).endArgument()).withNewBlock().addNewStringStatementStatement("return withNew" + methodNameBase + "Like(get" + methodNameBase + "() != null ? get" + methodNameBase + "(): item);")).endBlock()).build();
        }
    };
    public static final Function<Property, Method> WITH_NEW_LIKE_NESTED = new Function<Property, Method>(){

        public Method apply(Property property) {
            ClassRef baseType = (ClassRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)property.getTypeRef());
            TypeDef propertyTypeDef = BuilderContextManager.getContext().getDefinitionRepository().getDefinition(baseType.getDefinition().getFullyQualifiedName());
            if (propertyTypeDef != null) {
                baseType = propertyTypeDef.toInternalReference();
            }
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            TypeDef nestedType = (TypeDef)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            TypeDef nestedTypeImpl = (TypeDef)PropertyAs.NESTED_CLASS_TYPE.apply((Object)property);
            List parameters = baseType.getDefinition().getParameters();
            ArrayList<Object> typeArguments = new ArrayList<Object>();
            for (TypeRef ignore : baseType.getArguments()) {
                typeArguments.add(Constants.Q);
            }
            typeArguments.add(returnType);
            ClassRef rewraped = nestedType.toReference(typeArguments);
            ClassRef rewrapedImpl = nestedTypeImpl.toReference(typeArguments);
            boolean isCollection = (Boolean)Collections.IS_COLLECTION.apply((Object)property.getTypeRef());
            String prefix = isCollection ? "addNew" : "withNew";
            String suffix = "Like";
            String methodName = prefix + StringUtils.captializeFirst((String)(isCollection ? Singularize.FUNCTION.apply(property.getName()) : property.getName())) + suffix;
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodFluent.ArgumentsNested)((MethodFluent.ArgumentsNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withReturnType((TypeRef)rewraped)).withName(methodName)).addNewArgument().withName("item")).withTypeRef((TypeRef)baseType)).endArgument()).withNewBlock().addNewStringStatementStatement("return new " + rewrapedImpl.getName() + "(" + (isCollection ? "-1, " : "") + "item);")).endBlock()).build();
        }
    };
    public static final Function<Property, Method> WITH_NEW_LIKE_NESTED_AT_INDEX = new Function<Property, Method>(){

        public Method apply(Property property) {
            Method method = (Method)WITH_NEW_LIKE_NESTED.apply((Object)property);
            ClassRef baseType = (ClassRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)property.getTypeRef());
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeParamRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            TypeDef nestedTypeImpl = (TypeDef)PropertyAs.NESTED_CLASS_TYPE.apply((Object)property);
            ArrayList<Object> typeArguments = new ArrayList<Object>();
            for (TypeRef ignore : baseType.getArguments()) {
                typeArguments.add(Constants.Q);
            }
            typeArguments.add(returnType);
            ClassRef rewrapedImpl = nestedTypeImpl.toReference(typeArguments);
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)new MethodBuilder(method).addToArguments(0, Constants.INDEX)).withName(method.getName().replaceFirst("add", "set"))).editBlock().withStatements(new Statement[]{new StringStatement("return new " + rewrapedImpl.getName() + "(index, item);")})).endBlock()).build();
        }
    };
    public static final Function<Property, List<Method>> EDIT_NESTED = new Function<Property, List<Method>>(){

        public List<Method> apply(Property property) {
            ArrayList<Method> methods = new ArrayList<Method>();
            TypeDef originTypeDef = (TypeDef)property.getAttribute(Constants.ORIGIN_TYPEDF);
            ClassRef unwrapped = (ClassRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)property.getTypeRef());
            TypeDef builderType = (TypeDef)TypeAs.BUILDER.apply((Object)unwrapped.getDefinition());
            TypeDef propertyTypeDef = BuilderContextManager.getContext().getDefinitionRepository().getDefinition(unwrapped.getDefinition().getFullyQualifiedName());
            if (propertyTypeDef != null) {
                unwrapped = propertyTypeDef.toInternalReference();
            }
            TypeParamRef returnType = property.hasAttribute(Constants.GENERIC_TYPE_REF) ? (TypeRef)property.getAttribute(Constants.GENERIC_TYPE_REF) : Constants.T_REF;
            TypeDef nestedType = (TypeDef)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            TypeDef nestedTypeImpl = (TypeDef)PropertyAs.NESTED_CLASS_TYPE.apply((Object)property);
            LinkedHashSet parameters = new LinkedHashSet(unwrapped.getDefinition().getParameters());
            ArrayList<Object> typeArguments = new ArrayList<Object>();
            for (TypeRef ignore : unwrapped.getArguments()) {
                typeArguments.add(Constants.Q);
            }
            typeArguments.add(returnType);
            ClassRef rewraped = nestedType.toReference(typeArguments);
            ClassRef rewrapedImpl = nestedTypeImpl.toReference(typeArguments);
            String prefix = "edit";
            prefix = prefix + BuilderUtils.fullyQualifiedNameDiff(property.getTypeRef(), originTypeDef);
            String methodNameBase = StringUtils.captializeFirst((String)property.getName());
            String methodName = prefix + methodNameBase;
            EditableMethod base = ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withReturnType((TypeRef)rewraped)).withName(methodName)).withNewBlock().addNewStringStatementStatement("return withNew" + methodNameBase + "Like(get" + methodNameBase + "());")).endBlock()).build();
            if (TypeUtils.isList((TypeRef)property.getTypeRef()) || TypeUtils.isArray((TypeRef)property.getTypeRef())) {
                String suffix = Singularize.FUNCTION.apply(StringUtils.captializeFirst((String)property.getName()));
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)new MethodBuilder((Method)base).withArguments(new Property[]{Constants.INDEX})).withName("edit" + suffix)).editBlock().withStatements(new Statement[]{new StringStatement("if (" + property.getName() + ".size() <= index) throw new RuntimeException(\"Can't edit " + property.getName() + ". Index exceeds size.\");"), new StringStatement("return setNew" + suffix + "Like(index, build" + suffix + "(index));")})).endBlock()).build());
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)new MethodBuilder((Method)base).withName("editFirst" + suffix)).withArguments(new Property[0])).editBlock().withStatements(new Statement[]{new StringStatement("if (" + property.getName() + ".size() == 0) throw new RuntimeException(\"Can't edit first " + property.getName() + ". The list is empty.\");"), new StringStatement("return setNew" + suffix + "Like(0, build" + suffix + "(0));")})).endBlock()).build());
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)new MethodBuilder((Method)base).withName("editLast" + suffix)).withArguments(new Property[0])).editBlock().withStatements(new Statement[]{new StringStatement("int index = " + property.getName() + ".size() - 1;"), new StringStatement("if (index < 0) throw new RuntimeException(\"Can't edit last " + property.getName() + ". The list is empty.\");"), new StringStatement("return setNew" + suffix + "Like(index, build" + suffix + "(index));")})).endBlock()).build());
                ClassRef builderRef = BuilderUtils.buildableRef((TypeRef)unwrapped);
                methods.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodFluent.ArgumentsNested)((MethodFluent.ArgumentsNested)((MethodBuilder)new MethodBuilder((Method)base).withName("editMatching" + suffix)).addNewArgument().withName("predicate")).withTypeRef((TypeRef)Constants.PREDICATE.toReference(new TypeRef[]{builderRef}))).endArgument()).editBlock().withStatements(new Statement[]{new StringStatement("int index = -1;"), new StringStatement("for (int i=0;i<" + property.getName() + ".size();i++) { "), new StringStatement("if (predicate.apply(" + property.getName() + ".get(i))) {index = i; break;}"), new StringStatement("} "), new StringStatement("if (index < 0) throw new RuntimeException(\"Can't edit matching " + property.getName() + ". No match found.\");"), new StringStatement("return setNew" + suffix + "Like(index, build" + suffix + "(index));")})).endBlock()).build());
            } else {
                methods.add((Method)base);
            }
            return methods;
        }
    };
    public static final Function<Property, Method> AND = new Function<Property, Method>(){

        public Method apply(Property property) {
            String classPrefix = this.getClassPrefix(property);
            boolean isArray = TypeUtils.isArray((TypeRef)property.getTypeRef());
            boolean isList = TypeUtils.isList((TypeRef)property.getTypeRef());
            boolean isSet = TypeUtils.isSet((TypeRef)property.getTypeRef());
            String prefix = isArray || isList ? "setTo" : "with";
            String withMethodName = prefix + StringUtils.captializeFirst((String)property.getName());
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withReturnType((TypeRef)Constants.N_REF)).withName("and")).withNewBlock().addNewStringStatementStatement("return (N) " + classPrefix + withMethodName + "(" + (isArray || isList ? "index, " : "") + "builder.build());")).endBlock()).build();
        }

        private String getClassPrefix(Property property) {
            TypeDef memberOf = (TypeDef)property.getAttribute(Constants.OUTER_CLASS);
            if (memberOf != null) {
                return memberOf.getName() + ".this.";
            }
            return "";
        }
    };
    public static final Function<Property, Method> END = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeDef originTypeDef = (TypeDef)property.getAttribute(Constants.ORIGIN_TYPEDF);
            String methodName = "end" + BuilderUtils.fullyQualifiedNameDiff(property.getTypeRef(), originTypeDef) + StringUtils.captializeFirst((String)((Boolean)Collections.IS_COLLECTION.apply((Object)property.getTypeRef()) != false ? Singularize.FUNCTION.apply(property.getName()) : property.getName()));
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withReturnType((TypeRef)Constants.N_REF)).withName(methodName)).withNewBlock().addNewStringStatementStatement("return and();")).endBlock()).build();
        }
    });
}

