/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.Function;
import io.sundr.FunctionFactory;
import io.sundr.builder.Constants;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.functions.Collections;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.EditableTypeParamDef;
import io.sundr.codegen.model.EditableWildcardRef;
import io.sundr.codegen.model.Kind;
import io.sundr.codegen.model.Method;
import io.sundr.codegen.model.PrimitiveRef;
import io.sundr.codegen.model.PrimitiveRefBuilder;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeParamDefBuilder;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeParamRefBuilder;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.model.WildcardRefBuilder;
import io.sundr.codegen.utils.TypeUtils;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;

public class TypeAs {
    public static final Function<TypeDef, TypeDef> FLUENT_INTERFACE = new Function<TypeDef, TypeDef>(){

        public TypeDef apply(TypeDef item) {
            BuilderContext ctx = BuilderContextManager.getContext();
            TypeDef fluent = (TypeDef)SHALLOW_FLUENT.apply((Object)item);
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>(item.getParameters());
            ArrayList<TypeParamRef> superClassParameters = new ArrayList<TypeParamRef>();
            TypeParamDef nextParameter = BuilderUtils.getNextGeneric(item, parameters);
            ClassRef builableSuperClassRef = BuilderUtils.findBuildableSuperClassRef(item);
            TypeDef buildableSuperClass = BuilderUtils.findBuildableSuperClass(item);
            if (builableSuperClassRef != null) {
                superClassParameters.addAll(builableSuperClassRef.getArguments());
            }
            EditableTypeParamDef parameterFluent = ((TypeParamDefBuilder)new TypeParamDefBuilder(nextParameter).addToBounds(new ClassRef[]{fluent.toInternalReference()})).build();
            parameters.add((TypeParamDef)parameterFluent);
            superClassParameters.add(parameterFluent.toReference());
            TypeDef superClass = buildableSuperClass != null ? (TypeDef)SHALLOW_FLUENT.apply((Object)buildableSuperClass) : ctx.getFluentInterface();
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(item).withKind(Kind.INTERFACE)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(item.getName() + "Fluent")).withPackageName(item.getPackageName())).withParameters(parameters)).withExtendsList(new ClassRef[]{superClass.toReference(superClassParameters)})).withImplementsList(new ClassRef[0])).withInnerTypes(new TypeDef[0])).build();
        }
    };
    public static final Function<TypeDef, TypeDef> FLUENT_IMPL = new Function<TypeDef, TypeDef>(){

        public TypeDef apply(TypeDef item) {
            BuilderContext ctx = BuilderContextManager.getContext();
            TypeDef fluent = (TypeDef)SHALLOW_FLUENT.apply((Object)item);
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>(item.getParameters());
            ArrayList<TypeParamRef> superClassParameters = new ArrayList<TypeParamRef>();
            TypeParamDef nextParameter = BuilderUtils.getNextGeneric(item, parameters);
            ClassRef builableSuperClassRef = BuilderUtils.findBuildableSuperClassRef(item);
            if (builableSuperClassRef != null) {
                superClassParameters.addAll(builableSuperClassRef.getArguments());
            }
            EditableTypeParamDef parameterFluent = ((TypeParamDefBuilder)new TypeParamDefBuilder(nextParameter).addToBounds(new ClassRef[]{fluent.toInternalReference()})).build();
            parameters.add((TypeParamDef)parameterFluent);
            superClassParameters.add(parameterFluent.toReference());
            TypeDef buildableSuperClass = BuilderUtils.findBuildableSuperClass(item);
            TypeDef superClass = buildableSuperClass != null ? (TypeDef)FLUENT_IMPL.apply((Object)buildableSuperClass) : ctx.getBaseFluentClass();
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(item).withKind(Kind.CLASS)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(item.getName() + "FluentImpl")).withPackageName(item.getPackageName())).withParameters(parameters)).withExtendsList(new ClassRef[]{superClass.toReference(superClassParameters)})).withImplementsList(new ClassRef[]{((TypeDef)SHALLOW_FLUENT.apply((Object)item)).toInternalReference()})).withInnerTypes(new TypeDef[0])).build();
        }
    };
    public static final Function<TypeDef, TypeDef> SHALLOW_FLUENT = new Function<TypeDef, TypeDef>(){

        public TypeDef apply(TypeDef item) {
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>(item.getParameters());
            parameters.add(BuilderUtils.getNextGeneric(item, new TypeParamDef[0]));
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(item).withKind(Kind.INTERFACE)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(item.getName() + "Fluent")).withParameters(parameters)).withInnerTypes(new TypeDef[0])).build();
        }
    };
    public static final Function<TypeDef, ClassRef> FLUENT_REF = new Function<TypeDef, ClassRef>(){

        public ClassRef apply(TypeDef item) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            for (TypeParamDef param : item.getParameters()) {
                parameters.add(param.toReference());
            }
            parameters.add(Constants.Q);
            return ((TypeDef)SHALLOW_FLUENT.apply((Object)item)).toReference(parameters);
        }
    };
    public static final Function<TypeDef, TypeDef> BUILDER = new Function<TypeDef, TypeDef>(){

        public TypeDef apply(TypeDef item) {
            TypeDef builder = (TypeDef)SHALLOW_BUILDER.apply((Object)item);
            TypeDef fluent = (TypeDef)FLUENT_IMPL.apply((Object)item);
            ArrayList<Object> parameters = new ArrayList<Object>();
            for (TypeParamDef param : item.getParameters()) {
                parameters.add(param.toReference());
            }
            parameters.add(builder.toInternalReference());
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(item).withKind(Kind.CLASS)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(item.getName() + "Builder")).withParameters(item.getParameters())).withInnerTypes(new TypeDef[0])).withExtendsList(new ClassRef[]{fluent.toReference(parameters)})).withImplementsList(new ClassRef[]{BuilderContextManager.getContext().getVisitableBuilderInterface().toReference(new TypeRef[]{item.toInternalReference(), builder.toInternalReference()})})).build();
        }
    };
    public static final Function<TypeDef, TypeDef> EDITABLE = new Function<TypeDef, TypeDef>(){

        public TypeDef apply(TypeDef item) {
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            for (TypeParamDef generic : item.getParameters()) {
                parameters.add(generic);
            }
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(item).withKind(Kind.CLASS)).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName("Editable" + item.getName())).withParameters(parameters)).withExtendsList(new ClassRef[]{item.toInternalReference()})).withImplementsList(new ClassRef[]{BuilderContextManager.getContext().getEditableInterface().toReference(new TypeRef[]{((TypeDef)SHALLOW_BUILDER.apply((Object)item)).toInternalReference()})})).withInnerTypes(new TypeDef[0])).withProperties(new Property[0])).withMethods(new Method[0])).withConstructors(new Method[0])).build();
        }
    };
    public static final Function<TypeDef, TypeDef> SHALLOW_BUILDER = new Function<TypeDef, TypeDef>(){

        public TypeDef apply(TypeDef item) {
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(item).withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(item.getName() + "Builder")).withInnerTypes(new TypeDef[0])).build();
        }
    };
    public static final Function<TypeRef, ClassRef> VISITABLE_BUILDER = new Function<TypeRef, ClassRef>(){

        public ClassRef apply(TypeRef item) {
            TypeRef baseType = (TypeRef)TypeAs.combine(UNWRAP_COLLECTION_OF, UNWRAP_ARRAY_OF).apply((Object)item);
            if (baseType instanceof ClassRef) {
                baseType = ((ClassRefBuilder)new ClassRefBuilder((ClassRef)baseType).withArguments(new TypeRef[0])).build();
            }
            EditableWildcardRef wildcardRef = ((WildcardRefBuilder)new WildcardRefBuilder().addToBounds(new TypeRef[]{baseType})).build();
            return BuilderContextManager.getContext().getVisitableBuilderInterface().toReference(new TypeRef[]{wildcardRef, Constants.Q});
        }
    };
    public static final Function<TypeRef, TypeRef> LIST_OF = FunctionFactory.cache((Function)new Function<TypeRef, TypeRef>(){

        public TypeRef apply(TypeRef item) {
            return Collections.LIST.toReference(new TypeRef[]{item});
        }
    });
    public static final Function<TypeRef, TypeRef> ARRAY_AS_LIST = FunctionFactory.cache((Function)new Function<TypeRef, TypeRef>(){

        public TypeRef apply(TypeRef item) {
            return (TypeRef)LIST_OF.apply(UNWRAP_ARRAY_OF.apply((Object)item));
        }
    });
    public static final Function<TypeRef, TypeRef> ARRAY_LIST_OF = new Function<TypeRef, TypeRef>(){

        public TypeRef apply(TypeRef item) {
            return Collections.ARRAY_LIST.toReference(new TypeRef[]{item});
        }
    };
    public static final Function<TypeRef, TypeRef> UNWRAP_COLLECTION_OF = new Function<TypeRef, TypeRef>(){

        public TypeRef apply(TypeRef type) {
            ClassRef classRef;
            if (type instanceof ClassRef && ((Boolean)Collections.IS_COLLECTION.apply((Object)(classRef = (ClassRef)type))).booleanValue()) {
                return (TypeRef)classRef.getArguments().get(0);
            }
            return type;
        }
    };
    public static final Function<TypeRef, TypeRef> UNWRAP_ARRAY_OF = new Function<TypeRef, TypeRef>(){

        public TypeRef apply(TypeRef item) {
            if (item instanceof PrimitiveRef) {
                return ((PrimitiveRefBuilder)new PrimitiveRefBuilder((PrimitiveRef)item).withDimensions(0)).build();
            }
            if (item instanceof ClassRef) {
                return ((ClassRefBuilder)new ClassRefBuilder((ClassRef)item).withDimensions(0)).build();
            }
            if (item instanceof TypeParamRef) {
                return ((TypeParamRefBuilder)new TypeParamRefBuilder((TypeParamRef)item).withDimensions(0)).build();
            }
            return item;
        }
    };
    public static final Function<TypeRef, TypeRef> BOXED_OF = FunctionFactory.cache((Function)new Function<TypeRef, TypeRef>(){

        public TypeRef apply(TypeRef type) {
            int index = 0;
            for (TypeRef primitive : Constants.PRIMITIVE_TYPES) {
                if (primitive.equals(type)) {
                    return Constants.BOXED_PRIMITIVE_TYPES[index];
                }
                ++index;
            }
            return type;
        }
    });
    public static Function<TypeRef, TypeRef> ARRAY_OF = new Function<TypeRef, TypeRef>(){

        public TypeRef apply(TypeRef type) {
            if (type instanceof ClassRef) {
                return ((ClassRefBuilder)new ClassRefBuilder((ClassRef)type).withDimensions(1)).build();
            }
            if (type instanceof PrimitiveRef) {
                return ((PrimitiveRefBuilder)new PrimitiveRefBuilder((PrimitiveRef)type).withDimensions(1)).build();
            }
            if (type instanceof TypeParamRef) {
                return ((TypeParamRefBuilder)new TypeParamRefBuilder((TypeParamRef)type).withDimensions(1)).build();
            }
            throw new IllegalStateException("A property type should be either class, primitive or param referemce.");
        }
    };

    public static <T> Function<T, T> combine(final Function<T, T> ... functions) {
        return new Function<T, T>(){

            public T apply(T item) {
                Object result = item;
                for (Function f : functions) {
                    result = f.apply(result);
                }
                return result;
            }
        };
    }
}

