/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.testing;

import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.api.Adapters;
import io.sundr.adapter.testing.domain.ClassWithArray;
import io.sundr.adapter.testing.domain.ClassWithParam;
import io.sundr.adapter.testing.domain.ClassWithPrimitiveArray;
import io.sundr.adapter.testing.domain.ClassWithSelfRefParam;
import io.sundr.adapter.testing.domain.SimpleClass;
import io.sundr.model.ClassRef;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeRef;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractAdapterTest<T, C extends AdapterContext> {
    public abstract C getContext();

    public abstract T getInput(Class var1);

    @Test
    public void testWithSimpleClass() {
        T input = this.getInput(SimpleClass.class);
        TypeDef typeDef = Adapters.adapt(input, this.getContext());
        Assert.assertNotNull((Object)typeDef);
        Assert.assertEquals((Object)"SimpleClass", (Object)typeDef.getName());
    }

    @Test
    public void testWithArray() {
        T input = this.getInput(ClassWithArray.class);
        TypeDef typeDef = Adapters.adapt(input, this.getContext());
        Assert.assertNotNull((Object)typeDef);
        Assert.assertEquals((Object)"ClassWithArray", (Object)typeDef.getName());
        Assert.assertEquals((long)1L, (long)typeDef.getProperties().size());
        TypeRef typeRef = ((Property)typeDef.getProperties().iterator().next()).getTypeRef();
        Assert.assertTrue((boolean)(typeRef instanceof ClassRef));
        Assert.assertEquals((long)1L, (long)((ClassRef)typeRef).getDimensions());
    }

    @Test
    public void testWithPrimitiveArray() {
        T input = this.getInput(ClassWithPrimitiveArray.class);
        TypeDef typeDef = Adapters.adapt(input, this.getContext());
        Assert.assertNotNull((Object)typeDef);
        Assert.assertEquals((Object)"ClassWithPrimitiveArray", (Object)typeDef.getName());
        Assert.assertEquals((long)1L, (long)typeDef.getProperties().size());
        TypeRef typeRef = ((Property)typeDef.getProperties().iterator().next()).getTypeRef();
        Assert.assertTrue((boolean)(typeRef instanceof PrimitiveRef));
        Assert.assertEquals((long)1L, (long)((PrimitiveRef)typeRef).getDimensions());
    }

    @Test
    public void testWithParam() {
        T input = this.getInput(ClassWithParam.class);
        TypeDef typeDef = Adapters.adapt(input, this.getContext());
        Assert.assertNotNull((Object)typeDef);
        Assert.assertEquals((Object)"ClassWithParam", (Object)typeDef.getName());
        Assert.assertEquals((long)1L, (long)typeDef.getProperties().size());
        Assert.assertEquals((long)1L, (long)typeDef.getParameters().size());
        Assert.assertEquals((Object)"T", (Object)((TypeParamDef)typeDef.getParameters().get(0)).getName());
        Assert.assertEquals((long)0L, (long)((TypeParamDef)typeDef.getParameters().get(0)).getBounds().size());
    }

    @Test
    public void testWithSelfRefParam() {
        T input = this.getInput(ClassWithSelfRefParam.class);
        TypeDef typeDef = Adapters.adapt(input, this.getContext());
        Assert.assertNotNull((Object)typeDef);
        Assert.assertEquals((Object)"ClassWithSelfRefParam", (Object)typeDef.getName());
        Assert.assertEquals((long)1L, (long)typeDef.getProperties().size());
        Assert.assertEquals((long)1L, (long)typeDef.getParameters().size());
        Assert.assertEquals((Object)"T", (Object)((TypeParamDef)typeDef.getParameters().get(0)).getName());
        Assert.assertEquals((long)1L, (long)((TypeParamDef)typeDef.getParameters().get(0)).getBounds().size());
        Assert.assertEquals((long)1L, (long)((ClassRef)((TypeParamDef)typeDef.getParameters().get(0)).getBounds().get(0)).getArguments().size());
    }
}

