/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.st4;

import io.sundr.SundrException;
import io.sundr.codegen.template.TemplateRenderer;
import io.sundr.deps.org.stringtemplate.v4.ST;
import io.sundr.utils.Strings;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;

public class StringTemplateRenderer<T>
extends TemplateRenderer<T> {
    private static final String TEMPLATE = "template";
    private static final String MODEL = "model";
    private static final String PARAMETERS = "parameters";
    private final String templateContent;
    private final String[] parameters;

    public StringTemplateRenderer(String templateContent, String ... parameters) {
        this.templateContent = templateContent;
        this.parameters = parameters;
    }

    public static Optional<StringTemplateRenderer<?>> fromTemplate(String templateContent, String ... parameters) {
        return Optional.of(new StringTemplateRenderer(templateContent, parameters));
    }

    public static Optional<StringTemplateRenderer<?>> fromTemplateUrl(URL templateUrl, String ... parameters) {
        try {
            if (templateUrl == null) {
                return Optional.empty();
            }
            return StringTemplateRenderer.fromTemplate(Strings.loadResource((URL)templateUrl), parameters);
        }
        catch (IOException e) {
            throw SundrException.launderThrowable((Throwable)e);
        }
    }

    public static Optional<StringTemplateRenderer<?>> fromTemplateResource(String templateResource, String ... parameters) {
        return StringTemplateRenderer.fromTemplateUrl(StringTemplateRenderer.class.getResource(templateResource), parameters);
    }

    public Class<T> getType() {
        return Class.class;
    }

    public Function<T, String> getFunction() {
        return item -> {
            ST st = new ST(this.templateContent, '$', '$');
            System.out.println("MODEL:" + item);
            st.add(MODEL, item);
            st.add(PARAMETERS, (Object)this.parameters);
            return st.render();
        };
    }
}

