/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.coverters;

import io.sundr.Function;
import io.sundr.codegen.model.JavaKind;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class JavaTypeFunction
implements Function<String, JavaType> {
    private final Elements elements;
    private final boolean deep;
    private final JavaTypeFunction shallow;

    public JavaTypeFunction(Elements elements, boolean deep) {
        this.elements = elements;
        this.deep = deep;
        this.shallow = deep ? new JavaTypeFunction(elements, false) : this;
    }

    public JavaType apply(String fullName) {
        boolean isArray = false;
        String packageName = null;
        String className = null;
        ArrayList<JavaType> interfaces = new ArrayList<JavaType>();
        ArrayList<JavaType> genericTypes = new ArrayList<JavaType>();
        TypeElement typeElement = this.elements.getTypeElement(ModelUtils.getFullyQualifiedName(fullName));
        if (typeElement == null) {
            className = fullName;
        } else {
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                if (!this.deep) continue;
                interfaces.add(this.shallow.apply(typeMirror.toString()));
            }
            packageName = this.elements.getPackageOf(typeElement).toString();
            String string = className = fullName.contains(packageName) ? fullName.substring(packageName.length() + 1) : fullName;
        }
        if (fullName.endsWith("[]")) {
            className = className.substring(0, className.indexOf(91));
            isArray = true;
        }
        if (className.contains("<")) {
            String genericTypeList = fullName.substring(fullName.indexOf(60) + 1, fullName.lastIndexOf(62));
            for (String genericType : ModelUtils.splitTypes(genericTypeList)) {
                JavaType t = this.apply(genericType);
                genericTypes.add(t);
            }
            className = className.substring(0, className.indexOf(60));
        }
        JavaType defaultImplementation = null;
        String string = packageName + "." + className;
        boolean collection = false;
        if (string.equals(Set.class.getCanonicalName())) {
            defaultImplementation = this.apply(LinkedHashSet.class.getCanonicalName());
            collection = true;
        } else if (string.equals(List.class.getCanonicalName())) {
            defaultImplementation = this.apply(ArrayList.class.getCanonicalName());
            collection = true;
        } else if (string.equals(Map.class.getCanonicalName())) {
            defaultImplementation = this.apply(HashMap.class.getCanonicalName());
            collection = true;
        }
        JavaType type = ((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder().withKind(JavaKind.CLASS)).withPackageName(packageName)).withClassName(className)).withArray(isArray)).withConcrete(defaultImplementation == null)).withCollection(collection)).withDefaultImplementation(defaultImplementation)).withGenericTypes(genericTypes.toArray(new JavaType[genericTypes.size()]))).build();
        return type;
    }
}

