/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.directives;

import io.sundr.Function;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.utils.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.Node;

public class MethodDirective
extends Directive {
    public String getName() {
        return "method";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        String block = "";
        JavaMethod method = null;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) == null) continue;
            if (!(node.jjtGetChild(i) instanceof ASTBlock)) {
                if (i != 0) break;
                method = (JavaMethod)node.jjtGetChild(i).value(context);
                continue;
            }
            StringWriter blockContent = new StringWriter();
            node.jjtGetChild(i).render(context, (Writer)blockContent);
            block = blockContent.toString();
            break;
        }
        this.writeMethod(writer, method, block);
        return true;
    }

    private void writeMethod(Writer writer, JavaMethod method, String block) throws IOException {
        if (method != null) {
            writer.append("public ").append(method.getReturnType().getSimpleName()).append(" ").append(method.getName()).append("(").append(StringUtils.join(method.getArguments(), JavaPropertyToString.INSTANCE, ", ")).append(")");
            this.writeExceptions(writer, method);
            writer.append("{\n");
            writer.append(block).append("}\n");
        }
    }

    private void writeExceptions(Writer writer, JavaMethod method) throws IOException {
        if (method.getExceptions().size() > 0) {
            writer.append(" throws ").append(StringUtils.join(method.getExceptions(), ""));
        }
    }

    private static enum JavaPropertyToString implements Function<JavaProperty, String>
    {
        INSTANCE;


        public String apply(JavaProperty item) {
            StringBuilder sb = new StringBuilder();
            sb.append(item.getType().getSimpleName()).append(" ").append(item.getName());
            return sb.toString();
        }
    }
}

