/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.model;

import io.sundr.codegen.Type;
import io.sundr.codegen.model.AttributeSupport;
import io.sundr.codegen.model.JavaKind;
import java.util.Map;
import java.util.Set;

public class JavaType
extends AttributeSupport
implements Type {
    private static final String IS_ARRAY = "IS_ARRAY";
    private static final String IS_COLLECTION = "IS_COLLECTION";
    private static final String IS_CONCRETE = "IS_CONCRETE";
    private static final String DEFAULT_IMPLEMENTATION = "DEFAULT_IMPLEMENTATION";
    private final JavaKind kind;
    private final String packageName;
    private final String className;
    private final boolean array;
    private final boolean collection;
    private final boolean concrete;
    private final JavaType defaultImplementation;
    private final JavaType superClass;
    private final Set<JavaType> interfaces;
    private final JavaType[] genericTypes;

    public JavaType(JavaKind kind, String packageName, String className, boolean array, boolean collection, boolean concrete, JavaType defaultImplementation, JavaType superClass, Set<JavaType> interfaces, JavaType[] genericTypes, Map<String, Object> attributes) {
        super(attributes);
        this.kind = kind;
        this.packageName = packageName;
        this.className = className;
        this.array = array;
        this.collection = collection;
        this.concrete = concrete;
        this.defaultImplementation = defaultImplementation;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.genericTypes = genericTypes;
    }

    public String getFullyQualifiedName() {
        if (this.packageName != null && !this.packageName.isEmpty()) {
            return this.getPackageName() + "." + this.getClassName();
        }
        return this.getClassName();
    }

    public String getSimpleName() {
        return this.getSimpleName("");
    }

    public String getSimpleName(String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.className);
        sb.append(suffix);
        if (this.genericTypes.length > 0) {
            sb.append("<");
            for (int i = 0; i < this.genericTypes.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.genericTypes[i].getSimpleName());
            }
            sb.append(">");
        }
        if (this.isArray()) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public boolean isBoolean() {
        return "boolean".equals(this.className) || "Boolean".equals(this.className);
    }

    public JavaKind getKind() {
        return this.kind;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public JavaType getDefaultImplementation() {
        return this.defaultImplementation;
    }

    public JavaType getSuperClass() {
        return this.superClass;
    }

    public Set<JavaType> getInterfaces() {
        return this.interfaces;
    }

    public JavaType[] getGenericTypes() {
        return this.genericTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaType javaType = (JavaType)o;
        if (this.className != null ? !this.className.equals(javaType.className) : javaType.className != null) {
            return false;
        }
        return !(this.packageName != null ? !this.packageName.equals(javaType.packageName) : javaType.packageName != null);
    }

    public boolean isAssignable(JavaType o) {
        if (this == o || this.equals(o)) {
            return true;
        }
        if (this.packageName == null && "java.lang".equals(o.packageName) && this.className.toLowerCase().equals(o.className.toLowerCase())) {
            return true;
        }
        return o.packageName == null && "java.lang".equals(this.packageName) && this.className.toLowerCase().equals(o.className.toLowerCase());
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.className;
    }
}

