/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.utils;

import io.sundr.Function;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String captializeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String singularize(String str) {
        if (str.endsWith("ies")) {
            return str.substring(0, str.length() - 3) + "y";
        }
        if (str.endsWith("s") && str.length() > 1) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static <T> String join(Iterable<T> items, String delimiter) {
        return StringUtils.join(items, new ToString(), delimiter);
    }

    public static <T> String join(Iterable<T> items, Function<T, String> function, String delimiter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T item : items) {
            if (!first) {
                sb.append(delimiter);
            }
            sb.append((String)function.apply(item));
            first = false;
        }
        return sb.toString();
    }

    public static <T> String join(T[] items, String delimiter) {
        return StringUtils.join(items, new ToString(), delimiter);
    }

    public static <T> String join(T[] items, Function<T, String> function, String delimiter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T item : items) {
            if (!first) {
                sb.append(delimiter);
            }
            sb.append((String)function.apply(item));
            first = false;
        }
        return sb.toString();
    }

    public static final class ToString<X>
    implements Function<X, String> {
        public String apply(X item) {
            return String.valueOf(item);
        }
    }
}

