/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.generator;

import io.sundr.codegen.directives.ClassDirective;
import io.sundr.codegen.directives.FieldDirective;
import io.sundr.codegen.directives.MethodDirective;
import io.sundr.codegen.generator.GeneratorUtils;
import io.sundr.codegen.utils.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator<M> {
    private final VelocityContext context;
    private final Writer writer;
    private final M model;
    private final String templateResource;
    private final URL templateUrl;
    private final Template template;
    private final Set<Class<? extends Directive>> directives;

    public CodeGenerator(M model, Writer writer, URL templateUrl, String templateResource, Set<Class<? extends Directive>> directives) {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"string");
        engine.setProperty("string.resource.loader.class", (Object)StringResourceLoader.class.getName());
        engine.init();
        StringResourceRepository repo = StringResourceLoader.getRepository();
        try {
            repo.putStringResource("template", templateUrl != null ? StringUtils.loadResource(templateUrl) : StringUtils.loadResource(templateResource));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read template.", e);
        }
        engine.loadDirective(ClassDirective.class.getCanonicalName());
        engine.loadDirective(MethodDirective.class.getCanonicalName());
        engine.loadDirective(FieldDirective.class.getCanonicalName());
        for (Class<? extends Directive> directive : directives) {
            engine.loadDirective(directive.getCanonicalName());
        }
        this.model = model;
        this.writer = writer;
        this.templateResource = templateResource;
        this.templateUrl = templateUrl;
        this.context = new VelocityContext();
        this.directives = directives;
        this.template = engine.getTemplate("template");
        this.context.put("model", model);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public M getModel() {
        return this.model;
    }

    public String getTemplateResource() {
        return this.templateResource;
    }

    public URL getTemplateUrl() {
        return this.templateUrl;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Set<Class<? extends Directive>> getDirectives() {
        return this.directives;
    }

    public void generate() throws IOException {
        GeneratorUtils.generate(this.context, this.writer, this.getTemplate());
    }
}

