/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen;

import io.sundr.codegen.model.AttributeKey;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefinitionRepository {
    private static DefinitionRepository INSTANCE;
    private final ConcurrentMap<String, TypeDef> definitions = new ConcurrentHashMap<String, TypeDef>();
    private final ConcurrentMap<String, String> custom = new ConcurrentHashMap<String, String>();
    private Map<String, String> snapshot;

    private DefinitionRepository() {
    }

    public static final synchronized DefinitionRepository getRepository() {
        if (INSTANCE == null) {
            INSTANCE = new DefinitionRepository();
        }
        return INSTANCE;
    }

    public TypeDef registerIfAbsent(TypeDef definition) {
        if (definition != null) {
            this.definitions.putIfAbsent(definition.getFullyQualifiedName(), definition);
        }
        return definition;
    }

    public TypeDef register(TypeDef definition) {
        this.definitions.put(definition.getFullyQualifiedName(), definition);
        return definition;
    }

    public TypeDef register(TypeDef definition, String ... flags) {
        TypeDefBuilder builder = new TypeDefBuilder(definition);
        for (String flag : flags) {
            builder.addToAttributes(new AttributeKey(flag, Boolean.class), true);
        }
        return this.register(builder.build());
    }

    public TypeDef register(TypeDef definition, AttributeKey<Boolean> ... flags) {
        TypeDefBuilder builder = new TypeDefBuilder(definition);
        for (AttributeKey<Boolean> flag : flags) {
            builder.addToAttributes(flag, true);
        }
        return this.register(builder.build());
    }

    public Set<TypeDef> getDefinitions(String ... flags) {
        LinkedHashSet<TypeDef> result = new LinkedHashSet<TypeDef>();
        for (TypeDef candidate : this.definitions.values()) {
            boolean matches = true;
            for (String flag : flags) {
                AttributeKey attributeKey = new AttributeKey(flag, Boolean.class);
                if (candidate.hasAttribute(attributeKey) && ((Boolean)candidate.getAttribute(attributeKey)).booleanValue()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<TypeDef> getDefinitions(AttributeKey<Boolean> ... attributeKeys) {
        LinkedHashSet<TypeDef> result = new LinkedHashSet<TypeDef>();
        for (TypeDef candidate : this.definitions.values()) {
            boolean matches = true;
            for (AttributeKey<Boolean> attributeKey : attributeKeys) {
                if (candidate.hasAttribute(attributeKey) && candidate.getAttribute(attributeKey).booleanValue()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableSet(result);
    }

    public TypeDef getDefinition(String fullyQualifiedName) {
        return (TypeDef)this.definitions.get(fullyQualifiedName);
    }

    public TypeDef getDefinition(TypeRef type) {
        if (type instanceof ClassRef) {
            return (TypeDef)this.definitions.get(((ClassRef)type).getFullyQualifiedName());
        }
        return null;
    }

    public Collection<TypeDef> getDefinitions() {
        return this.definitions.values();
    }

    public void updateReferenceMap() {
        this.snapshot = this.getReferenceMapInternal();
    }

    public Map<String, String> getReferenceMap() {
        if (this.snapshot == null) {
            this.snapshot = this.getReferenceMapInternal();
        }
        return this.snapshot;
    }

    private Map<String, String> getReferenceMapInternal() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        ArrayList<ClassRef> refs = new ArrayList<ClassRef>();
        for (TypeDef typeDef : this.getDefinitions()) {
            refs.add(typeDef.toInternalReference());
        }
        Collections.sort(refs, new Comparator<ClassRef>(){

            @Override
            public int compare(ClassRef o1, ClassRef o2) {
                return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
            }
        });
        for (ClassRef classRef : refs) {
            String key = classRef.getDefinition().getName();
            if (mapping.containsKey(key)) continue;
            mapping.put(key, classRef.getDefinition().getFullyQualifiedName());
        }
        mapping.putAll(this.custom);
        return mapping;
    }

    public String putCustomMapping(String name, String fqn) {
        return this.custom.put(name, fqn);
    }

    public String removeCustomMapping(String name) {
        return (String)this.custom.remove(name);
    }

    public boolean customMappingExists(String name) {
        return this.custom.containsKey(name);
    }

    public void clear() {
        this.definitions.clear();
    }
}

