/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.functions;

import io.sundr.Function;
import io.sundr.FunctionFactory;
import io.sundr.codegen.DefinitionRepository;
import io.sundr.codegen.model.AnnotationRef;
import io.sundr.codegen.model.AnnotationRefBuilder;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.Kind;
import io.sundr.codegen.model.Method;
import io.sundr.codegen.model.MethodBuilder;
import io.sundr.codegen.model.PrimitiveRefBuilder;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeParamDefBuilder;
import io.sundr.codegen.model.TypeParamRefBuilder;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.model.VoidRefBuilder;
import io.sundr.codegen.model.WildcardRefBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ClassTo {
    private static final String ARGUMENT_PREFIX = "arg";
    public static final Function<Class, Kind> KIND = FunctionFactory.cache((Function)new Function<Class, Kind>(){

        public Kind apply(Class item) {
            if (item.isAnnotation()) {
                return Kind.ANNOTATION;
            }
            if (item.isEnum()) {
                return Kind.ENUM;
            }
            if (item.isInterface()) {
                return Kind.INTERFACE;
            }
            return Kind.CLASS;
        }
    });
    public static final Function<Type, TypeRef> TYPEREF = FunctionFactory.cache((Function)new Function<Type, TypeRef>(){

        public TypeRef apply(Type item) {
            if (item == null) {
                return new VoidRefBuilder().build();
            }
            if (item instanceof WildcardType) {
                return new WildcardRefBuilder().build();
            }
            if (item instanceof TypeVariable) {
                return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(((TypeVariable)item).getName())).build();
            }
            if (item instanceof GenericArrayType) {
                Type target = item;
                int dimensions = 0;
                while (target instanceof GenericArrayType) {
                    target = ((GenericArrayType)target).getGenericComponentType();
                    ++dimensions;
                }
                TypeRef targetRef = (TypeRef)TYPEREF.apply((Object)target);
                return targetRef.withDimensions(dimensions + targetRef.getDimensions());
            }
            if (item instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)item;
                Type rawType = parameterizedType.getRawType();
                ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
                for (Type arg : parameterizedType.getActualTypeArguments()) {
                    arguments.add((TypeRef)TYPEREF.apply((Object)arg));
                }
                return ((ClassRefBuilder)new ClassRefBuilder((ClassRef)TYPEREF.apply((Object)rawType)).withArguments(arguments)).build();
            }
            if (Object.class.equals((Object)item)) {
                return ClassRef.OBJECT;
            }
            if (item instanceof Class) {
                Class c = (Class)item;
                if (c.isPrimitive()) {
                    return ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName(c.getName())).build();
                }
                return ((ClassRefBuilder)new ClassRefBuilder().withDefinition((TypeDef)TYPEDEF.apply((Object)c))).build();
            }
            throw new IllegalArgumentException("Can't convert type:" + item + " to a TypeRef");
        }
    });
    public static final Function<Class<? extends Annotation>, AnnotationRef> ANNOTATIONTYPEREF = FunctionFactory.cache((Function)new Function<Class<? extends Annotation>, AnnotationRef>(){

        public AnnotationRef apply(Class<? extends Annotation> item) {
            ClassRef classRef = (ClassRef)TYPEREF.apply(item);
            return ((AnnotationRefBuilder)new AnnotationRefBuilder().withClassRef(classRef)).build();
        }
    });
    private static final Function<Class, TypeDef> INTERNAL_TYPEDEF = new Function<Class, TypeDef>(){

        public TypeDef apply(Class item) {
            if (Object.class.equals((Object)item)) {
                return TypeDef.OBJECT;
            }
            Kind kind = (Kind)((Object)KIND.apply((Object)item));
            ArrayList<ClassRef> extendsList = new ArrayList<ClassRef>();
            ArrayList<ClassRef> implementsList = new ArrayList<ClassRef>();
            ArrayList<Property> properties = new ArrayList<Property>();
            ArrayList<Method> methods = new ArrayList<Method>();
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            if (item.getSuperclass() != null && kind == Kind.INTERFACE) {
                extendsList.add((ClassRef)TYPEREF.apply(item.getSuperclass()));
            }
            methods.addAll(ClassTo.getMethods(item));
            properties.addAll(ClassTo.getProperties(item));
            for (Class<?> clazz : item.getInterfaces()) {
                TypeRef ref = (TypeRef)TYPEREF.apply(clazz);
                if (!(ref instanceof ClassRef)) continue;
                implementsList.add((ClassRef)ref);
            }
            for (Type type : item.getTypeParameters()) {
                ArrayList<ClassRef> bounds = new ArrayList<ClassRef>();
                for (Type boundType : type.getBounds()) {
                    TypeRef typeRef = (TypeRef)TYPEREF.apply((Object)boundType);
                    if (!(typeRef instanceof ClassRef)) continue;
                    bounds.add((ClassRef)typeRef);
                }
                parameters.add(((TypeParamDefBuilder)((TypeParamDefBuilder)new TypeParamDefBuilder().withName(type.getName())).withBounds(bounds)).build());
            }
            return DefinitionRepository.getRepository().register(((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withName(item.getSimpleName())).withPackageName(item.getPackage() != null ? item.getPackage().getName() : null)).withModifiers(item.getModifiers())).withParameters(parameters)).withMethods(methods)).withProperties(properties)).withExtendsList(extendsList)).withImplementsList(implementsList)).build());
        }
    };
    private static final Function<Class, TypeDef> INTERNAL_SHALLOW_TYPEDEF = new Function<Class, TypeDef>(){

        public TypeDef apply(Class item) {
            if (Object.class.equals((Object)item)) {
                return TypeDef.OBJECT;
            }
            Kind kind = (Kind)((Object)KIND.apply((Object)item));
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withName(item.getSimpleName())).withPackageName(item.getPackage() != null ? item.getPackage().getName() : null)).withModifiers(item.getModifiers())).withParameters(new TypeParamDef[0])).build();
        }
    };
    public static final Function<Class, TypeDef> TYPEDEF = FunctionFactory.cache(INTERNAL_TYPEDEF).withFallback(INTERNAL_SHALLOW_TYPEDEF).withMaximumRecursionLevel(5).withMaximumNestingDepth(5);
    private static Function<Type, TypeParamDef> TYPEPARAMDEF = FunctionFactory.cache((Function)new Function<Type, TypeParamDef>(){

        public TypeParamDef apply(Type item) {
            if (item instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)item;
                String name = typeVariable.getName();
                ArrayList<ClassRef> bounds = new ArrayList<ClassRef>();
                for (Type b : typeVariable.getBounds()) {
                    if (!(b instanceof Class)) continue;
                    Class c = (Class)b;
                    bounds.add((ClassRef)TYPEREF.apply((Object)c));
                }
                return ((TypeParamDefBuilder)((TypeParamDefBuilder)new TypeParamDefBuilder().withName(name)).withBounds(bounds)).build();
            }
            return null;
        }
    });

    private static Set<Property> getProperties(Class item) {
        HashSet<Property> properties = new HashSet<Property>();
        for (Field field : item.getDeclaredFields()) {
            ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                annotationRefs.add((AnnotationRef)ANNOTATIONTYPEREF.apply(annotation.annotationType()));
            }
            field.getDeclaringClass();
            properties.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(field.getName())).withModifiers(field.getModifiers())).withAnnotations(annotationRefs)).withTypeRef((TypeRef)TYPEREF.apply(field.getDeclaringClass()))).build());
        }
        return properties;
    }

    private static Set<Method> getMethods(Class item) {
        HashSet<Method> methods = new HashSet<Method>();
        for (java.lang.reflect.Method method : item.getDeclaredMethods()) {
            ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                annotationRefs.add((AnnotationRef)ANNOTATIONTYPEREF.apply(annotation.annotationType()));
            }
            ArrayList<Property> arguments = new ArrayList<Property>();
            for (int i = 1; i <= method.getGenericParameterTypes().length; ++i) {
                Type argumentType = method.getGenericParameterTypes()[i - 1];
                arguments.add(((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(ARGUMENT_PREFIX + i)).withTypeRef((TypeRef)TYPEREF.apply((Object)argumentType))).build());
            }
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            for (Type type : method.getGenericParameterTypes()) {
                TypeParamDef typeParamDef = (TypeParamDef)TYPEPARAMDEF.apply((Object)type);
                if (typeParamDef == null) continue;
                parameters.add(typeParamDef);
            }
            methods.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(method.getName())).withModifiers(method.getModifiers())).withReturnType((TypeRef)TYPEREF.apply(method.getReturnType()))).withArguments(arguments)).withParameters(parameters)).withAnnotations(annotationRefs)).build());
        }
        return methods;
    }
}

