/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.functions;

import io.sundr.Function;
import io.sundr.FunctionFactory;
import io.sundr.codegen.functions.ClassTo;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Collections {
    public static final TypeDef COLLECTION = (TypeDef)ClassTo.TYPEDEF.apply(Collection.class);
    public static final TypeDef MAP = (TypeDef)ClassTo.TYPEDEF.apply(Map.class);
    public static final TypeDef LINKED_HASH_MAP = (TypeDef)ClassTo.TYPEDEF.apply(LinkedHashMap.class);
    public static final TypeDef LIST = (TypeDef)ClassTo.TYPEDEF.apply(List.class);
    public static final TypeDef ARRAY_LIST = (TypeDef)ClassTo.TYPEDEF.apply(ArrayList.class);
    public static final TypeDef SET = (TypeDef)ClassTo.TYPEDEF.apply(Set.class);
    public static final TypeDef LINKED_HASH_SET = (TypeDef)ClassTo.TYPEDEF.apply(LinkedHashSet.class);
    public static final Function<TypeRef, Boolean> IS_LIST = FunctionFactory.cache((Function)new Function<TypeRef, Boolean>(){

        public Boolean apply(TypeRef type) {
            return TypeUtils.isInstanceOf(type, LIST, IS_LIST);
        }
    });
    public static final Function<TypeRef, Boolean> IS_SET = FunctionFactory.cache((Function)new Function<TypeRef, Boolean>(){

        public Boolean apply(TypeRef type) {
            return TypeUtils.isInstanceOf(type, SET, IS_SET);
        }
    });
    public static final Function<TypeRef, Boolean> IS_MAP = FunctionFactory.cache((Function)new Function<TypeRef, Boolean>(){

        public Boolean apply(TypeRef type) {
            return TypeUtils.isInstanceOf(type, MAP, IS_MAP);
        }
    });
    public static final Function<TypeRef, Boolean> IS_COLLECTION = FunctionFactory.cache((Function)new Function<TypeRef, Boolean>(){

        public Boolean apply(TypeRef type) {
            return (Boolean)IS_LIST.apply((Object)type) != false || (Boolean)IS_SET.apply((Object)type) != false;
        }
    });
}

