/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.model;

import io.sundr.codegen.model.AnnotationRef;
import io.sundr.codegen.model.AttributeKey;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.Kind;
import io.sundr.codegen.model.Method;
import io.sundr.codegen.model.MethodBuilder;
import io.sundr.codegen.model.ModifierSupport;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.model.WildcardRef;
import io.sundr.codegen.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeDef
extends ModifierSupport {
    public static TypeDef OBJECT = ((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withPackageName("java.lang")).withName("Object")).build();
    public static ClassRef OBJECT_REF = OBJECT.toReference(new TypeRef[0]);
    private final Kind kind;
    private final String packageName;
    private final String name;
    private final List<AnnotationRef> annotations;
    private final List<ClassRef> extendsList;
    private final List<ClassRef> implementsList;
    private final List<TypeParamDef> parameters;
    private final List<Property> properties;
    private final List<Method> constructors;
    private final List<Method> methods;
    private final TypeDef outerType;
    private final List<TypeDef> innerTypes;

    public TypeDef(Kind kind, String packageName, String name, List<AnnotationRef> annotations, List<ClassRef> extendsList, List<ClassRef> implementsList, List<TypeParamDef> parameters, List<Property> properties, List<Method> constructors, List<Method> methods, TypeDef outerType, List<TypeDef> innerTypes, int modifiers, Map<AttributeKey, Object> attributes) {
        super(modifiers, attributes);
        this.kind = kind != null ? kind : Kind.CLASS;
        this.packageName = packageName;
        this.name = name;
        this.annotations = annotations;
        this.extendsList = extendsList;
        this.implementsList = implementsList;
        this.parameters = parameters;
        this.properties = properties;
        this.constructors = TypeDef.adaptConstructors(constructors, this);
        this.methods = methods;
        this.outerType = outerType;
        this.innerTypes = TypeDef.setOuterType(innerTypes, this);
    }

    private static List<Method> adaptConstructors(List<Method> methods, TypeDef target) {
        ArrayList<Method> adapted = new ArrayList<Method>();
        for (Method m : methods) {
            adapted.add(((MethodBuilder)((MethodBuilder)new MethodBuilder(m).withName(null)).withReturnType(target.toUnboundedReference())).build());
        }
        return adapted;
    }

    private static List<TypeDef> setOuterType(List<TypeDef> types, TypeDef outer) {
        ArrayList<TypeDef> updated = new ArrayList<TypeDef>();
        for (TypeDef typeDef : types) {
            if (outer.equals(typeDef.getOuterType())) {
                updated.add(typeDef);
                continue;
            }
            updated.add(((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(typeDef).withOuterType(outer)).withPackageName(outer.getPackageName())).build());
        }
        return updated;
    }

    public String getFullyQualifiedName() {
        StringBuilder sb = new StringBuilder();
        if (this.packageName != null && !this.packageName.isEmpty()) {
            sb.append(this.getPackageName()).append(".");
        }
        if (this.outerType != null) {
            sb.append(this.outerType.getName()).append(".");
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public boolean isAssignableFrom(TypeDef o) {
        if (this == o || this.equals(o)) {
            return true;
        }
        if (this.packageName == null && "java.lang".equals(o.packageName) && this.name.equalsIgnoreCase(o.name)) {
            return true;
        }
        if (o.packageName == null && "java.lang".equals(this.packageName) && this.name.equalsIgnoreCase(o.name)) {
            return true;
        }
        for (ClassRef e : o.getExtendsList()) {
            if (!this.isAssignableFrom(e.getDefinition())) continue;
            return true;
        }
        for (ClassRef i : o.getImplementsList()) {
            if (!this.isAssignableFrom(i.getDefinition())) continue;
            return true;
        }
        return false;
    }

    public Kind getKind() {
        return this.kind;
    }

    public List<AnnotationRef> getAnnotations() {
        return this.annotations;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public List<ClassRef> getExtendsList() {
        return this.extendsList;
    }

    public List<ClassRef> getImplementsList() {
        return this.implementsList;
    }

    public List<TypeParamDef> getParameters() {
        return this.parameters;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Method> getConstructors() {
        return this.constructors;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public TypeDef getOuterType() {
        return this.outerType;
    }

    public List<TypeDef> getInnerTypes() {
        return this.innerTypes;
    }

    public boolean isClass() {
        return this.kind == Kind.INTERFACE;
    }

    public boolean isInterface() {
        return this.kind == Kind.INTERFACE;
    }

    public boolean isEnum() {
        return this.kind == Kind.ENUM;
    }

    public boolean isAnnotation() {
        return this.kind == Kind.ANNOTATION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDef typeDef = (TypeDef)o;
        if (this.packageName != null ? !this.packageName.equals(typeDef.packageName) : typeDef.packageName != null) {
            return false;
        }
        return this.name != null ? this.name.equals(typeDef.name) : typeDef.name == null;
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public ClassRef toReference(TypeRef ... arguments) {
        ArrayList<TypeRef> actualArguments = new ArrayList<TypeRef>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i < arguments.length) {
                actualArguments.add(arguments[i]);
                continue;
            }
            actualArguments.add(new WildcardRef());
        }
        return ((ClassRefBuilder)((ClassRefBuilder)((ClassRefBuilder)new ClassRefBuilder().withDefinition(this)).withArguments(actualArguments)).withAttributes(this.getAttributes())).build();
    }

    public ClassRef toReference(List<TypeRef> arguments) {
        ArrayList<TypeRef> actualArguments = new ArrayList<TypeRef>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i < arguments.size()) {
                actualArguments.add(arguments.get(i));
                continue;
            }
            actualArguments.add(new WildcardRef());
        }
        return ((ClassRefBuilder)((ClassRefBuilder)((ClassRefBuilder)new ClassRefBuilder().withDefinition(this)).withArguments(actualArguments)).withAttributes(this.getAttributes())).build();
    }

    public ClassRef toReference(Collection<TypeRef> arguments) {
        return this.toReference(arguments);
    }

    public ClassRef toInternalReference() {
        ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
        for (TypeParamDef parameter : this.parameters) {
            arguments.add(parameter.toReference());
        }
        return ((ClassRefBuilder)((ClassRefBuilder)((ClassRefBuilder)new ClassRefBuilder().withDefinition(this)).withArguments(arguments)).withAttributes(this.getAttributes())).build();
    }

    public ClassRef toUnboundedReference() {
        return ((ClassRefBuilder)((ClassRefBuilder)new ClassRefBuilder().withDefinition(this)).withArguments(new TypeRef[0])).build();
    }

    public Set<String> getImports() {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        for (ClassRef ref : this.getReferenceMap().values()) {
            TypeDef definition = ref.getDefinition();
            if (definition.getPackageName() == null || definition.getPackageName().isEmpty() || definition.getPackageName().equals(this.packageName) || definition.getName().equals(this.name)) continue;
            imports.add(ref.getDefinition().getFullyQualifiedName());
        }
        return imports;
    }

    private Map<String, ClassRef> getReferenceMap() {
        HashMap<String, ClassRef> mapping = new HashMap<String, ClassRef>();
        List<ClassRef> refs = this.getReferences();
        Collections.sort(refs, new Comparator<ClassRef>(){

            @Override
            public int compare(ClassRef o1, ClassRef o2) {
                return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
            }
        });
        for (ClassRef ref : refs) {
            String key = ref.getDefinition().getName();
            if (mapping.containsKey(key)) continue;
            mapping.put(key, ref);
        }
        return mapping;
    }

    public List<ClassRef> getReferences() {
        ArrayList<ClassRef> refs = new ArrayList<ClassRef>();
        for (AnnotationRef a : this.annotations) {
            refs.addAll(a.getClassRef().getReferences());
        }
        for (ClassRef i : this.implementsList) {
            refs.addAll(i.getReferences());
        }
        for (ClassRef e : this.extendsList) {
            refs.addAll(e.getReferences());
        }
        for (Property property : this.properties) {
            refs.addAll(property.getReferences());
        }
        for (Method method : this.constructors) {
            refs.addAll(method.getReferences());
        }
        for (Method method : this.methods) {
            refs.addAll(method.getReferences());
        }
        for (TypeParamDef typeParamDef : this.parameters) {
            for (ClassRef bound : typeParamDef.getBounds()) {
                refs.addAll(bound.getReferences());
            }
        }
        for (TypeDef innerType : this.innerTypes) {
            refs.addAll(innerType.getReferences());
        }
        if (this.getAttributes().containsKey(ALSO_IMPORT)) {
            Object obj = this.getAttributes().get(ALSO_IMPORT);
            if (obj instanceof ClassRef) {
                refs.add((ClassRef)obj);
            } else if (obj instanceof Collection) {
                refs.addAll((Collection)obj);
            }
        }
        return refs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AnnotationRef annotationRef : this.annotations) {
            sb.append(annotationRef.toString()).append(" ");
        }
        if (this.isPublic()) {
            sb.append("public").append(" ");
        } else if (this.isProtected()) {
            sb.append("protected").append(" ");
        } else if (this.isPrivate()) {
            sb.append("private").append(" ");
        }
        if (this.isStatic()) {
            sb.append("static").append(" ");
        }
        if (this.isAbstract()) {
            sb.append("abstract").append(" ");
        }
        if (this.isFinal()) {
            sb.append("final").append(" ");
        }
        sb.append(this.kind.name().toLowerCase()).append(" ");
        sb.append(this.name);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("<");
            sb.append(StringUtils.join(this.parameters, ","));
            sb.append(">");
        }
        if (!(this.extendsList == null || this.extendsList.isEmpty() || this.extendsList.size() == 1 && this.extendsList.contains(OBJECT.toReference(new TypeRef[0])))) {
            sb.append(" ").append("extends").append(" ");
            sb.append(StringUtils.join(this.extendsList, ","));
        }
        if (this.implementsList != null && !this.implementsList.isEmpty()) {
            sb.append(" ").append("implements").append(" ");
            sb.append(StringUtils.join(this.implementsList, ","));
        }
        return sb.toString();
    }
}

