/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.utils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class ModelUtils {
    public static final String NONE = "<none>";
    public static final String OBJECT = "java.lang.Object";

    private ModelUtils() {
    }

    public static TypeElement getClassElement(Element element) {
        if (element instanceof PackageElement) {
            throw new IllegalArgumentException("Invalid element. A package element can't be used to retrieve a class element");
        }
        if (element instanceof TypeElement) {
            return (TypeElement)element;
        }
        return ModelUtils.getClassElement(element.getEnclosingElement());
    }

    public static String getClassName(Element element) {
        TypeElement typeElement = ModelUtils.getClassElement(element);
        return typeElement.getSimpleName().toString();
    }

    public static PackageElement getPackageElement(Element element) {
        if (element instanceof PackageElement) {
            return (PackageElement)element;
        }
        return ModelUtils.getPackageElement(element.getEnclosingElement());
    }

    public static String getPackageName(Element element) {
        return ModelUtils.getPackageElement(element).getQualifiedName().toString();
    }

    public static List<VariableElement> getFields(TypeElement element) {
        return ElementFilter.fieldsIn(element.getEnclosedElements());
    }

    static TypeElement getElementMatching(Iterable<TypeElement> typeElements, TypeMirror type) {
        for (TypeElement typeElement : typeElements) {
            if (!typeElement.asType().equals(type)) continue;
            return typeElement;
        }
        return null;
    }

    public static List<String> splitTypes(String fullName) {
        String name = fullName;
        ArrayList<String> result = new ArrayList<String>();
        int openBrackets = 0;
        int lastIndex = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ',' && openBrackets == 0) {
                result.add(name.substring(0, i));
                lastIndex = i + 1;
                continue;
            }
            if (name.charAt(i) == '<') {
                ++openBrackets;
                continue;
            }
            if (name.charAt(i) != '>') continue;
            --openBrackets;
        }
        result.add(name.substring(lastIndex));
        return result;
    }

    public static String getFullyQualifiedName(String fullName) {
        String result = fullName.trim();
        if (result.contains("[")) {
            result = result.substring(0, result.indexOf(91));
        }
        if (result.contains("<")) {
            result = result.substring(0, result.indexOf(60));
        }
        return result;
    }

    public static <A extends Annotation> List<ExecutableElement> findMethodsAnnotatedWith(TypeElement classElement, Class<A> annotation) {
        return ModelUtils.filterByAnnotation(ElementFilter.methodsIn(classElement.getEnclosedElements()), annotation);
    }

    public static <A extends Annotation, E extends Element> List<E> filterByAnnotation(List<E> elements, Class<A> annotation) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element executableElement : elements) {
            if (executableElement.getAnnotation(annotation) == null) continue;
            result.add(executableElement);
        }
        return result;
    }
}

