package io.sundr.examples.arrays;

import io.sundr.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GameBuilder extends io.sundr.examples.arrays.GameFluentImpl<io.sundr.examples.arrays.GameBuilder> implements io.sundr.builder.VisitableBuilder<io.sundr.examples.arrays.Game,io.sundr.examples.arrays.GameBuilder> {

    io.sundr.examples.arrays.GameFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GameBuilder() {
        this(true);
    }

    public GameBuilder(java.lang.Boolean validationEnabled) {
        this.fluent = this; this.validationEnabled=validationEnabled;
    }

    public GameBuilder(io.sundr.examples.arrays.GameFluent<?> fluent) {
        this(fluent, true);
    }

    public GameBuilder(io.sundr.examples.arrays.GameFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; this.validationEnabled=validationEnabled;
    }

    public GameBuilder(io.sundr.examples.arrays.GameFluent<?> fluent,io.sundr.examples.arrays.Game instance) {
        this(fluent, instance, true);
    }

    public GameBuilder(io.sundr.examples.arrays.GameFluent<?> fluent,io.sundr.examples.arrays.Game instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPlayers(instance.getPlayers()); 
        this.validationEnabled = validationEnabled; 
    }

    public GameBuilder(io.sundr.examples.arrays.Game instance) {
        this(instance,true);
    }

    public GameBuilder(io.sundr.examples.arrays.Game instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPlayers(instance.getPlayers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.sundr.examples.arrays.EditableGame build() {
        EditableGame buildable = new EditableGame(fluent.getPlayers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GameBuilder that = (GameBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
