package io.sundr.examples.arrays;

import io.sundr.builder.VisitableBuilder;
import io.sundr.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.sundr.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class GameFluentImpl<A extends io.sundr.examples.arrays.GameFluent<A>> extends io.sundr.builder.BaseFluent<A> implements io.sundr.examples.arrays.GameFluent<A> {

    private java.util.List<io.sundr.examples.arrays.PersonBuilder> players;

    public GameFluentImpl() {
    }

    public GameFluentImpl(io.sundr.examples.arrays.Game instance) {
        this.withPlayers(instance.getPlayers()); 
    }

    public A withPlayers(io.sundr.examples.arrays.Person... players) {
        if (this.players != null) {this.players.clear();}
        if (players != null) {for (io.sundr.examples.arrays.Person item :players){ this.addToPlayers(item);}} return (A) this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPlayers instead.
     */
        public io.sundr.examples.arrays.Person[] getPlayers() {
        int size = players != null ? players.size() : 0;
        io.sundr.examples.arrays.Person[] result = new io.sundr.examples.arrays.Person[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (io.sundr.builder.VisitableBuilder<? extends io.sundr.examples.arrays.Person,?> builder : players) {
            result[index++]=builder.build();
        }
        return result;
    }

    public io.sundr.examples.arrays.Person[] buildPlayers() {
        int size = players != null ? players.size() : 0;
        io.sundr.examples.arrays.Person[] result = new io.sundr.examples.arrays.Person[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (io.sundr.builder.VisitableBuilder<? extends io.sundr.examples.arrays.Person,?> builder : players) {
            result[index++]=builder.build();
        }
        return result;
    }

    public io.sundr.examples.arrays.Person buildPlayer(int index) {
        return this.players.get(index).build();
    }

    public io.sundr.examples.arrays.Person buildFirstPlayer() {
        return this.players.get(0).build();
    }

    public io.sundr.examples.arrays.Person buildLastPlayer() {
        return this.players.get(players.size() - 1).build();
    }

    public io.sundr.examples.arrays.Person buildMatchingPlayer(java.util.function.Predicate<io.sundr.examples.arrays.PersonBuilder> predicate) {
        for (io.sundr.examples.arrays.PersonBuilder item: players) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingPlayer(java.util.function.Predicate<io.sundr.examples.arrays.PersonBuilder> predicate) {
        for (io.sundr.examples.arrays.PersonBuilder item: players) { if(predicate.test(item)){ return true;} } return false;
    }

    public A addToPlayers(int index,io.sundr.examples.arrays.Person item) {
        if (this.players == null) {this.players = new java.util.ArrayList<io.sundr.examples.arrays.PersonBuilder>();}
        io.sundr.examples.arrays.PersonBuilder builder = new io.sundr.examples.arrays.PersonBuilder(item);_visitables.get("players").add(index >= 0 ? index : _visitables.get("players").size(), builder);this.players.add(index >= 0 ? index : players.size(), builder); return (A)this;
    }

    public A setToPlayers(int index,io.sundr.examples.arrays.Person item) {
        if (this.players == null) {this.players = new java.util.ArrayList<io.sundr.examples.arrays.PersonBuilder>();}
        io.sundr.examples.arrays.PersonBuilder builder = new io.sundr.examples.arrays.PersonBuilder(item);
        if (index < 0 || index >= _visitables.get("players").size()) { _visitables.get("players").add(builder); } else { _visitables.get("players").set(index, builder);}
        if (index < 0 || index >= players.size()) { players.add(builder); } else { players.set(index, builder);}
         return (A)this;
    }

    public A addToPlayers(io.sundr.examples.arrays.Person... items) {
        if (this.players == null) {this.players = new java.util.ArrayList<io.sundr.examples.arrays.PersonBuilder>();}
        for (io.sundr.examples.arrays.Person item : items) {io.sundr.examples.arrays.PersonBuilder builder = new io.sundr.examples.arrays.PersonBuilder(item);_visitables.get("players").add(builder);this.players.add(builder);} return (A)this;
    }

    public A addAllToPlayers(java.util.Collection<io.sundr.examples.arrays.Person> items) {
        if (this.players == null) {this.players = new java.util.ArrayList<io.sundr.examples.arrays.PersonBuilder>();}
        for (io.sundr.examples.arrays.Person item : items) {io.sundr.examples.arrays.PersonBuilder builder = new io.sundr.examples.arrays.PersonBuilder(item);_visitables.get("players").add(builder);this.players.add(builder);} return (A)this;
    }

    public A removeFromPlayers(io.sundr.examples.arrays.Person... items) {
        for (io.sundr.examples.arrays.Person item : items) {io.sundr.examples.arrays.PersonBuilder builder = new io.sundr.examples.arrays.PersonBuilder(item);_visitables.get("players").remove(builder);if (this.players != null) {this.players.remove(builder);}} return (A)this;
    }

    public A removeAllFromPlayers(java.util.Collection<io.sundr.examples.arrays.Person> items) {
        for (io.sundr.examples.arrays.Person item : items) {io.sundr.examples.arrays.PersonBuilder builder = new io.sundr.examples.arrays.PersonBuilder(item);_visitables.get("players").remove(builder);if (this.players != null) {this.players.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPlayers(java.util.function.Predicate<io.sundr.examples.arrays.PersonBuilder> predicate) {
        if (players == null) return (A) this;
        final Iterator<io.sundr.examples.arrays.PersonBuilder> each = players.iterator();
        final List visitables = _visitables.get("players");
        while (each.hasNext()) {
          io.sundr.examples.arrays.PersonBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public java.lang.Boolean hasPlayers() {
        return players != null && !players.isEmpty();
    }

    public A addNewPlayer(java.lang.String firstName,java.lang.String lastName,int[] numbers) {
        return (A)addToPlayers(new Person(firstName, lastName, numbers));
    }

    public io.sundr.examples.arrays.GameFluent.PlayersNested<A> addNewPlayer() {
        return new io.sundr.examples.arrays.GameFluentImpl.PlayersNestedImpl();
    }

    public io.sundr.examples.arrays.GameFluent.PlayersNested<A> addNewPlayerLike(io.sundr.examples.arrays.Person item) {
        return new io.sundr.examples.arrays.GameFluentImpl.PlayersNestedImpl(-1, item);
    }

    public io.sundr.examples.arrays.GameFluent.PlayersNested<A> setNewPlayerLike(int index,io.sundr.examples.arrays.Person item) {
        return new io.sundr.examples.arrays.GameFluentImpl.PlayersNestedImpl(index, item);
    }

    public io.sundr.examples.arrays.GameFluent.PlayersNested<A> editPlayer(int index) {
        if (players.size() <= index) throw new RuntimeException("Can't edit players. Index exceeds size.");
        return setNewPlayerLike(index, buildPlayer(index));
    }

    public io.sundr.examples.arrays.GameFluent.PlayersNested<A> editFirstPlayer() {
        if (players.size() == 0) throw new RuntimeException("Can't edit first players. The list is empty.");
        return setNewPlayerLike(0, buildPlayer(0));
    }

    public io.sundr.examples.arrays.GameFluent.PlayersNested<A> editLastPlayer() {
        int index = players.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last players. The list is empty.");
        return setNewPlayerLike(index, buildPlayer(index));
    }

    public io.sundr.examples.arrays.GameFluent.PlayersNested<A> editMatchingPlayer(java.util.function.Predicate<io.sundr.examples.arrays.PersonBuilder> predicate) {
        int index = -1;
        for (int i=0;i<players.size();i++) { 
        if (predicate.test(players.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching players. No match found.");
        return setNewPlayerLike(index, buildPlayer(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GameFluentImpl that = (GameFluentImpl) o;
        if (players != null ? !players.equals(that.players) :that.players != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(players,  super.hashCode());
    }

    public class PlayersNestedImpl<N> extends io.sundr.examples.arrays.PersonFluentImpl<io.sundr.examples.arrays.GameFluent.PlayersNested<N>> implements io.sundr.examples.arrays.GameFluent.PlayersNested<N>,io.sundr.builder.Nested<N> {
        private final io.sundr.examples.arrays.PersonBuilder builder;
        private final int index;

            PlayersNestedImpl(int index,io.sundr.examples.arrays.Person item) {
                this.index = index;
                this.builder = new io.sundr.examples.arrays.PersonBuilder(this, item);
                        
            }

            PlayersNestedImpl() {
                this.index = -1;
                this.builder = new io.sundr.examples.arrays.PersonBuilder(this);
                        
            }

            public N and() {
                return (N) GameFluentImpl.this.setToPlayers(index,builder.build());
            }

            public N endPlayer() {
                return and();
            }
    }


}
