package io.sundr.examples.arrays;

import io.sundr.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PersonBuilder extends io.sundr.examples.arrays.PersonFluentImpl<io.sundr.examples.arrays.PersonBuilder> implements io.sundr.builder.VisitableBuilder<io.sundr.examples.arrays.Person,io.sundr.examples.arrays.PersonBuilder> {

    io.sundr.examples.arrays.PersonFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PersonBuilder() {
        this(true);
    }

    public PersonBuilder(java.lang.Boolean validationEnabled) {
        this.fluent = this; this.validationEnabled=validationEnabled;
    }

    public PersonBuilder(io.sundr.examples.arrays.PersonFluent<?> fluent) {
        this(fluent, true);
    }

    public PersonBuilder(io.sundr.examples.arrays.PersonFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; this.validationEnabled=validationEnabled;
    }

    public PersonBuilder(io.sundr.examples.arrays.PersonFluent<?> fluent,io.sundr.examples.arrays.Person instance) {
        this(fluent, instance, true);
    }

    public PersonBuilder(io.sundr.examples.arrays.PersonFluent<?> fluent,io.sundr.examples.arrays.Person instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFirstName(instance.getFirstName()); 
        fluent.withLastName(instance.getLastName()); 
        fluent.withNumbers(instance.getNumbers()); 
        this.validationEnabled = validationEnabled; 
    }

    public PersonBuilder(io.sundr.examples.arrays.Person instance) {
        this(instance,true);
    }

    public PersonBuilder(io.sundr.examples.arrays.Person instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFirstName(instance.getFirstName()); 
        this.withLastName(instance.getLastName()); 
        this.withNumbers(instance.getNumbers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.sundr.examples.arrays.EditablePerson build() {
        EditablePerson buildable = new EditablePerson(fluent.getFirstName(),fluent.getLastName(),fluent.getNumbers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PersonBuilder that = (PersonBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
