package io.sundr.examples.arrays;

import java.lang.Integer;
import java.lang.Deprecated;
import io.sundr.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;

public class PersonFluentImpl<A extends io.sundr.examples.arrays.PersonFluent<A>> extends io.sundr.builder.BaseFluent<A> implements io.sundr.examples.arrays.PersonFluent<A> {

    private java.lang.String firstName;
    private java.lang.String lastName;
    private java.util.List<java.lang.Integer> numbers;

    public PersonFluentImpl() {
    }

    public PersonFluentImpl(io.sundr.examples.arrays.Person instance) {
        this.withFirstName(instance.getFirstName()); 
        this.withLastName(instance.getLastName()); 
        this.withNumbers(instance.getNumbers()); 
    }

    public java.lang.String getFirstName() {
        return this.firstName;
    }

    public A withFirstName(java.lang.String firstName) {
        this.firstName=firstName; return (A) this;
    }

    public java.lang.Boolean hasFirstName() {
        return this.firstName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFirstName instead.
     */
        public A withNewFirstName(java.lang.String arg0) {
        return (A)withFirstName(new String(arg0));
    }

    public java.lang.String getLastName() {
        return this.lastName;
    }

    public A withLastName(java.lang.String lastName) {
        this.lastName=lastName; return (A) this;
    }

    public java.lang.Boolean hasLastName() {
        return this.lastName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLastName instead.
     */
        public A withNewLastName(java.lang.String arg0) {
        return (A)withLastName(new String(arg0));
    }

    public A withNumbers(int... numbers) {
        if (this.numbers != null) {this.numbers.clear();}
        if (numbers != null) {for (int item :numbers){ this.addToNumbers(item);}} return (A) this;
    }

    public int[] getNumbers() {
        //This needs to work with primitives, so we use arrays.
        int size = numbers != null ? numbers.size() : 0;
        int[] result = new int[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (int item : numbers) {
            result[index++]=item;
        }
        return result;
    }

    public A addToNumbers(int index,java.lang.Integer item) {
        if (this.numbers == null) {this.numbers =  new java.util.ArrayList<java.lang.Integer>();}
        this.numbers.add(index, item);
        return (A)this;
    }

    public A setToNumbers(int index,java.lang.Integer item) {
        if (this.numbers == null) {this.numbers =  new java.util.ArrayList<java.lang.Integer>();}
        this.numbers.set(index, item); return (A)this;
    }

    public A addToNumbers(java.lang.Integer... items) {
        if (this.numbers == null) {this.numbers =  new java.util.ArrayList<java.lang.Integer>();}
        for (java.lang.Integer item : items) {this.numbers.add(item);} return (A)this;
    }

    public A addAllToNumbers(java.util.Collection<java.lang.Integer> items) {
        if (this.numbers == null) {this.numbers =  new java.util.ArrayList<java.lang.Integer>();}
        for (java.lang.Integer item : items) {this.numbers.add(item);} return (A)this;
    }

    public A removeFromNumbers(java.lang.Integer... items) {
        for (java.lang.Integer item : items) {if (this.numbers!= null){ this.numbers.remove(item);}} return (A)this;
    }

    public A removeAllFromNumbers(java.util.Collection<java.lang.Integer> items) {
        for (java.lang.Integer item : items) {if (this.numbers!= null){ this.numbers.remove(item);}} return (A)this;
    }

    public java.lang.Boolean hasNumbers() {
        return numbers != null && !numbers.isEmpty();
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PersonFluentImpl that = (PersonFluentImpl) o;
        if (firstName != null ? !firstName.equals(that.firstName) :that.firstName != null) return false;
        if (lastName != null ? !lastName.equals(that.lastName) :that.lastName != null) return false;
        if (numbers != null ? !numbers.equals(that.numbers) :that.numbers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(firstName,  lastName,  numbers,  super.hashCode());
    }

}
