/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.examples.arrays;

import io.sundr.builder.VisitableBuilder;
import io.sundr.examples.arrays.EditableGame;
import io.sundr.examples.arrays.Game;
import io.sundr.examples.arrays.GameFluent;
import io.sundr.examples.arrays.GameFluentImpl;
import java.util.Objects;

public class GameBuilder
extends GameFluentImpl<GameBuilder>
implements VisitableBuilder<Game, GameBuilder> {
    GameFluent<?> fluent;
    Boolean validationEnabled;

    public GameBuilder() {
        this(true);
    }

    public GameBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public GameBuilder(GameFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GameBuilder(GameFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public GameBuilder(GameFluent<?> fluent, Game instance) {
        this(fluent, instance, true);
    }

    public GameBuilder(GameFluent<?> fluent, Game instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPlayers(instance.getPlayers());
        this.validationEnabled = validationEnabled;
    }

    public GameBuilder(Game instance) {
        this(instance, (Boolean)true);
    }

    public GameBuilder(Game instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPlayers(instance.getPlayers());
        this.validationEnabled = validationEnabled;
    }

    public EditableGame build() {
        EditableGame buildable = new EditableGame(this.fluent.getPlayers());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GameBuilder that = (GameBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

