/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.examples.arrays;

import io.sundr.builder.BaseFluent;
import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;
import io.sundr.examples.arrays.Game;
import io.sundr.examples.arrays.GameFluent;
import io.sundr.examples.arrays.Person;
import io.sundr.examples.arrays.PersonBuilder;
import io.sundr.examples.arrays.PersonFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class GameFluentImpl<A extends GameFluent<A>>
extends BaseFluent<A>
implements GameFluent<A> {
    private List<PersonBuilder> players;

    public GameFluentImpl() {
    }

    public GameFluentImpl(Game instance) {
        this.withPlayers(instance.getPlayers());
    }

    @Override
    public A withPlayers(Person ... players) {
        if (this.players != null) {
            this.players.clear();
        }
        if (players != null) {
            for (Person item : players) {
                this.addToPlayers(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Person[] getPlayers() {
        int size = this.players != null ? this.players.size() : 0;
        Person[] result = new Person[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.players) {
            result[index++] = (Person)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Person[] buildPlayers() {
        int size = this.players != null ? this.players.size() : 0;
        Person[] result = new Person[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.players) {
            result[index++] = (Person)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Person buildPlayer(int index) {
        return this.players.get(index).build();
    }

    @Override
    public Person buildFirstPlayer() {
        return this.players.get(0).build();
    }

    @Override
    public Person buildLastPlayer() {
        return this.players.get(this.players.size() - 1).build();
    }

    @Override
    public Person buildMatchingPlayer(Predicate<PersonBuilder> predicate) {
        for (PersonBuilder item : this.players) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPlayer(Predicate<PersonBuilder> predicate) {
        for (PersonBuilder item : this.players) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToPlayers(int index, Person item) {
        if (this.players == null) {
            this.players = new ArrayList<PersonBuilder>();
        }
        PersonBuilder builder = new PersonBuilder(item);
        this._visitables.get((Object)"players").add(index >= 0 ? index : this._visitables.get((Object)"players").size(), builder);
        this.players.add(index >= 0 ? index : this.players.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPlayers(int index, Person item) {
        if (this.players == null) {
            this.players = new ArrayList<PersonBuilder>();
        }
        PersonBuilder builder = new PersonBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"players").size()) {
            this._visitables.get((Object)"players").add(builder);
        } else {
            this._visitables.get((Object)"players").set(index, builder);
        }
        if (index < 0 || index >= this.players.size()) {
            this.players.add(builder);
        } else {
            this.players.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPlayers(Person ... items) {
        if (this.players == null) {
            this.players = new ArrayList<PersonBuilder>();
        }
        for (Person item : items) {
            PersonBuilder builder = new PersonBuilder(item);
            this._visitables.get((Object)"players").add(builder);
            this.players.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPlayers(Collection<Person> items) {
        if (this.players == null) {
            this.players = new ArrayList<PersonBuilder>();
        }
        for (Person item : items) {
            PersonBuilder builder = new PersonBuilder(item);
            this._visitables.get((Object)"players").add(builder);
            this.players.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPlayers(Person ... items) {
        for (Person item : items) {
            PersonBuilder builder = new PersonBuilder(item);
            this._visitables.get((Object)"players").remove(builder);
            if (this.players == null) continue;
            this.players.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPlayers(Collection<Person> items) {
        for (Person item : items) {
            PersonBuilder builder = new PersonBuilder(item);
            this._visitables.get((Object)"players").remove(builder);
            if (this.players == null) continue;
            this.players.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPlayers(Predicate<PersonBuilder> predicate) {
        if (this.players == null) {
            return (A)this;
        }
        Iterator<PersonBuilder> each = this.players.iterator();
        List visitables = this._visitables.get((Object)"players");
        while (each.hasNext()) {
            PersonBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlayers() {
        return this.players != null && !this.players.isEmpty();
    }

    @Override
    public A addNewPlayer(String firstName, String lastName, int[] numbers) {
        return this.addToPlayers(new Person(firstName, lastName, numbers));
    }

    @Override
    public GameFluent.PlayersNested<A> addNewPlayer() {
        return new PlayersNestedImpl();
    }

    @Override
    public GameFluent.PlayersNested<A> addNewPlayerLike(Person item) {
        return new PlayersNestedImpl(-1, item);
    }

    @Override
    public GameFluent.PlayersNested<A> setNewPlayerLike(int index, Person item) {
        return new PlayersNestedImpl(index, item);
    }

    @Override
    public GameFluent.PlayersNested<A> editPlayer(int index) {
        if (this.players.size() <= index) {
            throw new RuntimeException("Can't edit players. Index exceeds size.");
        }
        return this.setNewPlayerLike(index, this.buildPlayer(index));
    }

    @Override
    public GameFluent.PlayersNested<A> editFirstPlayer() {
        if (this.players.size() == 0) {
            throw new RuntimeException("Can't edit first players. The list is empty.");
        }
        return this.setNewPlayerLike(0, this.buildPlayer(0));
    }

    @Override
    public GameFluent.PlayersNested<A> editLastPlayer() {
        int index = this.players.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last players. The list is empty.");
        }
        return this.setNewPlayerLike(index, this.buildPlayer(index));
    }

    @Override
    public GameFluent.PlayersNested<A> editMatchingPlayer(Predicate<PersonBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.players.size(); ++i) {
            if (!predicate.test(this.players.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching players. No match found.");
        }
        return this.setNewPlayerLike(index, this.buildPlayer(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GameFluentImpl that = (GameFluentImpl)o;
        return !(this.players != null ? !this.players.equals(that.players) : that.players != null);
    }

    public int hashCode() {
        return Objects.hash(this.players, super.hashCode());
    }

    public class PlayersNestedImpl<N>
    extends PersonFluentImpl<GameFluent.PlayersNested<N>>
    implements GameFluent.PlayersNested<N>,
    Nested<N> {
        private final PersonBuilder builder;
        private final int index;

        PlayersNestedImpl(int index, Person item) {
            this.index = index;
            this.builder = new PersonBuilder(this, item);
        }

        PlayersNestedImpl() {
            this.index = -1;
            this.builder = new PersonBuilder(this);
        }

        @Override
        public N and() {
            return (N)GameFluentImpl.this.setToPlayers(this.index, this.builder.build());
        }

        @Override
        public N endPlayer() {
            return this.and();
        }
    }
}

