/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.examples.arrays;

import io.sundr.builder.VisitableBuilder;
import io.sundr.examples.arrays.EditablePerson;
import io.sundr.examples.arrays.Person;
import io.sundr.examples.arrays.PersonFluent;
import io.sundr.examples.arrays.PersonFluentImpl;
import java.util.Objects;

public class PersonBuilder
extends PersonFluentImpl<PersonBuilder>
implements VisitableBuilder<Person, PersonBuilder> {
    PersonFluent<?> fluent;
    Boolean validationEnabled;

    public PersonBuilder() {
        this(true);
    }

    public PersonBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public PersonBuilder(PersonFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PersonBuilder(PersonFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public PersonBuilder(PersonFluent<?> fluent, Person instance) {
        this(fluent, instance, true);
    }

    public PersonBuilder(PersonFluent<?> fluent, Person instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFirstName(instance.getFirstName());
        fluent.withLastName(instance.getLastName());
        fluent.withNumbers(instance.getNumbers());
        this.validationEnabled = validationEnabled;
    }

    public PersonBuilder(Person instance) {
        this(instance, (Boolean)true);
    }

    public PersonBuilder(Person instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFirstName(instance.getFirstName());
        this.withLastName(instance.getLastName());
        this.withNumbers(instance.getNumbers());
        this.validationEnabled = validationEnabled;
    }

    public EditablePerson build() {
        EditablePerson buildable = new EditablePerson(this.fluent.getFirstName(), this.fluent.getLastName(), this.fluent.getNumbers());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersonBuilder that = (PersonBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

