/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.examples.arrays;

import io.sundr.builder.BaseFluent;
import io.sundr.examples.arrays.Person;
import io.sundr.examples.arrays.PersonFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PersonFluentImpl<A extends PersonFluent<A>>
extends BaseFluent<A>
implements PersonFluent<A> {
    private String firstName;
    private String lastName;
    private List<Integer> numbers;

    public PersonFluentImpl() {
    }

    public PersonFluentImpl(Person instance) {
        this.withFirstName(instance.getFirstName());
        this.withLastName(instance.getLastName());
        this.withNumbers(instance.getNumbers());
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public A withFirstName(String firstName) {
        this.firstName = firstName;
        return (A)this;
    }

    @Override
    public Boolean hasFirstName() {
        return this.firstName != null;
    }

    @Override
    @Deprecated
    public A withNewFirstName(String arg0) {
        return this.withFirstName(new String(arg0));
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public A withLastName(String lastName) {
        this.lastName = lastName;
        return (A)this;
    }

    @Override
    public Boolean hasLastName() {
        return this.lastName != null;
    }

    @Override
    @Deprecated
    public A withNewLastName(String arg0) {
        return this.withLastName(new String(arg0));
    }

    @Override
    public A withNumbers(int ... numbers) {
        if (this.numbers != null) {
            this.numbers.clear();
        }
        if (numbers != null) {
            for (int item : numbers) {
                this.addToNumbers(item);
            }
        }
        return (A)this;
    }

    @Override
    public int[] getNumbers() {
        int size = this.numbers != null ? this.numbers.size() : 0;
        int[] result = new int[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (int item : this.numbers) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToNumbers(int index, Integer item) {
        if (this.numbers == null) {
            this.numbers = new ArrayList<Integer>();
        }
        this.numbers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNumbers(int index, Integer item) {
        if (this.numbers == null) {
            this.numbers = new ArrayList<Integer>();
        }
        this.numbers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNumbers(Integer ... items) {
        if (this.numbers == null) {
            this.numbers = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.numbers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNumbers(Collection<Integer> items) {
        if (this.numbers == null) {
            this.numbers = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.numbers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNumbers(Integer ... items) {
        for (Integer item : items) {
            if (this.numbers == null) continue;
            this.numbers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNumbers(Collection<Integer> items) {
        for (Integer item : items) {
            if (this.numbers == null) continue;
            this.numbers.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNumbers() {
        return this.numbers != null && !this.numbers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonFluentImpl that = (PersonFluentImpl)o;
        if (this.firstName != null ? !this.firstName.equals(that.firstName) : that.firstName != null) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(that.lastName) : that.lastName != null) {
            return false;
        }
        return !(this.numbers != null ? !this.numbers.equals(that.numbers) : that.numbers != null);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.numbers, super.hashCode());
    }
}

