/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import swaydb.ActorWire;
import swaydb.Bag;
import swaydb.Bag$;
import swaydb.Error;
import swaydb.IO;
import swaydb.IO$;
import swaydb.Scheduler$;
import swaydb.compression.CompressionInternal;
import swaydb.core.Core;
import swaydb.core.actor.FileSweeper;
import swaydb.core.actor.FileSweeper$;
import swaydb.core.actor.MemorySweeper;
import swaydb.core.actor.MemorySweeper$;
import swaydb.core.function.FunctionStore;
import swaydb.core.io.file.BlockCache;
import swaydb.core.io.file.BlockCache$;
import swaydb.core.io.file.BufferCleaner$;
import swaydb.core.io.file.Effect;
import swaydb.core.level.Level;
import swaydb.core.level.Level$;
import swaydb.core.level.NextLevel;
import swaydb.core.level.TrashLevel$;
import swaydb.core.level.compaction.Compactor;
import swaydb.core.level.compaction.throttle.ThrottleCompactor$;
import swaydb.core.level.compaction.throttle.ThrottleState;
import swaydb.core.level.zero.LevelZero;
import swaydb.core.level.zero.LevelZero$;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchIndexBlock$Config$;
import swaydb.core.segment.format.a.block.bloomfilter.BloomFilterBlock$Config$;
import swaydb.core.segment.format.a.block.hashindex.HashIndexBlock$Config$;
import swaydb.core.segment.format.a.block.segment.SegmentBlock;
import swaydb.core.segment.format.a.block.segment.SegmentBlock$Config$;
import swaydb.core.segment.format.a.block.sortedindex.SortedIndexBlock$Config$;
import swaydb.core.segment.format.a.block.values.ValuesBlock$Config$;
import swaydb.data.accelerate.Accelerator;
import swaydb.data.accelerate.LevelZeroMeter;
import swaydb.data.compaction.CompactionExecutionContext;
import swaydb.data.compaction.LevelMeter;
import swaydb.data.compaction.Throttle;
import swaydb.data.config.Dir;
import swaydb.data.config.FileCache;
import swaydb.data.config.IOAction;
import swaydb.data.config.IOStrategy;
import swaydb.data.config.LevelConfig;
import swaydb.data.config.LevelZeroMemoryConfig;
import swaydb.data.config.LevelZeroPersistentConfig;
import swaydb.data.config.MemoryCache;
import swaydb.data.config.MemoryLevelConfig;
import swaydb.data.config.PersistentLevelConfig;
import swaydb.data.config.SwayDBConfig;
import swaydb.data.config.ThreadStateCache;
import swaydb.data.config.TrashLevelConfig$;
import swaydb.data.config.UncompressedBlockInfo;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.Slice;
import swaydb.data.storage.AppendixStorage;
import swaydb.data.storage.Level0Storage;
import swaydb.data.storage.LevelStorage;

public final class CoreInitializer$
implements LazyLogging {
    public static final CoreInitializer$ MODULE$ = new CoreInitializer$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private IO<Error.Close, BoxedUnit> closeLevels(LevelZero zero) {
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Closing files.");
        }
        zero.close().onLeftSideEffect((Function1 & Serializable)error -> {
            CoreInitializer$.$anonfun$closeLevels$1(error);
            return BoxedUnit.UNIT;
        }).onRightSideEffect((Function1 & Serializable)x$1 -> {
            CoreInitializer$.$anonfun$closeLevels$2(x$1);
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Releasing locks.");
        }
        return zero.releaseLocks().onLeftSideEffect((Function1 & Serializable)error -> {
            CoreInitializer$.$anonfun$closeLevels$3(error);
            return BoxedUnit.UNIT;
        }).onRightSideEffect((Function1 & Serializable)x$2 -> {
            CoreInitializer$.$anonfun$closeLevels$4(x$2);
            return BoxedUnit.UNIT;
        });
    }

    private void addShutdownHook(LevelZero zero, ActorWire<Compactor<ThrottleState>, ThrottleState> compactor, ExecutionContext executionContext) {
        scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            IO.Right right;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Shutting down compaction.");
            }
            Error.Level$.ExceptionHandler$ apply_evidence$13 = Error.Level$.ExceptionHandler$.MODULE$;
            try {
                Await$.MODULE$.result((Awaitable)CoreInitializer$.compactionShutdown$1(compactor, executionContext), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
                right = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            IO.Right right2 = right;
            Object var3_3 = null;
            Object var4_6 = null;
            right = null;
            right2.onLeftSideEffect((Function1 & Serializable)error -> {
                CoreInitializer$.$anonfun$addShutdownHook$4(error);
                return BoxedUnit.UNIT;
            }).onRightSideEffect((Function1 & Serializable)x$3 -> {
                CoreInitializer$.$anonfun$addShutdownHook$5(x$3);
                return BoxedUnit.UNIT;
            });
            MODULE$.closeLevels(zero);
        });
    }

    private void addShutdownHookNoCompaction(LevelZero zero) {
        scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.closeLevels(zero));
    }

    /*
     * WARNING - void declaration
     */
    public IO<Error.Boot, Core<Object>> apply(LevelZeroPersistentConfig config, boolean enableTimer, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<ExecutionContext> bufferCleanerEC) {
        IO.Right right;
        if (config.storage().isMMAP() && bufferCleanerEC.isEmpty()) {
            void failed_evidence$21;
            Error.Boot$.ExceptionHandler$ exceptionHandler$ = Error.Boot$.ExceptionHandler$.MODULE$;
            String failed_exceptionMessage = "ExecutionContext for ByteBuffer is required for memory-mapped configured databases.";
            Exception failed_toError_exception = new Exception(failed_exceptionMessage);
            Object var13_9 = null;
            return new IO.Left((Object)failed_evidence$21.toError((Throwable)failed_toError_exception), (IO.ExceptionHandler)failed_evidence$21);
        }
        IO<Error.Level, LevelZero> iO = LevelZero$.MODULE$.apply(config.mapSize(), config.storage(), enableTimer, false, (Option<NextLevel>)None$.MODULE$, (Function1<LevelZeroMeter, Accelerator>)config.acceleration(), (Function1<LevelZeroMeter, FiniteDuration>)config.throttle(), keyOrder, timeOrder, functionStore);
        if (iO instanceof IO.Right) {
            IO.Right right2;
            LevelZero zero = (LevelZero)((IO.Right)iO).value();
            bufferCleanerEC.foreach((Function1 & Serializable)ec -> {
                BufferCleaner$.MODULE$.initialiseCleaner(Scheduler$.MODULE$.apply((Option)None$.MODULE$, true, ec));
                return BoxedUnit.UNIT;
            });
            this.addShutdownHookNoCompaction(zero);
            Error.Boot$.ExceptionHandler$ apply_evidence$13 = Error.Boot$.ExceptionHandler$.MODULE$;
            try {
                right2 = new IO.Right((Object)CoreInitializer$.$anonfun$apply$2(zero), (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right2 = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            IO.Right right3 = right2;
            Object var14_12 = null;
            Object var15_15 = null;
            right2 = null;
            right = right3;
        } else if (iO instanceof IO.Left) {
            void failed_evidence$20;
            IO.Left left;
            Error.Level error = (Error.Level)((IO.Left)iO).value();
            Error.Boot$.ExceptionHandler$ exceptionHandler$ = Error.Boot$.ExceptionHandler$.MODULE$;
            Throwable failed_exception = error.exception();
            IO.Left left2 = left = new IO.Left((Object)failed_evidence$20.toError(failed_exception), (IO.ExceptionHandler)failed_evidence$20);
            Object var17_19 = null;
            exceptionHandler$ = null;
            left = null;
            right = left2;
        } else {
            throw new MatchError(iO);
        }
        return right;
    }

    /*
     * WARNING - void declaration
     */
    public IO<Error.Boot, Core<Object>> apply(LevelZeroMemoryConfig config, boolean enableTimer, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore) {
        IO.Right right;
        long x$1 = config.mapSize();
        Level0Storage x$2 = config.storage();
        None$ x$3 = None$.MODULE$;
        Function1 x$6 = config.throttle();
        Function1 x$7 = config.acceleration();
        IO<Error.Level, LevelZero> iO = LevelZero$.MODULE$.apply(x$1, x$2, enableTimer, false, (Option<NextLevel>)x$3, (Function1<LevelZeroMeter, Accelerator>)x$7, (Function1<LevelZeroMeter, FiniteDuration>)x$6, keyOrder, timeOrder, functionStore);
        if (iO instanceof IO.Right) {
            IO.Right right2;
            LevelZero zero = (LevelZero)((IO.Right)iO).value();
            this.addShutdownHookNoCompaction(zero);
            Error.Boot$.ExceptionHandler$ apply_evidence$13 = Error.Boot$.ExceptionHandler$.MODULE$;
            try {
                right2 = new IO.Right((Object)CoreInitializer$.$anonfun$apply$4(zero), (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right2 = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            IO.Right right3 = right2;
            Object var16_13 = null;
            Object var17_16 = null;
            right2 = null;
            right = right3;
        } else if (iO instanceof IO.Left) {
            void failed_evidence$20;
            IO.Left left;
            Error.Level error = (Error.Level)((IO.Left)iO).value();
            Error.Boot$.ExceptionHandler$ exceptionHandler$ = Error.Boot$.ExceptionHandler$.MODULE$;
            Throwable failed_exception = error.exception();
            IO.Left left2 = left = new IO.Left((Object)failed_evidence$20.toError(failed_exception), (IO.ExceptionHandler)failed_evidence$20);
            Object var19_20 = null;
            exceptionHandler$ = null;
            left = null;
            right = left2;
        } else {
            throw new MatchError(iO);
        }
        return right;
    }

    public Option<CompactionExecutionContext> executionContext(LevelConfig levelConfig) {
        None$ none$;
        if (TrashLevelConfig$.MODULE$.equals(levelConfig)) {
            none$ = None$.MODULE$;
        } else if (levelConfig instanceof MemoryLevelConfig) {
            MemoryLevelConfig memoryLevelConfig = (MemoryLevelConfig)levelConfig;
            none$ = new Some((Object)memoryLevelConfig.compactionExecutionContext());
        } else if (levelConfig instanceof PersistentLevelConfig) {
            PersistentLevelConfig persistentLevelConfig = (PersistentLevelConfig)levelConfig;
            none$ = new Some((Object)persistentLevelConfig.compactionExecutionContext());
        } else {
            throw new MatchError((Object)levelConfig);
        }
        return none$;
    }

    public List<CompactionExecutionContext> executionContexts(SwayDBConfig config) {
        return (List)((IterableOps)new .colon.colon((Object)config.level0().compactionExecutionContext(), (List)Nil$.MODULE$).$plus$plus((IterableOnce)this.executionContext(config.level1()).toList())).$plus$plus((IterableOnce)config.otherLevels().flatMap((Function1 & Serializable)levelConfig -> MODULE$.executionContext((LevelConfig)levelConfig)));
    }

    public IO<Error.Level, ActorWire<Compactor<ThrottleState>, ThrottleState>> initialiseCompaction(LevelZero zero, List<CompactionExecutionContext> executionContexts, Compactor<ThrottleState> compactionStrategy) {
        return compactionStrategy.createAndListen(zero, executionContexts);
    }

    /*
     * WARNING - void declaration
     */
    public void sendInitialWakeUp(ActorWire<Compactor<ThrottleState>, ThrottleState> compactor) {
        void send_function;
        Function3 & Serializable intersect = (Function3 & Serializable)(impl, state, self) -> {
            impl.wakeUp(state, true, self);
            return BoxedUnit.UNIT;
        };
        if (compactor == null) {
            throw null;
        }
        compactor.swaydb$ActorWire$$actor().send((arg_0, arg_1) -> ActorWire.$anonfun$send$2$adapted(compactor, (Function3)send_function, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public IO<Error.Boot, Core<Object>> apply(SwayDBConfig config, boolean enableTimer, boolean cacheKeyValueIds, FileCache.Enable fileCache, ThreadStateCache threadStateCache, MemoryCache memoryCache, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore) {
        IO.Right right;
        IO iO;
        FileSweeper.Enabled fileSweeper = FileSweeper$.MODULE$.apply(fileCache);
        Option<MemorySweeper.Enabled> memorySweeper2 = MemorySweeper$.MODULE$.apply(memoryCache);
        Option blockCache = memorySweeper2.flatMap((Function1 & Serializable)memorySweeper -> BlockCache$.MODULE$.init((MemorySweeper)memorySweeper));
        Option keyValueMemorySweeper = memorySweeper2.flatMap((Function1 & Serializable)enabled -> {
            Some some;
            if (enabled instanceof MemorySweeper.All) {
                MemorySweeper.All all = (MemorySweeper.All)enabled;
                some = new Some((Object)all);
            } else if (enabled instanceof MemorySweeper.KeyValueSweeper) {
                MemorySweeper.KeyValueSweeper keyValueSweeper = (MemorySweeper.KeyValueSweeper)enabled;
                some = new Some((Object)keyValueSweeper);
            } else if (enabled instanceof MemorySweeper.BlockSweeper) {
                some = None$.MODULE$;
            } else {
                throw new MatchError(enabled);
            }
            return some;
        });
        ThrottleCompactor$ compactionStrategy = ThrottleCompactor$.MODULE$;
        if (config.hasMMAP()) {
            BufferCleaner$.MODULE$.initialiseCleaner(Scheduler$.MODULE$.apply((Option)None$.MODULE$, true, fileSweeper.ec()));
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Booting {} Levels.", (Object)BoxesRunTime.boxToInteger((int)(config.otherLevels().size() + 2)));
        }
        if ((iO = CoreInitializer$.createLevels$1(config.otherLevels().reverse(), (Option)None$.MODULE$, config, enableTimer, cacheKeyValueIds, keyOrder, timeOrder, functionStore, compactionStrategy, threadStateCache, keyValueMemorySweeper, blockCache, fileSweeper)) instanceof IO.Right) {
            IO.Right right2;
            Core core = (Core)((IO.Right)iO).value();
            Error.Boot$.ExceptionHandler$ apply_evidence$13 = Error.Boot$.ExceptionHandler$.MODULE$;
            try {
                right2 = new IO.Right((Object)core, (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right2 = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            IO.Right right3 = right2;
            Object var19_17 = null;
            Object var20_20 = null;
            right2 = null;
            right = right3;
        } else if (iO instanceof IO.Left) {
            void failed_evidence$20;
            IO.Left left;
            Error.Level error = (Error.Level)((IO.Left)iO).value();
            Error.Boot$.ExceptionHandler$ exceptionHandler$ = Error.Boot$.ExceptionHandler$.MODULE$;
            Throwable failed_exception = error.exception();
            IO.Left left2 = left = new IO.Left((Object)failed_evidence$20.toError(failed_exception), (IO.ExceptionHandler)failed_evidence$20);
            Object var22_24 = null;
            exceptionHandler$ = null;
            left = null;
            right = left2;
        } else {
            throw new MatchError((Object)iO);
        }
        return right;
    }

    public Option<ExecutionContext> apply$default$6(LevelZeroPersistentConfig config, boolean enableTimer) {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$closeLevels$1(IO.Left error) {
        if (MODULE$.logger().underlying().isErrorEnabled()) {
            MODULE$.logger().underlying().error("Failed to close files.", error.exception());
        }
    }

    public static final /* synthetic */ void $anonfun$closeLevels$2(BoxedUnit x$1) {
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Files closed!");
        }
    }

    public static final /* synthetic */ void $anonfun$closeLevels$3(IO.Left error) {
        if (MODULE$.logger().underlying().isErrorEnabled()) {
            MODULE$.logger().underlying().error("Failed to release locks.", error.exception());
        }
    }

    public static final /* synthetic */ void $anonfun$closeLevels$4(BoxedUnit x$2) {
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Locks released!");
        }
    }

    private static final Future compactionShutdown$1(ActorWire compactor$1, ExecutionContext executionContext$1) {
        return (Future)compactor$1.ask().flatMap((Function3 & Serializable)(impl, state, self) -> impl.terminate(state, self), (Bag.Async)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final /* synthetic */ void $anonfun$addShutdownHook$4(IO.Left error) {
        if (MODULE$.logger().underlying().isErrorEnabled()) {
            MODULE$.logger().underlying().error("Failed compaction shutdown.", error.exception());
        }
    }

    public static final /* synthetic */ void $anonfun$addShutdownHook$5(BoxedUnit x$3) {
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Compaction stopped!");
        }
    }

    public static final /* synthetic */ Core $anonfun$apply$2(LevelZero zero$3) {
        return new Core(zero$3, (ThreadStateCache)ThreadStateCache.NoLimit$.MODULE$, (Function0<IO.Defer<Error.Close, BoxedUnit>>)(Function0 & Serializable)() -> IO.Defer$.MODULE$.unit(), Bag$.MODULE$.less());
    }

    public static final /* synthetic */ Core $anonfun$apply$4(LevelZero zero$4) {
        return new Core(zero$4, (ThreadStateCache)ThreadStateCache.NoLimit$.MODULE$, (Function0<IO.Defer<Error.Close, BoxedUnit>>)(Function0 & Serializable)() -> IO.Defer$.MODULE$.unit(), Bag$.MODULE$.less());
    }

    /*
     * WARNING - void declaration
     */
    private static final IO createLevel$1(long id, Option nextLevel, LevelConfig config, KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, Option keyValueMemorySweeper$1, Option blockCache$1, FileSweeper.Enabled fileSweeper$1) {
        IO<Error.Level, Level> iO;
        if (config instanceof MemoryLevelConfig) {
            void apply_deleteEventually;
            void apply_mmapReads;
            void apply_mmapWrites;
            void apply_pushForward;
            void apply_maxCount;
            void apply_minSize;
            void apply_cacheBlocksOnCreate;
            void apply_compressions;
            MemoryLevelConfig memoryLevelConfig = (MemoryLevelConfig)config;
            Function1 & Serializable intersect = (Function1 & Serializable)x$5 -> (Seq)Seq$.MODULE$.empty();
            boolean bl = memoryLevelConfig.deleteSegmentsEventually();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = memoryLevelConfig.copyForward();
            int n = memoryLevelConfig.maxKeyValuesPerSegment();
            int n2 = memoryLevelConfig.minSegmentSize();
            boolean bl5 = false;
            Function1 & Serializable apply_ioStrategy = (Function1 & Serializable)x$4 -> new IOStrategy.ConcurrentIO(false);
            Function1 & Serializable apply_applyInternal_compressions = arg_0 -> SegmentBlock$Config$.$anonfun$apply$1((Function1)apply_compressions, arg_0);
            Object var22_19 = null;
            Object var13_18 = null;
            intersect = null;
            iO = Level$.MODULE$.apply(BloomFilterBlock$Config$.MODULE$.disabled(), HashIndexBlock$Config$.MODULE$.disabled(), BinarySearchIndexBlock$Config$.MODULE$.disabled(), SortedIndexBlock$Config$.MODULE$.disabled(), ValuesBlock$Config$.MODULE$.disabled(), new SegmentBlock.Config((Function1<IOAction, IOStrategy>)apply_ioStrategy, (boolean)apply_cacheBlocksOnCreate, RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)apply_minSize), 1), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)apply_maxCount), 1), (boolean)apply_pushForward, (boolean)apply_mmapWrites, (boolean)apply_mmapReads, (boolean)apply_deleteEventually, (Function1<UncompressedBlockInfo, Seq<CompressionInternal>>)apply_applyInternal_compressions), (LevelStorage)new LevelStorage.Memory(Paths.get("MEMORY_LEVEL", new String[0]).resolve(((Object)BoxesRunTime.boxToLong((long)id)).toString())), (AppendixStorage)AppendixStorage.Memory$.MODULE$, (Option<NextLevel>)nextLevel, (Function1<LevelMeter, Throttle>)memoryLevelConfig.throttle(), (KeyOrder<Slice<Object>>)keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1, (Option<MemorySweeper.KeyValue>)keyValueMemorySweeper$1, (Option<BlockCache.State>)blockCache$1, fileSweeper$1);
        } else if (config instanceof PersistentLevelConfig) {
            PersistentLevelConfig persistentLevelConfig = (PersistentLevelConfig)config;
            iO = Level$.MODULE$.apply(BloomFilterBlock$Config$.MODULE$.apply(persistentLevelConfig.mightContainKeyIndex()), HashIndexBlock$Config$.MODULE$.apply(persistentLevelConfig.randomKeyIndex()), BinarySearchIndexBlock$Config$.MODULE$.apply(persistentLevelConfig.binarySearchIndex()), SortedIndexBlock$Config$.MODULE$.apply(persistentLevelConfig.sortedKeyIndex()), ValuesBlock$Config$.MODULE$.apply(persistentLevelConfig.values()), SegmentBlock$Config$.MODULE$.apply(persistentLevelConfig.segment()), (LevelStorage)new LevelStorage.Persistent(persistentLevelConfig.dir().resolve(((Object)BoxesRunTime.boxToLong((long)id)).toString()), (Seq)persistentLevelConfig.otherDirs().map((Function1 & Serializable)dir -> dir.copy(dir.path().resolve(((Object)BoxesRunTime.boxToLong((long)id)).toString()), dir.copy$default$2()))), (AppendixStorage)new AppendixStorage.Persistent(persistentLevelConfig.mmapAppendix(), persistentLevelConfig.appendixFlushCheckpointSize()), (Option<NextLevel>)nextLevel, (Function1<LevelMeter, Throttle>)persistentLevelConfig.throttle(), (KeyOrder<Slice<Object>>)keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1, (Option<MemorySweeper.KeyValue>)keyValueMemorySweeper$1, (Option<BlockCache.State>)blockCache$1, fileSweeper$1);
        } else if (TrashLevelConfig$.MODULE$.equals(config)) {
            iO = new IO<Error.Level, Level>((Object)TrashLevel$.MODULE$, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
        } else {
            throw new MatchError((Object)config);
        }
        return iO;
    }

    private static final IO.Defer onClose$1(ActorWire compactor$2, ExecutionContext shutdownEC$1) {
        return IO$.MODULE$.fromFuture((Future)compactor$2.ask().flatMap((Function3 & Serializable)(impl, state, actor) -> impl.terminate(state, actor), (Bag.Async)new /* Unavailable Anonymous Inner Class!! */), (IO.ExceptionHandler)Error.Close$.ExceptionHandler$.MODULE$, shutdownEC$1);
    }

    public static final /* synthetic */ long $anonfun$apply$18(Dir x$7) {
        Path PathExtensionImplicits_path = x$7.path();
        Object var1_1 = null;
        return new Effect.PathExtensionImplicits(PathExtensionImplicits_path).folderId() - 1L;
    }

    private static final IO createLevels$1(List levelConfigs, Option previousLowerLevel, SwayDBConfig config$1, boolean enableTimer$1, boolean cacheKeyValueIds$1, KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, Compactor compactionStrategy$1, ThreadStateCache threadStateCache$1, Option keyValueMemorySweeper$1, Option blockCache$1, FileSweeper.Enabled fileSweeper$1) {
        IO iO;
        if (Nil$.MODULE$.equals(levelConfigs)) {
            iO = CoreInitializer$.createLevel$1(1L, previousLowerLevel, config$1.level1(), keyOrder$1, timeOrder$1, functionStore$1, keyValueMemorySweeper$1, blockCache$1, fileSweeper$1).flatMap((Function1 & Serializable)level1 -> {
                long x$1 = config$1.level0().mapSize();
                Level0Storage x$2 = config$1.level0().storage();
                Some x$5 = new Some(level1);
                Function1 x$6 = config$1.level0().throttle();
                Function1 x$7 = config$1.level0().acceleration();
                return LevelZero$.MODULE$.apply(x$1, x$2, enableTimer$1, cacheKeyValueIds$1, (Option<NextLevel>)x$5, (Function1<LevelZeroMeter, Accelerator>)x$7, (Function1<LevelZeroMeter, FiniteDuration>)x$6, (KeyOrder<Slice<Object>>)keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1).flatMap((Function1 & Serializable)zero -> {
                    List<CompactionExecutionContext> contexts = MODULE$.executionContexts(config$1);
                    return compactionStrategy$1.createAndListen((LevelZero)zero, contexts).map((Function1 & Serializable)compactor -> {
                        ExecutionContext shutdownEC = (ExecutionContext)contexts.collectFirst((PartialFunction)new Serializable(){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends CompactionExecutionContext, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object = x1 instanceof CompactionExecutionContext.Create ? ((CompactionExecutionContext.Create)x1).executionContext() : function1.apply(x1);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(CompactionExecutionContext x1) {
                                boolean bl = x1 instanceof CompactionExecutionContext.Create;
                                return bl;
                            }
                        }).getOrElse((Function0 & Serializable)() -> ExecutionContext.Implicits$.MODULE$.global());
                        MODULE$.addShutdownHook((LevelZero)zero, (ActorWire<Compactor<ThrottleState>, ThrottleState>)compactor, shutdownEC);
                        MODULE$.sendInitialWakeUp((ActorWire<Compactor<ThrottleState>, ThrottleState>)compactor);
                        return new Core((LevelZero)zero, threadStateCache$1, (Function0<IO.Defer<Error.Close, BoxedUnit>>)(Function0 & Serializable)() -> CoreInitializer$.onClose$1(compactor, shutdownEC), Bag$.MODULE$.less());
                    });
                }, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
            }, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
        } else if (levelConfigs instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)levelConfigs;
            LevelConfig lowestLevelConfig = (LevelConfig)colon2.head();
            List upperLevelConfigs = colon2.next$access$1();
            iO = CoreInitializer$.createLevel$1(BoxesRunTime.unboxToLong((Object)previousLowerLevel.flatMap((Function1 & Serializable)x$6 -> x$6.pathDistributor().headOption().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)CoreInitializer$.$anonfun$apply$18(x$7)))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> levelConfigs.size() + 1)), previousLowerLevel, lowestLevelConfig, keyOrder$1, timeOrder$1, functionStore$1, keyValueMemorySweeper$1, blockCache$1, fileSweeper$1).flatMap((Function1 & Serializable)newLowerLevel -> CoreInitializer$.createLevels$1(upperLevelConfigs, (Option)new Some(newLowerLevel), config$1, enableTimer$1, cacheKeyValueIds$1, keyOrder$1, timeOrder$1, functionStore$1, compactionStrategy$1, threadStateCache$1, keyValueMemorySweeper$1, blockCache$1, fileSweeper$1), (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
        } else {
            throw new MatchError((Object)levelConfigs);
        }
        return iO;
    }

    public static final /* synthetic */ Core $anonfun$apply$21(Core core$1) {
        return core$1;
    }

    private CoreInitializer$() {
    }
}

