/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.actor;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.ref.WeakReference;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import swaydb.Actor;
import swaydb.Actor$;
import swaydb.ActorRef;
import swaydb.core.actor.FileSweeper;
import swaydb.core.actor.FileSweeperItem;
import swaydb.data.config.ActorConfig;
import swaydb.data.config.FileCache;

public final class FileSweeper$
implements LazyLogging {
    public static final FileSweeper$ MODULE$ = new FileSweeper$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public int weigher(FileSweeper.Action action) {
        if (action.isDelete()) {
            return 10;
        }
        return 1;
    }

    public Option<FileSweeper.Enabled> apply(FileCache fileCache) {
        None$ none$;
        if (FileCache.Disable$.MODULE$.equals(fileCache)) {
            none$ = None$.MODULE$;
        } else if (fileCache instanceof FileCache.Enable) {
            FileCache.Enable enable = (FileCache.Enable)fileCache;
            none$ = new Some((Object)this.apply(enable));
        } else {
            throw new MatchError((Object)fileCache);
        }
        return none$;
    }

    public FileSweeper.Enabled apply(FileCache.Enable fileCache) {
        return this.apply(fileCache.maxOpen(), fileCache.actorConfig());
    }

    public FileSweeper.Enabled apply(int maxOpenSegments, ActorConfig actorConfig) {
        LazyRef queue$lzy = new LazyRef();
        return new FileSweeper.Enabled(actorConfig, queue$lzy, maxOpenSegments){
            private final ActorConfig actorConfig$1;
            private final LazyRef queue$lzy$1;
            private final int maxOpenSegments$1;

            public ExecutionContext ec() {
                return this.actorConfig$1.ec();
            }

            public void close(FileSweeperItem file) {
                FileSweeper$.swaydb$core$actor$FileSweeper$$queue$1(this.queue$lzy$1, this.actorConfig$1, this.maxOpenSegments$1).send((Object)new FileSweeper.Action.Close((WeakReference<FileSweeperItem>)new WeakReference((Object)file)));
            }

            public void delete(FileSweeperItem file) {
                FileSweeper$.swaydb$core$actor$FileSweeper$$queue$1(this.queue$lzy$1, this.actorConfig$1, this.maxOpenSegments$1).send((Object)new FileSweeper.Action.Delete(file));
            }

            public void terminate() {
                FileSweeper$.swaydb$core$actor$FileSweeper$$queue$1(this.queue$lzy$1, this.actorConfig$1, this.maxOpenSegments$1).terminateAndClear();
            }
            {
                this.actorConfig$1 = actorConfig$1;
                this.queue$lzy$1 = queue$lzy$1;
                this.maxOpenSegments$1 = maxOpenSegments$1;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$apply$3(FileSweeperItem file) {
        try {
            file.close();
            return;
        }
        catch (Exception exception) {
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new StringBuilder(22).append("Failed to close file. ").append(file.path()).toString(), (Throwable)exception);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$apply$2(FileSweeper.Action x0$1, Actor x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (x0$1 instanceof FileSweeper.Action.Delete) {
            FileSweeperItem file2 = ((FileSweeper.Action.Delete)x0$1).file();
            try {
                file2.delete();
                return;
            }
            catch (Exception exception) {
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error(new StringBuilder(23).append("Failed to delete file. ").append(file2.path()).toString(), (Throwable)exception);
                    return;
                }
            }
        } else {
            if (x0$1 instanceof FileSweeper.Action.Close) {
                ((FileSweeper.Action.Close)x0$1).file().get().foreach((Function1 & Serializable)file -> {
                    FileSweeper$.$anonfun$apply$3(file);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }

    private static final /* synthetic */ ActorRef queue$lzycompute$1(LazyRef queue$lzy$1, ActorConfig actorConfig$1, int maxOpenSegments$1) {
        synchronized (queue$lzy$1) {
            ActorRef actorRef = queue$lzy$1.initialized() ? (ActorRef)queue$lzy$1.value() : (ActorRef)queue$lzy$1.initialize((Object)Actor$.MODULE$.cacheFromConfig(actorConfig$1, maxOpenSegments$1, (Function1 & Serializable)action -> BoxesRunTime.boxToInteger((int)FileSweeper$.MODULE$.weigher(action)), (Function2 & Serializable)(x0$1, x1$1) -> {
                FileSweeper$.$anonfun$apply$2(x0$1, x1$1);
                return BoxedUnit.UNIT;
            }));
            return actorRef;
        }
    }

    public static final ActorRef swaydb$core$actor$FileSweeper$$queue$1(LazyRef queue$lzy$1, ActorConfig actorConfig$1, int maxOpenSegments$1) {
        if (queue$lzy$1.initialized()) {
            return (ActorRef)queue$lzy$1.value();
        }
        return FileSweeper$.queue$lzycompute$1(queue$lzy$1, actorConfig$1, maxOpenSegments$1);
    }

    private FileSweeper$() {
    }
}

