/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.actor;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import swaydb.core.actor.Command;
import swaydb.core.actor.MemorySweeper;
import swaydb.core.data.Persistent;
import swaydb.data.config.ActorConfig;
import swaydb.data.config.MemoryCache;
import swaydb.data.util.ByteSizeOf$;

public final class MemorySweeper$ {
    public static final MemorySweeper$ MODULE$ = new MemorySweeper$();

    public Option<MemorySweeper.Enabled> apply(MemoryCache memoryCache) {
        None$ none$;
        if (MemoryCache.Disable$.MODULE$.equals(memoryCache)) {
            none$ = None$.MODULE$;
        } else if (memoryCache instanceof MemoryCache.ByteCacheOnly) {
            MemoryCache.ByteCacheOnly byteCacheOnly = (MemoryCache.ByteCacheOnly)memoryCache;
            none$ = new Some((Object)new MemorySweeper.BlockSweeper(byteCacheOnly.minIOSeekSize(), byteCacheOnly.cacheCapacity(), byteCacheOnly.skipBlockCacheSeekSize(), (Option<ActorConfig>)new Some((Object)byteCacheOnly.actorConfig())));
        } else if (memoryCache instanceof MemoryCache.KeyValueCacheOnly) {
            MemoryCache.KeyValueCacheOnly keyValueCacheOnly = (MemoryCache.KeyValueCacheOnly)memoryCache;
            int capacity = keyValueCacheOnly.cacheCapacity();
            Option maxKeyValuesPerSegment = keyValueCacheOnly.maxCachedKeyValueCountPerSegment();
            Option actorConfig = keyValueCacheOnly.actorConfig();
            none$ = new Some((Object)new MemorySweeper.KeyValueSweeper(capacity, (Option<Object>)maxKeyValuesPerSegment, (Option<ActorConfig>)actorConfig));
        } else if (memoryCache instanceof MemoryCache.All) {
            MemoryCache.All all = (MemoryCache.All)memoryCache;
            int x$1 = all.minIOSeekSize();
            int x$2 = all.cacheCapacity();
            int x$3 = all.skipBlockCacheSeekSize();
            boolean x$4 = all.sweepCachedKeyValues();
            Option x$5 = all.maxCachedKeyValueCountPerSegment();
            Some x$6 = new Some((Object)all.actorConfig());
            none$ = new Some((Object)new MemorySweeper.All(x$1, x$2, x$3, (Option<Object>)x$5, x$4, (Option<ActorConfig>)x$6));
        } else {
            throw new MatchError((Object)memoryCache);
        }
        return none$;
    }

    public int weigher(Command entry) {
        int n;
        if (entry instanceof Command.BlockCache) {
            Command.BlockCache blockCache = (Command.BlockCache)entry;
            n = ByteSizeOf$.MODULE$.long() + blockCache.valueSize() + 264;
        } else if (entry instanceof Command.Cache) {
            Command.Cache cache = (Command.Cache)entry;
            n = ByteSizeOf$.MODULE$.long() + cache.weight() + 264;
        } else if (entry instanceof Command.KeyValue) {
            n = BoxesRunTime.unboxToInt((Object)((Command.KeyValue)entry).keyValueRef().get().map((Function1 & Serializable)keyValue -> BoxesRunTime.boxToInteger((int)MemorySweeper$.$anonfun$weigher$1(keyValue))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 264));
        } else {
            throw new MatchError((Object)entry);
        }
        return n;
    }

    public double weight(Persistent keyValue) {
        double otherBytes = (Math.ceil((double)keyValue.key().size() + (double)keyValue.valueLength() / 8.0) - 1.0) * (double)8;
        return (double)528 + otherBytes;
    }

    public static final /* synthetic */ int $anonfun$weigher$1(Persistent keyValue) {
        return (int)MODULE$.weight(keyValue);
    }

    private MemorySweeper$() {
    }
}

